/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component;

import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeDescriber;
import org.gradle.internal.component.AmbiguousConfigurationSelectionException;
import org.gradle.internal.component.model.AttributeMatcher;
import org.gradle.internal.component.model.ComponentGraphResolveMetadata;
import org.gradle.internal.exceptions.StyledException;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.TreeFormatter;

public class IncompatibleConfigurationSelectionException
extends StyledException {
    public IncompatibleConfigurationSelectionException(AttributeContainerInternal fromConfigurationAttributes, AttributeMatcher attributeMatcher, ComponentGraphResolveMetadata targetComponent, String targetConfiguration, boolean variantAware, AttributeDescriber describer) {
        super(IncompatibleConfigurationSelectionException.generateMessage(fromConfigurationAttributes, attributeMatcher, targetComponent, targetConfiguration, variantAware, describer));
    }

    private static String generateMessage(AttributeContainerInternal fromConfigurationAttributes, AttributeMatcher attributeMatcher, ComponentGraphResolveMetadata targetComponent, String targetConfiguration, boolean variantAware, AttributeDescriber describer) {
        TreeFormatter formatter = new TreeFormatter();
        formatter.node((variantAware ? "Variant '" : "Configuration '") + targetConfiguration + "' in " + IncompatibleConfigurationSelectionException.style((StyledTextOutput.Style)StyledTextOutput.Style.Info, (String)targetComponent.getId().getDisplayName()) + " does not match the consumer attributes");
        AmbiguousConfigurationSelectionException.formatConfiguration(formatter, targetComponent, fromConfigurationAttributes, attributeMatcher, targetComponent.getConfiguration(targetConfiguration), variantAware, false, describer);
        return formatter.toString();
    }
}

