/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.List;
import org.gradle.api.internal.tasks.testing.DefaultTestFailureDetails;
import org.gradle.api.tasks.testing.TestFailure;
import org.gradle.api.tasks.testing.TestFailureDetails;
import org.gradle.internal.serialize.PlaceholderExceptionSupport;

public class DefaultTestFailure
extends TestFailure {
    private final Throwable rawFailure;
    private final TestFailureDetails details;
    private final List<TestFailure> causes;

    public DefaultTestFailure(Throwable rawFailure, TestFailureDetails details, List<TestFailure> causes) {
        this.rawFailure = rawFailure;
        this.details = details;
        this.causes = causes;
    }

    @Override
    public Throwable getRawFailure() {
        return this.rawFailure;
    }

    @Override
    public TestFailureDetails getDetails() {
        return this.details;
    }

    @Override
    public List<TestFailure> getCauses() {
        return this.causes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultTestFailure that = (DefaultTestFailure)o;
        if (this.rawFailure != null ? !this.rawFailure.equals(that.rawFailure) : that.rawFailure != null) {
            return false;
        }
        return this.details != null ? this.details.equals(that.details) : that.details == null;
    }

    public int hashCode() {
        int result = this.rawFailure != null ? this.rawFailure.hashCode() : 0;
        result = 31 * result + (this.details != null ? this.details.hashCode() : 0);
        return result;
    }

    public static TestFailure fromTestAssertionFailure(Throwable failure, String expected, String actual, List<TestFailure> causes) {
        DefaultTestFailureDetails details = new DefaultTestFailureDetails(DefaultTestFailure.messageOf(failure), DefaultTestFailure.classNameOf(failure), DefaultTestFailure.stacktraceOf(failure), true, expected, actual);
        return new DefaultTestFailure(failure, details, causes == null ? Collections.emptyList() : causes);
    }

    public static TestFailure fromTestFrameworkFailure(Throwable failure, List<TestFailure> causes) {
        DefaultTestFailureDetails details = new DefaultTestFailureDetails(DefaultTestFailure.messageOf(failure), DefaultTestFailure.classNameOf(failure), DefaultTestFailure.stacktraceOf(failure), false, null, null);
        return new DefaultTestFailure(failure, details, causes == null ? Collections.emptyList() : causes);
    }

    private static String messageOf(Throwable throwable) {
        try {
            return throwable.getMessage();
        }
        catch (Throwable t) {
            return String.format("Could not determine failure message for exception of type %s: %s", DefaultTestFailure.classNameOf(throwable), t);
        }
    }

    private static String classNameOf(Throwable failure) {
        return failure instanceof PlaceholderExceptionSupport ? ((PlaceholderExceptionSupport)failure).getExceptionClassName() : failure.getClass().getName();
    }

    private static String stacktraceOf(Throwable throwable) {
        try {
            StringWriter out = new StringWriter();
            PrintWriter wrt = new PrintWriter(out);
            throwable.printStackTrace(wrt);
            return out.toString();
        }
        catch (Exception t) {
            return DefaultTestFailure.stacktraceOf(t);
        }
    }
}

