!===============================================================================
! Copyright 2022 Intel Corporation.
!
! This software and the related documents are Intel copyrighted  materials,  and
! your use of  them is  governed by the  express license  under which  they were
! provided to you (License).  Unless the License provides otherwise, you may not
! use, modify, copy, publish, distribute,  disclose or transmit this software or
! the related documents without Intel's prior written permission.
!
! This software and the related documents  are provided as  is,  with no express
! or implied  warranties,  other  than those  that are  expressly stated  in the
! License.
!===============================================================================

#include "mkl_omp_offload.f90"

program dgels_batch_strided_example

#ifdef MKL_ILP64
    use onemkl_lapack_omp_offload_ilp64
#else
    use onemkl_lapack_omp_offload_lp64
#endif

#define d(x) (x##d0)
#define z(x) (0.0, x##d0)

    integer, parameter :: m = 5, n = 5, nrhs = 1, lda = m, stride_a = n*lda, ldb = m, stride_b = nrhs*ldb, batch_size = 2
    integer i, j, num_errors

    complex*16 :: A(stride_a*batch_size) = (/ &
        z( 1.0 ), z(  0.0 ), z(  0.0 ), z(  0.0 ), z(  0.0 ), &
        z( 1.0 ), z(  0.2 ), z( -0.4 ), z( -0.4 ), z( -0.8 ), &
        z( 1.0 ), z(  0.6 ), z( -0.2 ), z(  0.4 ), z( -1.2 ), &
        z( 1.0 ), z(  1.0 ), z( -1.0 ), z(  0.6 ), z( -0.8 ), &
        z( 1.0 ), z(  1.8 ), z( -0.6 ), z(  0.2 ), z( -0.6 )  &
                                                            , &
        z( 0.2 ), z( -0.4 ), z( -0.4 ), z( -0.8 ), z(  0.0 ), &
        z( 0.4 ), z(  0.2 ), z(  0.8 ), z( -0.4 ), z(  0.0 ), &
        z( 0.4 ), z( -0.8 ), z(  0.2 ), z(  0.4 ), z(  0.0 ), &
        z( 0.8 ), z(  0.4 ), z( -0.4 ), z(  0.2 ), z(  0.0 ), &
        z( 0.0 ), z(  0.0 ), z(  0.0 ), z(  0.0 ), z(  1.0 )  &
    /)

    complex*16 :: B(stride_b*batch_size) = (/ &
        z( 5.0 ), z(  3.6 ), z( -2.2 ), z(  0.8 ), z( -3.4 )  &
                                                            , &
        z( 1.8 ), z( -0.6 ), z(  0.2 ), z( -0.6 ), z(  1.0 )  &
    /)

    double precision :: X(n*batch_size) = (/ &
        d( 1.0 ), d(  1.0 ), d(  1.0 ), d(  1.0 ), d(  1.0 )  &
                                                            , &
        d( 1.0 ), d(  1.0 ), d(  1.0 ), d(  1.0 ), d(  1.0 )  &
    /)

    integer :: info(batch_size) = -1

    !$omp target data map(A, B, info)
    !$omp dispatch
    call zgels_batch_strided('N', m, n, nrhs, A, lda, stride_a, B, ldb, stride_b, batch_size, info)
    !$omp end target data

    if (count(info/=0)) then
        print '("ERROR: Calculations failed with non-zeroes in info array:")'
        print '(*(I4))', info
        stop 1
    end if

    num_errors = 0
    print '("Results:")'
    do i = 1, stride_b*batch_size, stride_b
        print '(*(G11.4))', B(i:i+n-1)
        do j = 1, n
            if ((isnan(real(B(j)*B(j)))).or.(abs(B(j)-X(j))).gt.(1e-8)) then
                num_errors = num_errors+1
            end if
        end do
    end do

    if (num_errors.gt.0) then
        print '("ERROR: results mismatch!")'
        print '("Expected:")'
        do i = 1, batch_size
            print '(*(G11.4))', real(X((i-1)*n+1:i*n))
        end do
        stop 1
    else
        print '("Calculations succesfully finished")'
    end if

end program
