/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.mapcss;

import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.IWay;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.data.osm.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.Multipolygon;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.MultipolygonCache;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.mapcss.Condition;
import org.openstreetmap.josm.gui.mappaint.mapcss.Expression;
import org.openstreetmap.josm.gui.mappaint.mapcss.Functions;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Utils;

public final class ConditionFactory {
    private ConditionFactory() {
    }

    public static Condition createKeyValueCondition(String k, String v, Op op, Condition.Context context, boolean considerValAsKey) {
        switch (context) {
            case PRIMITIVE: {
                if (KeyValueRegexpCondition.SUPPORTED_OPS.contains((Object)op) && !considerValAsKey) {
                    try {
                        return new KeyValueRegexpCondition(k, v, op, false);
                    }
                    catch (PatternSyntaxException e) {
                        throw new MapCSSException(e);
                    }
                }
                if (!considerValAsKey && op == Op.EQ) {
                    return new SimpleKeyValueCondition(k, v);
                }
                return new KeyValueCondition(k, v, op, considerValAsKey);
            }
            case LINK: {
                if (considerValAsKey) {
                    throw new MapCSSException("''considerValAsKey'' not supported in LINK context");
                }
                if ("role".equalsIgnoreCase(k)) {
                    return new RoleCondition(v, op);
                }
                if ("index".equalsIgnoreCase(k)) {
                    return new IndexCondition(v, op);
                }
                throw new MapCSSException(MessageFormat.format("Expected key ''role'' or ''index'' in link context. Got ''{0}''.", k));
            }
        }
        throw new AssertionError();
    }

    public static Condition createRegexpKeyRegexpValueCondition(String k, String v, Op op) {
        return new RegexpKeyValueRegexpCondition(k, v, op);
    }

    public static Condition createKeyCondition(String k, boolean not, KeyMatchType matchType, Condition.Context context) {
        switch (context) {
            case PRIMITIVE: {
                if (KeyMatchType.REGEX == matchType && k.matches("[A-Za-z0-9:_-]+")) {
                    return new KeyCondition(k, not, KeyMatchType.ANY_CONTAINS);
                }
                if (KeyMatchType.REGEX == matchType && k.matches("\\^[A-Za-z0-9:_-]+")) {
                    return new KeyCondition(k.substring(1), not, KeyMatchType.ANY_STARTS_WITH);
                }
                if (KeyMatchType.REGEX == matchType && k.matches("[A-Za-z0-9:_-]+\\$")) {
                    return new KeyCondition(k.substring(0, k.length() - 1), not, KeyMatchType.ANY_ENDS_WITH);
                }
                if (matchType == KeyMatchType.REGEX) {
                    return new KeyRegexpCondition(Pattern.compile(k), not);
                }
                return new KeyCondition(k, not, matchType);
            }
            case LINK: {
                if (matchType != null) {
                    throw new MapCSSException("Question mark operator ''?'' and regexp match not supported in LINK context");
                }
                if (not) {
                    return new RoleCondition(k, Op.NEQ);
                }
                return new RoleCondition(k, Op.EQ);
            }
        }
        throw new AssertionError();
    }

    public static PseudoClassCondition createPseudoClassCondition(String id, boolean not, Condition.Context context) {
        return PseudoClassCondition.createPseudoClassCondition(id, not, context);
    }

    public static ClassCondition createClassCondition(String id, boolean not, Condition.Context context) {
        return new ClassCondition(id, not);
    }

    public static ExpressionCondition createExpressionCondition(Expression e, Condition.Context context) {
        return new ExpressionCondition(e);
    }

    public static class ExpressionCondition
    implements Condition {
        final Expression e;

        public ExpressionCondition(Expression e) {
            this.e = e;
        }

        public final Expression getExpression() {
            return this.e;
        }

        @Override
        public boolean applies(Environment env) {
            Boolean b = Cascade.convertTo(this.e.evaluate(env), Boolean.class);
            return b != null && b != false;
        }

        public String toString() {
            return '[' + this.e.toString() + ']';
        }
    }

    public static class OpenEndPseudoClassCondition
    extends PseudoClassCondition {
        final boolean not;

        public OpenEndPseudoClassCondition(boolean not) {
            super("open_end", null);
            this.not = not;
        }

        @Override
        public boolean applies(Environment e) {
            return !this.not;
        }
    }

    public static class PseudoClassCondition
    implements Condition {
        static final Map<String, PseudoClassCondition> CONDITION_MAP = new HashMap<String, PseudoClassCondition>();
        private final String name;
        private final Predicate<Environment> predicate;

        private static void register(String name, Predicate<Environment> predicate) {
            CONDITION_MAP.put(PseudoClassCondition.clean(name), new PseudoClassCondition(":" + name, predicate));
            CONDITION_MAP.put("!" + PseudoClassCondition.clean(name), new PseudoClassCondition("!:" + name, predicate.negate()));
        }

        protected PseudoClassCondition(String name, Predicate<Environment> predicate) {
            this.name = name;
            this.predicate = predicate;
        }

        public static PseudoClassCondition createPseudoClassCondition(String id, boolean not, Condition.Context context) {
            CheckParameterUtil.ensureThat(!"sameTags".equals(id) || Condition.Context.LINK == context, "sameTags only supported in LINK context");
            if ("open_end".equals(id)) {
                return new OpenEndPseudoClassCondition(not);
            }
            String cleanId = not ? PseudoClassCondition.clean("!" + id) : PseudoClassCondition.clean(id);
            PseudoClassCondition condition = CONDITION_MAP.get(cleanId);
            if (condition != null) {
                return condition;
            }
            throw new MapCSSException("Invalid pseudo class specified: " + id);
        }

        private static String clean(String id) {
            return id.toLowerCase(Locale.ROOT).replaceAll("[-_]", "");
        }

        @Override
        public boolean applies(Environment e) {
            return this.predicate.test(e);
        }

        public String toString() {
            return this.name;
        }

        static {
            PseudoClassCondition.register("anticlockwise", PseudoClasses::anticlockwise);
            PseudoClassCondition.register("areaStyle", PseudoClasses::areaStyle);
            PseudoClassCondition.register("clockwise", PseudoClasses::clockwise);
            PseudoClassCondition.register("closed", PseudoClasses::closed);
            PseudoClassCondition.register("closed2", PseudoClasses::closed2);
            PseudoClassCondition.register("completely_downloaded", PseudoClasses::completely_downloaded);
            PseudoClassCondition.register("connection", PseudoClasses::connection);
            PseudoClassCondition.register("highlighted", PseudoClasses::highlighted);
            PseudoClassCondition.register("inDownloadedArea", PseudoClasses::inDownloadedArea);
            PseudoClassCondition.register("modified", PseudoClasses::modified);
            PseudoClassCondition.register("new", PseudoClasses::_new);
            PseudoClassCondition.register("righthandtraffic", PseudoClasses::righthandtraffic);
            PseudoClassCondition.register("sameTags", PseudoClasses::sameTags);
            PseudoClassCondition.register("selected", PseudoClasses::selected);
            PseudoClassCondition.register("tagged", PseudoClasses::tagged);
            PseudoClassCondition.register("unclosed_multipolygon", PseudoClasses::unclosed_multipolygon);
            PseudoClassCondition.register("unconnected", PseudoClasses::unconnected);
        }
    }

    public static final class PseudoClasses {
        private static final Predicate<OsmPrimitive> IN_DOWNLOADED_AREA = new SearchCompiler.InDataSourceArea(false);

        private PseudoClasses() {
        }

        static boolean closed(Environment e) {
            if (e.osm instanceof IWay && ((IWay)e.osm).isClosed()) {
                return true;
            }
            return e.osm instanceof IRelation && e.osm.isMultipolygon();
        }

        static boolean modified(Environment e) {
            return e.osm.isModified() || e.osm.isNewOrUndeleted();
        }

        static boolean _new(Environment e) {
            return e.osm.isNew();
        }

        static boolean connection(Environment e) {
            return e.osm instanceof INode && e.osm.getDataSet() != null && ((INode)e.osm).isConnectionNode();
        }

        static boolean tagged(Environment e) {
            return e.osm.isTagged();
        }

        static boolean sameTags(Environment e) {
            return e.osm.hasSameInterestingTags(Utils.firstNonNull(e.child, e.parent));
        }

        static boolean areaStyle(Environment e) {
            return ElemStyles.hasAreaElemStyle(e.osm, false);
        }

        static boolean unconnected(Environment e) {
            return e.osm instanceof Node && ((Node)e.osm).getParentWays().isEmpty();
        }

        static boolean righthandtraffic(Environment e) {
            return Functions.is_right_hand_traffic(e);
        }

        static boolean clockwise(Environment e) {
            return Functions.is_clockwise(e);
        }

        static boolean anticlockwise(Environment e) {
            return Functions.is_anticlockwise(e);
        }

        static boolean unclosed_multipolygon(Environment e) {
            return e.osm instanceof Relation && e.osm.isMultipolygon() && !e.osm.isIncomplete() && !((Relation)e.osm).hasIncompleteMembers() && !MultipolygonCache.getInstance().get((Relation)e.osm).getOpenEnds().isEmpty();
        }

        static boolean inDownloadedArea(Environment e) {
            return e.osm instanceof OsmPrimitive && IN_DOWNLOADED_AREA.test((OsmPrimitive)e.osm);
        }

        static boolean completely_downloaded(Environment e) {
            if (e.osm instanceof IRelation) {
                return !((IRelation)e.osm).hasIncompleteMembers();
            }
            if (e.osm instanceof IWay) {
                return !((IWay)e.osm).hasIncompleteNodes();
            }
            if (e.osm instanceof INode) {
                return ((INode)e.osm).isLatLonKnown();
            }
            return true;
        }

        static boolean closed2(Environment e) {
            if (e.osm instanceof IWay && ((IWay)e.osm).isClosed()) {
                return true;
            }
            if (e.osm instanceof Relation && e.osm.isMultipolygon()) {
                Multipolygon multipolygon = MultipolygonCache.getInstance().get((Relation)e.osm);
                return multipolygon != null && multipolygon.getOpenEnds().isEmpty();
            }
            return false;
        }

        static boolean selected(Environment e) {
            if (e.mc != null) {
                e.getCascade().setDefaultSelectedHandling(false);
            }
            return e.osm.isSelected();
        }

        static boolean highlighted(Environment e) {
            return e.osm.isHighlighted();
        }
    }

    public static class ClassCondition
    implements Condition {
        public final String id;
        final boolean not;

        public ClassCondition(String id, boolean not) {
            this.id = id;
            this.not = not;
        }

        @Override
        public boolean applies(Environment env) {
            Cascade cascade = env.getCascade();
            return cascade != null && this.not ^ cascade.containsKey(this.id);
        }

        public String toString() {
            return (this.not ? "!" : "") + '.' + this.id;
        }
    }

    public static class KeyRegexpCondition
    implements Condition.TagCondition {
        public final Pattern pattern;
        public final boolean negateResult;

        public KeyRegexpCondition(Pattern pattern, boolean negateResult) {
            this.negateResult = negateResult;
            this.pattern = pattern;
        }

        @Override
        public boolean applies(Tagged osm) {
            boolean matches = osm.hasKeys() && osm.keys().anyMatch(this.pattern.asPredicate());
            return matches ^ this.negateResult;
        }

        @Override
        public Tag asTag(Tagged p) {
            String key = p.keys().filter(this.pattern.asPredicate()).findAny().orElse(this.pattern.pattern());
            return new Tag(key, p.get(key));
        }

        public String toString() {
            return '[' + (this.negateResult ? "!" : "") + this.pattern + ']';
        }
    }

    public static class KeyCondition
    implements Condition.TagCondition {
        public final String label;
        public final boolean negateResult;
        public final KeyMatchType matchType;

        public KeyCondition(String label, boolean negateResult, KeyMatchType matchType) {
            CheckParameterUtil.ensureThat(matchType != KeyMatchType.REGEX, "Use KeyPatternCondition");
            this.label = label;
            this.negateResult = negateResult;
            this.matchType = matchType == null ? KeyMatchType.EQ : matchType;
        }

        @Override
        public boolean applies(Tagged osm) {
            switch (this.matchType) {
                case TRUE: {
                    return osm.isKeyTrue(this.label) ^ this.negateResult;
                }
                case FALSE: {
                    return osm.isKeyFalse(this.label) ^ this.negateResult;
                }
                case ANY_CONTAINS: 
                case ANY_STARTS_WITH: 
                case ANY_ENDS_WITH: {
                    return osm.keys().anyMatch(this.keyPredicate()) ^ this.negateResult;
                }
            }
            return osm.hasKey(this.label) ^ this.negateResult;
        }

        private Predicate<String> keyPredicate() {
            switch (this.matchType) {
                case ANY_CONTAINS: {
                    return key -> key.contains(this.label);
                }
                case ANY_STARTS_WITH: {
                    return key -> key.startsWith(this.label);
                }
                case ANY_ENDS_WITH: {
                    return key -> key.endsWith(this.label);
                }
            }
            return null;
        }

        @Override
        public Tag asTag(Tagged p) {
            String key = this.label;
            Predicate<String> keyPredicate = this.keyPredicate();
            if (keyPredicate != null) {
                key = p.keys().filter(keyPredicate).findAny().orElse(key);
            }
            return new Tag(key, p.get(key));
        }

        public String toString() {
            return '[' + (this.negateResult ? "!" : "") + this.label + ']';
        }
    }

    public static enum KeyMatchType {
        EQ,
        TRUE,
        FALSE,
        REGEX,
        ANY_CONTAINS,
        ANY_STARTS_WITH,
        ANY_ENDS_WITH;

    }

    public static class IndexCondition
    implements Condition {
        final String index;
        final Op op;
        final boolean isFirstOrLast;

        public IndexCondition(String index, Op op) {
            this.index = index;
            this.op = op;
            this.isFirstOrLast = op == Op.EQ && ("1".equals(index) || "-1".equals(index));
        }

        @Override
        public boolean applies(Environment env) {
            if (env.index == null) {
                return false;
            }
            if (this.index.startsWith("-")) {
                return env.count != null && this.op.eval(Integer.toString(env.index - env.count), this.index);
            }
            return this.op.eval(Integer.toString(env.index + 1), this.index);
        }
    }

    public static class RoleCondition
    implements Condition {
        final String role;
        final Op op;

        public RoleCondition(String role, Op op) {
            this.role = role;
            this.op = op;
        }

        @Override
        public boolean applies(Environment env) {
            String testRole = env.getRole();
            if (testRole == null) {
                return false;
            }
            return this.op.eval(testRole, this.role);
        }
    }

    public static class RegexpKeyValueRegexpCondition
    extends KeyValueRegexpCondition {
        final Pattern keyPattern;

        public RegexpKeyValueRegexpCondition(String k, String v, Op op) {
            super(k, v, op, false);
            this.keyPattern = Pattern.compile(k);
        }

        @Override
        public boolean requiresExactKeyMatch() {
            return false;
        }

        @Override
        protected boolean matches(Tagged osm) {
            return osm.getKeys().entrySet().stream().anyMatch(kv -> this.keyPattern.matcher((CharSequence)kv.getKey()).find() && this.pattern.matcher((CharSequence)kv.getValue()).find());
        }
    }

    public static class KeyValueRegexpCondition
    extends KeyValueCondition {
        protected static final Set<Op> SUPPORTED_OPS = EnumSet.of(Op.REGEX, Op.NREGEX);
        final Pattern pattern;

        public KeyValueRegexpCondition(String k, String v, Op op, boolean considerValAsKey) {
            super(k, v, op, considerValAsKey);
            CheckParameterUtil.ensureThat(!considerValAsKey, "considerValAsKey is not supported");
            CheckParameterUtil.ensureThat(SUPPORTED_OPS.contains((Object)op), "Op must be REGEX or NREGEX");
            this.pattern = Pattern.compile(v);
        }

        protected boolean matches(Tagged osm) {
            String value = osm.get(this.k);
            return value != null && this.pattern.matcher(value).find();
        }

        @Override
        public boolean applies(Tagged osm) {
            if (Op.REGEX == this.op) {
                return this.matches(osm);
            }
            if (Op.NREGEX == this.op) {
                return !this.matches(osm);
            }
            throw new IllegalStateException();
        }
    }

    public static class KeyValueCondition
    implements Condition.TagCondition {
        public final String k;
        public final String v;
        public final Op op;
        public final boolean considerValAsKey;

        public KeyValueCondition(String k, String v, Op op, boolean considerValAsKey) {
            this.k = k.intern();
            this.v = v.intern();
            this.op = op;
            this.considerValAsKey = considerValAsKey;
        }

        public boolean requiresExactKeyMatch() {
            return !Op.NEGATED_OPS.contains((Object)this.op);
        }

        @Override
        public boolean applies(Tagged osm) {
            return this.op.eval(osm.get(this.k), this.considerValAsKey ? osm.get(this.v) : this.v);
        }

        @Override
        public Tag asTag(Tagged primitive) {
            return new Tag(this.k, this.v);
        }

        public String toString() {
            return '[' + this.k + '\'' + (Object)((Object)this.op) + '\'' + this.v + ']';
        }
    }

    public static class SimpleKeyValueCondition
    implements Condition.TagCondition {
        public final String k;
        public final String v;

        public SimpleKeyValueCondition(String k, String v) {
            this.k = k.intern();
            this.v = v.intern();
        }

        @Override
        public boolean applies(Tagged osm) {
            return this.v.equals(osm.get(this.k));
        }

        @Override
        public Tag asTag(Tagged primitive) {
            return new Tag(this.k, this.v);
        }

        public String toString() {
            return '[' + this.k + '=' + this.v + ']';
        }
    }

    public static enum Op {
        EQ(Objects::equals),
        NEQ(EQ),
        GREATER_OR_EQUAL(comparisonResult -> comparisonResult >= 0),
        GREATER(comparisonResult -> comparisonResult > 0),
        LESS_OR_EQUAL(comparisonResult -> comparisonResult <= 0),
        LESS(comparisonResult -> comparisonResult < 0),
        REGEX((test, prototype) -> Pattern.compile(prototype).matcher((CharSequence)test).find()),
        NREGEX(REGEX),
        ONE_OF((test, prototype) -> OsmUtils.splitMultipleValues(test).anyMatch(prototype::equals)),
        BEGINS_WITH(String::startsWith),
        ENDS_WITH(String::endsWith),
        CONTAINS(String::contains);

        static final Set<Op> NEGATED_OPS;
        private final BiPredicate<String, String> function;
        private final boolean negated;

        private Op(BiPredicate<String, String> func) {
            this.function = func;
            this.negated = false;
        }

        private Op(IntFunction<Boolean> comparatorResult) {
            this.function = (test, prototype) -> {
                float testFloat;
                try {
                    testFloat = Float.parseFloat(test);
                }
                catch (NumberFormatException e) {
                    return Boolean.FALSE;
                }
                float prototypeFloat = Float.parseFloat(prototype);
                int res = Float.compare(testFloat, prototypeFloat);
                return (Boolean)comparatorResult.apply(res);
            };
            this.negated = false;
        }

        private Op(Op negate) {
            this.function = (a, b) -> !negate.function.test((String)a, (String)b);
            this.negated = true;
        }

        public boolean eval(String testString, String prototypeString) {
            if (testString == null) {
                return this.negated;
            }
            return this.function.test(testString, prototypeString);
        }

        static {
            NEGATED_OPS = EnumSet.of(NEQ, NREGEX);
        }
    }
}

