/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ad.model.Mergeable;
import org.opensearch.core.action.ActionListener;

public class MultiResponsesDelegateActionListener<T extends Mergeable>
implements ActionListener<T> {
    private static final Logger LOG = LogManager.getLogger(MultiResponsesDelegateActionListener.class);
    static final String NO_RESPONSE = "No response collected";
    private final ActionListener<T> delegate;
    private final AtomicInteger collectedResponseCount;
    private final AtomicInteger maxResponseCount;
    private final List<T> savedResponses;
    private List<String> exceptions;
    private String finalErrorMsg;
    private final boolean returnOnPartialResults;

    public MultiResponsesDelegateActionListener(ActionListener<T> delegate, int maxResponseCount, String finalErrorMsg, boolean returnOnPartialResults) {
        this.delegate = delegate;
        this.collectedResponseCount = new AtomicInteger(0);
        this.maxResponseCount = new AtomicInteger(maxResponseCount);
        this.savedResponses = Collections.synchronizedList(new ArrayList());
        this.exceptions = Collections.synchronizedList(new ArrayList());
        this.finalErrorMsg = finalErrorMsg;
        this.returnOnPartialResults = returnOnPartialResults;
    }

    public void onResponse(T response) {
        try {
            if (response != null) {
                this.savedResponses.add(response);
            }
        }
        finally {
            if (this.collectedResponseCount.incrementAndGet() >= this.maxResponseCount.get()) {
                this.finish();
            }
        }
    }

    public void onFailure(Exception e) {
        LOG.error("Failure in response", (Throwable)e);
        try {
            this.exceptions.add(e.getMessage());
        }
        finally {
            if (this.collectedResponseCount.incrementAndGet() >= this.maxResponseCount.get()) {
                this.finish();
            }
        }
    }

    private void finish() {
        if (this.returnOnPartialResults || this.exceptions.size() == 0) {
            if (this.exceptions.size() > 0) {
                LOG.error(String.format(Locale.ROOT, "Although returning result, there exists exceptions: %s", this.exceptions));
            }
            this.handleSavedResponses();
        } else {
            this.delegate.onFailure((Exception)new RuntimeException(String.format(Locale.ROOT, this.finalErrorMsg + " Exceptions: %s", this.exceptions)));
        }
    }

    private void handleSavedResponses() {
        if (this.savedResponses.size() == 0) {
            this.delegate.onFailure((Exception)new RuntimeException(NO_RESPONSE));
        } else {
            Mergeable response0 = (Mergeable)this.savedResponses.get(0);
            for (int i = 1; i < this.savedResponses.size(); ++i) {
                response0.merge((Mergeable)this.savedResponses.get(i));
            }
            this.delegate.onResponse((Object)response0);
        }
    }
}

