/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.snapshotmanagement.api.transport.get;

import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.client.Client;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.snapshotmanagement.SMUtilsKt;
import org.opensearch.indexmanagement.snapshotmanagement.api.transport.BaseTransportAction;
import org.opensearch.indexmanagement.snapshotmanagement.api.transport.get.GetSMPolicyRequest;
import org.opensearch.indexmanagement.snapshotmanagement.api.transport.get.GetSMPolicyResponse;
import org.opensearch.indexmanagement.snapshotmanagement.api.transport.get.TransportGetSMPolicyAction;
import org.opensearch.indexmanagement.snapshotmanagement.settings.SnapshotManagementSettings;
import org.opensearch.indexmanagement.util.SecurityUtils;
import org.opensearch.transport.TransportService;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B/\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ+\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00022\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001fR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0018\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u0016\u0010\u0015\u001a\n \u0013*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006 "}, d2={"Lorg/opensearch/indexmanagement/snapshotmanagement/api/transport/get/TransportGetSMPolicyAction;", "Lorg/opensearch/indexmanagement/snapshotmanagement/api/transport/BaseTransportAction;", "Lorg/opensearch/indexmanagement/snapshotmanagement/api/transport/get/GetSMPolicyRequest;", "Lorg/opensearch/indexmanagement/snapshotmanagement/api/transport/get/GetSMPolicyResponse;", "client", "Lorg/opensearch/client/Client;", "transportService", "Lorg/opensearch/transport/TransportService;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "settings", "Lorg/opensearch/common/settings/Settings;", "(Lorg/opensearch/client/Client;Lorg/opensearch/transport/TransportService;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/common/settings/Settings;)V", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "filterByEnabled", "", "kotlin.jvm.PlatformType", "Ljava/lang/Boolean;", "log", "Lorg/apache/logging/log4j/Logger;", "getSettings", "()Lorg/opensearch/common/settings/Settings;", "executeRequest", "request", "user", "Lorg/opensearch/commons/authuser/User;", "threadContext", "Lorg/opensearch/common/util/concurrent/ThreadContext$StoredContext;", "(Lorg/opensearch/indexmanagement/snapshotmanagement/api/transport/get/GetSMPolicyRequest;Lorg/opensearch/commons/authuser/User;Lorg/opensearch/common/util/concurrent/ThreadContext$StoredContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "opensearch-index-management"})
public final class TransportGetSMPolicyAction
extends BaseTransportAction<GetSMPolicyRequest, GetSMPolicyResponse> {
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final Settings settings;
    private final Logger log;
    private volatile Boolean filterByEnabled;

    @Inject
    public TransportGetSMPolicyAction(@NotNull Client client, @NotNull TransportService transportService, @NotNull ActionFilters actionFilters, @NotNull ClusterService clusterService, @NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super("cluster:admin/opensearch/snapshot_management/policy/get", transportService, client, actionFilters, GetSMPolicyRequest::new);
        this.clusterService = clusterService;
        this.settings = settings;
        this.log = LogManager.getLogger(((Object)((Object)this)).getClass());
        this.filterByEnabled = (Boolean)SnapshotManagementSettings.Companion.getFILTER_BY_BACKEND_ROLES().get(this.settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(SnapshotManagementSettings.Companion.getFILTER_BY_BACKEND_ROLES(), arg_0 -> TransportGetSMPolicyAction._init_$lambda$0(this, arg_0));
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object executeRequest(@NotNull GetSMPolicyRequest var1_1, @Nullable User var2_2, @NotNull ThreadContext.StoredContext var3_3, @NotNull Continuation<? super GetSMPolicyResponse> var4_4) {
        if (!(var4_4 instanceof executeRequest.1)) ** GOTO lbl-1000
        var11_5 = var4_4;
        if ((var11_5.label & -2147483648) != 0) {
            var11_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_4){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ TransportGetSMPolicyAction this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.executeRequest((GetSMPolicyRequest)null, (User)null, (ThreadContext.StoredContext)null, (Continuation<? super GetSMPolicyResponse>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var12_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                getRequest = new GetRequest(".opendistro-ism-config", request.getPolicyID());
                $continuation.L$0 = this;
                $continuation.L$1 = request;
                $continuation.L$2 = user;
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)this.getClient(), (Function2)new Function2<Client, ActionListener<GetResponse>, Unit>(getRequest){
                    final /* synthetic */ GetRequest $getRequest;
                    {
                        this.$getRequest = $getRequest;
                        super(2);
                    }

                    public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<GetResponse> it) {
                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        $this$suspendUntil.get(this.$getRequest, it);
                    }
                }, $continuation);
                ** if (v0 != var12_7) goto lbl22
lbl21:
                // 1 sources

                return var12_7;
lbl22:
                // 1 sources

                ** GOTO lbl31
            }
            case 1: {
                user = (User)$continuation.L$2;
                request = (GetSMPolicyRequest)$continuation.L$1;
                this = (TransportGetSMPolicyAction)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl31:
                    // 2 sources

                    var7_9 = (GetResponse)v0;
                }
                catch (IndexNotFoundException var8_10) {
                    throw new OpenSearchStatusException("Snapshot management config index not found", RestStatus.NOT_FOUND, new Object[0]);
                }
                getResponse = var7_9;
                if (!getResponse.isExists()) {
                    throw new OpenSearchStatusException("Snapshot management policy not found", RestStatus.NOT_FOUND, new Object[0]);
                }
                try {
                    var8_11 = SMUtilsKt.parseSMPolicy$default(getResponse, null, 2, null);
                }
                catch (IllegalArgumentException e) {
                    this.log.error("Error while parsing snapshot management policy " + request.getPolicyID(), (Throwable)e);
                    throw new OpenSearchStatusException("Snapshot management policy not found", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
                }
                smPolicy = var8_11;
                v1 = smPolicy.getUser();
                v2 = this.filterByEnabled;
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"filterByEnabled");
                SecurityUtils.Companion.verifyUserHasPermissionForResource(user, v1, v2, "snapshot management policy", smPolicy.getPolicyName());
                this.log.debug("Get SM policy: " + smPolicy);
                v3 = getResponse.getId();
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getResponse.id");
                return new GetSMPolicyResponse(v3, getResponse.getVersion(), getResponse.getSeqNo(), getResponse.getPrimaryTerm(), smPolicy);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final void _init_$lambda$0(TransportGetSMPolicyAction this$0, Boolean it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.filterByEnabled = it;
    }
}

