from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.Geom import *
from OCC.Core.TopAbs import *
from OCC.Core.TCollection import *
from OCC.Core.TopOpeBRepTool import *
from OCC.Core.TopoDS import *
from OCC.Core.Geom2d import *
from OCC.Core.TopTools import *
from OCC.Core.gp import *
from OCC.Core.TColStd import *

# the following typedef cannot be wrapped as is
TopOpeBRepDS_DoubleMapIteratorOfDoubleMapOfIntegerShape = NewType("TopOpeBRepDS_DoubleMapIteratorOfDoubleMapOfIntegerShape", Any)
# the following typedef cannot be wrapped as is
TopOpeBRepDS_DoubleMapOfIntegerShape = NewType("TopOpeBRepDS_DoubleMapOfIntegerShape", Any)
# the following typedef cannot be wrapped as is
TopOpeBRepDS_IndexedDataMapOfShapeWithState = NewType("TopOpeBRepDS_IndexedDataMapOfShapeWithState", Any)
# the following typedef cannot be wrapped as is
TopOpeBRepDS_IndexedDataMapOfVertexPoint = NewType("TopOpeBRepDS_IndexedDataMapOfVertexPoint", Any)
# the following typedef cannot be wrapped as is
TopOpeBRepDS_MapOfShapeData = NewType("TopOpeBRepDS_MapOfShapeData", Any)
TopOpeBRepDS_PDataStructure = NewType("TopOpeBRepDS_PDataStructure", TopOpeBRepDS_DataStructure)

class TopOpeBRepDS_Array1OfDataMapOfIntegerListOfInterference:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> TopOpeBRepDS_DataMapOfIntegerListOfInterference: ...
    def __setitem__(self, index: int, value: TopOpeBRepDS_DataMapOfIntegerListOfInterference) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[TopOpeBRepDS_DataMapOfIntegerListOfInterference]: ...
    def next(self) -> TopOpeBRepDS_DataMapOfIntegerListOfInterference: ...
    __next__ = next
    def Init(self, theValue: TopOpeBRepDS_DataMapOfIntegerListOfInterference) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> TopOpeBRepDS_DataMapOfIntegerListOfInterference: ...
    def Last(self) -> TopOpeBRepDS_DataMapOfIntegerListOfInterference: ...
    def Value(self, theIndex: int) -> TopOpeBRepDS_DataMapOfIntegerListOfInterference: ...
    def SetValue(self, theIndex: int, theValue: TopOpeBRepDS_DataMapOfIntegerListOfInterference) -> None: ...

class TopOpeBRepDS_ListOfInterference:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Append(self, theItem: False) -> False: ...
    def Prepend(self, theItem: False) -> False: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class TopOpeBRepDS_CheckStatus(IntEnum):
    TopOpeBRepDS_OK: int = ...
    TopOpeBRepDS_NOK: int = ...

TopOpeBRepDS_OK = TopOpeBRepDS_CheckStatus.TopOpeBRepDS_OK
TopOpeBRepDS_NOK = TopOpeBRepDS_CheckStatus.TopOpeBRepDS_NOK

class TopOpeBRepDS_Config(IntEnum):
    TopOpeBRepDS_UNSHGEOMETRY: int = ...
    TopOpeBRepDS_SAMEORIENTED: int = ...
    TopOpeBRepDS_DIFFORIENTED: int = ...

TopOpeBRepDS_UNSHGEOMETRY = TopOpeBRepDS_Config.TopOpeBRepDS_UNSHGEOMETRY
TopOpeBRepDS_SAMEORIENTED = TopOpeBRepDS_Config.TopOpeBRepDS_SAMEORIENTED
TopOpeBRepDS_DIFFORIENTED = TopOpeBRepDS_Config.TopOpeBRepDS_DIFFORIENTED

class TopOpeBRepDS_Kind(IntEnum):
    TopOpeBRepDS_POINT: int = ...
    TopOpeBRepDS_CURVE: int = ...
    TopOpeBRepDS_SURFACE: int = ...
    TopOpeBRepDS_VERTEX: int = ...
    TopOpeBRepDS_EDGE: int = ...
    TopOpeBRepDS_WIRE: int = ...
    TopOpeBRepDS_FACE: int = ...
    TopOpeBRepDS_SHELL: int = ...
    TopOpeBRepDS_SOLID: int = ...
    TopOpeBRepDS_COMPSOLID: int = ...
    TopOpeBRepDS_COMPOUND: int = ...
    TopOpeBRepDS_UNKNOWN: int = ...

TopOpeBRepDS_POINT = TopOpeBRepDS_Kind.TopOpeBRepDS_POINT
TopOpeBRepDS_CURVE = TopOpeBRepDS_Kind.TopOpeBRepDS_CURVE
TopOpeBRepDS_SURFACE = TopOpeBRepDS_Kind.TopOpeBRepDS_SURFACE
TopOpeBRepDS_VERTEX = TopOpeBRepDS_Kind.TopOpeBRepDS_VERTEX
TopOpeBRepDS_EDGE = TopOpeBRepDS_Kind.TopOpeBRepDS_EDGE
TopOpeBRepDS_WIRE = TopOpeBRepDS_Kind.TopOpeBRepDS_WIRE
TopOpeBRepDS_FACE = TopOpeBRepDS_Kind.TopOpeBRepDS_FACE
TopOpeBRepDS_SHELL = TopOpeBRepDS_Kind.TopOpeBRepDS_SHELL
TopOpeBRepDS_SOLID = TopOpeBRepDS_Kind.TopOpeBRepDS_SOLID
TopOpeBRepDS_COMPSOLID = TopOpeBRepDS_Kind.TopOpeBRepDS_COMPSOLID
TopOpeBRepDS_COMPOUND = TopOpeBRepDS_Kind.TopOpeBRepDS_COMPOUND
TopOpeBRepDS_UNKNOWN = TopOpeBRepDS_Kind.TopOpeBRepDS_UNKNOWN

class topopebrepds:
    @staticmethod
    def IsGeometry(K: TopOpeBRepDS_Kind) -> bool: ...
    @staticmethod
    def IsTopology(K: TopOpeBRepDS_Kind) -> bool: ...
    @staticmethod
    def KindToShape(K: TopOpeBRepDS_Kind) -> TopAbs_ShapeEnum: ...
    @overload
    @staticmethod
    def SPrint(S: TopAbs_State) -> str: ...
    @overload
    @staticmethod
    def SPrint(K: TopOpeBRepDS_Kind) -> str: ...
    @overload
    @staticmethod
    def SPrint(K: TopOpeBRepDS_Kind, I: int, B: Optional[str] = "", A: Optional[str] = "") -> str: ...
    @overload
    @staticmethod
    def SPrint(T: TopAbs_ShapeEnum) -> str: ...
    @overload
    @staticmethod
    def SPrint(T: TopAbs_ShapeEnum, I: int) -> str: ...
    @overload
    @staticmethod
    def SPrint(O: TopAbs_Orientation) -> str: ...
    @overload
    @staticmethod
    def SPrint(C: TopOpeBRepDS_Config) -> str: ...
    @staticmethod
    def ShapeToKind(S: TopAbs_ShapeEnum) -> TopOpeBRepDS_Kind: ...

class TopOpeBRepDS_Association(Standard_Transient):
    def __init__(self) -> None: ...
    def AreAssociated(self, I: TopOpeBRepDS_Interference, K: TopOpeBRepDS_Interference) -> bool: ...
    @overload
    def Associate(self, I: TopOpeBRepDS_Interference, K: TopOpeBRepDS_Interference) -> None: ...
    @overload
    def Associate(self, I: TopOpeBRepDS_Interference, LI: TopOpeBRepDS_ListOfInterference) -> None: ...
    def Associated(self, I: TopOpeBRepDS_Interference) -> TopOpeBRepDS_ListOfInterference: ...
    def HasAssociation(self, I: TopOpeBRepDS_Interference) -> bool: ...

class TopOpeBRepDS_BuildTool:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, OutCurveType: TopOpeBRepTool_OutCurveType) -> None: ...
    @overload
    def __init__(self, GT: TopOpeBRepTool_GeomTool) -> None: ...
    @overload
    def AddEdgeVertex(self, Ein: TopoDS_Shape, Eou: TopoDS_Shape, V: TopoDS_Shape) -> None: ...
    @overload
    def AddEdgeVertex(self, E: TopoDS_Shape, V: TopoDS_Shape) -> None: ...
    def AddFaceWire(self, F: TopoDS_Shape, W: TopoDS_Shape) -> None: ...
    def AddShellFace(self, Sh: TopoDS_Shape, F: TopoDS_Shape) -> None: ...
    def AddSolidShell(self, S: TopoDS_Shape, Sh: TopoDS_Shape) -> None: ...
    def AddWireEdge(self, W: TopoDS_Shape, E: TopoDS_Shape) -> None: ...
    def ApproxCurves(self, C: TopOpeBRepDS_Curve, E: TopoDS_Edge, HDS: TopOpeBRepDS_HDataStructure) -> int: ...
    def Approximation(self) -> bool: ...
    def ChangeGeomTool(self) -> TopOpeBRepTool_GeomTool: ...
    def Closed(self, S: TopoDS_Shape, B: bool) -> None: ...
    def ComputePCurves(self, C: TopOpeBRepDS_Curve, E: TopoDS_Edge, newC: TopOpeBRepDS_Curve, CompPC1: bool, CompPC2: bool, CompC3D: bool) -> None: ...
    def CopyEdge(self, Ein: TopoDS_Shape, Eou: TopoDS_Shape) -> None: ...
    def CopyFace(self, Fin: TopoDS_Shape, Fou: TopoDS_Shape) -> None: ...
    def Curve3D(self, E: TopoDS_Shape, C: Geom_Curve, Tol: float) -> None: ...
    def GetGeomTool(self) -> TopOpeBRepTool_GeomTool: ...
    def GetOrientedEdgeVertices(self, E: TopoDS_Edge, Vmin: TopoDS_Vertex, Vmax: TopoDS_Vertex) -> Tuple[float, float]: ...
    @overload
    def MakeEdge(self, E: TopoDS_Shape, C: TopOpeBRepDS_Curve) -> None: ...
    @overload
    def MakeEdge(self, E: TopoDS_Shape, C: TopOpeBRepDS_Curve, DS: TopOpeBRepDS_DataStructure) -> None: ...
    @overload
    def MakeEdge(self, E: TopoDS_Shape, C: Geom_Curve, Tol: float) -> None: ...
    @overload
    def MakeEdge(self, E: TopoDS_Shape) -> None: ...
    def MakeFace(self, F: TopoDS_Shape, S: TopOpeBRepDS_Surface) -> None: ...
    def MakeShell(self, Sh: TopoDS_Shape) -> None: ...
    def MakeSolid(self, S: TopoDS_Shape) -> None: ...
    def MakeVertex(self, V: TopoDS_Shape, P: TopOpeBRepDS_Point) -> None: ...
    def MakeWire(self, W: TopoDS_Shape) -> None: ...
    @overload
    def Orientation(self, S: TopoDS_Shape, O: TopAbs_Orientation) -> None: ...
    @overload
    def Orientation(self, S: TopoDS_Shape) -> TopAbs_Orientation: ...
    @overload
    def OverWrite(self) -> bool: ...
    @overload
    def OverWrite(self, O: bool) -> None: ...
    @overload
    def PCurve(self, F: TopoDS_Shape, E: TopoDS_Shape, C: Geom2d_Curve) -> None: ...
    @overload
    def PCurve(self, F: TopoDS_Shape, E: TopoDS_Shape, CDS: TopOpeBRepDS_Curve, C: Geom2d_Curve) -> None: ...
    @overload
    def Parameter(self, E: TopoDS_Shape, V: TopoDS_Shape, P: float) -> None: ...
    @overload
    def Parameter(self, C: TopOpeBRepDS_Curve, E: TopoDS_Shape, V: TopoDS_Shape) -> None: ...
    def PutPCurves(self, newC: TopOpeBRepDS_Curve, E: TopoDS_Edge, CompPC1: bool, CompPC2: bool) -> None: ...
    def Range(self, E: TopoDS_Shape, first: float, last: float) -> None: ...
    def RecomputeCurves(self, C: TopOpeBRepDS_Curve, oldE: TopoDS_Edge, E: TopoDS_Edge, HDS: TopOpeBRepDS_HDataStructure) -> int: ...
    @overload
    def Translate(self) -> bool: ...
    @overload
    def Translate(self, T: bool) -> None: ...
    def UpdateEdge(self, Ein: TopoDS_Shape, Eou: TopoDS_Shape) -> None: ...
    def UpdateEdgeCurveTol(self, F1: TopoDS_Face, F2: TopoDS_Face, E: TopoDS_Edge, C3Dnew: Geom_Curve, tol3d: float, tol2d1: float, tol2d2: float) -> Tuple[float, float, float]: ...
    @overload
    def UpdateSurface(self, F: TopoDS_Shape, SU: Geom_Surface) -> None: ...
    @overload
    def UpdateSurface(self, E: TopoDS_Shape, oldF: TopoDS_Shape, newF: TopoDS_Shape) -> None: ...

class TopOpeBRepDS_Check(Standard_Transient):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, HDS: TopOpeBRepDS_HDataStructure) -> None: ...
    def ChangeHDS(self) -> TopOpeBRepDS_HDataStructure: ...
    def CheckDS(self, i: int, K: TopOpeBRepDS_Kind) -> bool: ...
    def CheckShapes(self, LS: TopTools_ListOfShape) -> bool: ...
    def ChkIntg(self) -> bool: ...
    def ChkIntgInterf(self, LI: TopOpeBRepDS_ListOfInterference) -> bool: ...
    def ChkIntgSamDom(self) -> bool: ...
    def HDS(self) -> TopOpeBRepDS_HDataStructure: ...
    def OneVertexOnPnt(self) -> bool: ...

class TopOpeBRepDS_Curve:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, P: Geom_Curve, T: float, IsWalk: Optional[bool] = False) -> None: ...
    def ChangeCurve(self) -> Geom_Curve: ...
    def ChangeDSIndex(self, I: int) -> None: ...
    def ChangeIsWalk(self, B: bool) -> None: ...
    def ChangeKeep(self, B: bool) -> None: ...
    def ChangeMother(self, I: int) -> None: ...
    def ChangeShape1(self) -> TopoDS_Shape: ...
    def ChangeShape2(self) -> TopoDS_Shape: ...
    @overload
    def Curve(self) -> Geom_Curve: ...
    @overload
    def Curve(self, C3D: Geom_Curve, Tol: float) -> None: ...
    @overload
    def Curve1(self) -> Geom2d_Curve: ...
    @overload
    def Curve1(self, PC1: Geom2d_Curve) -> None: ...
    @overload
    def Curve2(self) -> Geom2d_Curve: ...
    @overload
    def Curve2(self, PC2: Geom2d_Curve) -> None: ...
    def DSIndex(self) -> int: ...
    def DefineCurve(self, P: Geom_Curve, T: float, IsWalk: bool) -> None: ...
    def GetSCI(self, I1: TopOpeBRepDS_Interference, I2: TopOpeBRepDS_Interference) -> None: ...
    def GetSCI1(self) -> TopOpeBRepDS_Interference: ...
    def GetSCI2(self) -> TopOpeBRepDS_Interference: ...
    def GetShapes(self, S1: TopoDS_Shape, S2: TopoDS_Shape) -> None: ...
    def IsWalk(self) -> bool: ...
    def Keep(self) -> bool: ...
    def Mother(self) -> int: ...
    def Range(self) -> Tuple[bool, float, float]: ...
    def SetRange(self, First: float, Last: float) -> None: ...
    def SetSCI(self, I1: TopOpeBRepDS_Interference, I2: TopOpeBRepDS_Interference) -> None: ...
    def SetShapes(self, S1: TopoDS_Shape, S2: TopoDS_Shape) -> None: ...
    def Shape1(self) -> TopoDS_Shape: ...
    def Shape2(self) -> TopoDS_Shape: ...
    @overload
    def Tolerance(self, tol: float) -> None: ...
    @overload
    def Tolerance(self) -> float: ...

class TopOpeBRepDS_CurveExplorer:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, DS: TopOpeBRepDS_DataStructure, FindOnlyKeep: Optional[bool] = True) -> None: ...
    @overload
    def Curve(self) -> TopOpeBRepDS_Curve: ...
    @overload
    def Curve(self, I: int) -> TopOpeBRepDS_Curve: ...
    def Index(self) -> int: ...
    def Init(self, DS: TopOpeBRepDS_DataStructure, FindOnlyKeep: Optional[bool] = True) -> None: ...
    def IsCurve(self, I: int) -> bool: ...
    def IsCurveKeep(self, I: int) -> bool: ...
    def More(self) -> bool: ...
    def NbCurve(self) -> int: ...
    def Next(self) -> None: ...

class TopOpeBRepDS_DataStructure:
    def __init__(self) -> None: ...
    def AddCurve(self, S: TopOpeBRepDS_Curve) -> int: ...
    def AddPoint(self, PDS: TopOpeBRepDS_Point) -> int: ...
    def AddPointSS(self, PDS: TopOpeBRepDS_Point, S1: TopoDS_Shape, S2: TopoDS_Shape) -> int: ...
    def AddSectionEdge(self, E: TopoDS_Edge) -> int: ...
    @overload
    def AddShape(self, S: TopoDS_Shape) -> int: ...
    @overload
    def AddShape(self, S: TopoDS_Shape, I: int) -> int: ...
    def AddShapeInterference(self, S: TopoDS_Shape, I: TopOpeBRepDS_Interference) -> None: ...
    def AddShapeSameDomain(self, S: TopoDS_Shape, SSD: TopoDS_Shape) -> None: ...
    def AddSurface(self, S: TopOpeBRepDS_Surface) -> int: ...
    @overload
    def AncestorRank(self, I: int) -> int: ...
    @overload
    def AncestorRank(self, S: TopoDS_Shape) -> int: ...
    @overload
    def AncestorRank(self, I: int, Ianc: int) -> None: ...
    @overload
    def AncestorRank(self, S: TopoDS_Shape, Ianc: int) -> None: ...
    def ChangeCurve(self, I: int) -> TopOpeBRepDS_Curve: ...
    def ChangeCurveInterferences(self, I: int) -> TopOpeBRepDS_ListOfInterference: ...
    @overload
    def ChangeKeepCurve(self, I: int, FindKeep: bool) -> None: ...
    @overload
    def ChangeKeepCurve(self, C: TopOpeBRepDS_Curve, FindKeep: bool) -> None: ...
    @overload
    def ChangeKeepPoint(self, I: int, FindKeep: bool) -> None: ...
    @overload
    def ChangeKeepPoint(self, P: TopOpeBRepDS_Point, FindKeep: bool) -> None: ...
    @overload
    def ChangeKeepShape(self, I: int, FindKeep: bool) -> None: ...
    @overload
    def ChangeKeepShape(self, S: TopoDS_Shape, FindKeep: bool) -> None: ...
    @overload
    def ChangeKeepSurface(self, I: int, FindKeep: bool) -> None: ...
    @overload
    def ChangeKeepSurface(self, S: TopOpeBRepDS_Surface, FindKeep: bool) -> None: ...
    def ChangeMapOfRejectedShapesObj(self) -> TopTools_IndexedMapOfShape: ...
    def ChangeMapOfRejectedShapesTool(self) -> TopTools_IndexedMapOfShape: ...
    def ChangeMapOfShapeWithState(self, aShape: TopoDS_Shape) -> Tuple[TopOpeBRepDS_IndexedDataMapOfShapeWithState, bool]: ...
    def ChangeMapOfShapeWithStateObj(self) -> TopOpeBRepDS_IndexedDataMapOfShapeWithState: ...
    def ChangeMapOfShapeWithStateTool(self) -> TopOpeBRepDS_IndexedDataMapOfShapeWithState: ...
    def ChangeNbCurves(self, N: int) -> None: ...
    def ChangePoint(self, I: int) -> TopOpeBRepDS_Point: ...
    def ChangePointInterferences(self, I: int) -> TopOpeBRepDS_ListOfInterference: ...
    @overload
    def ChangeShapeInterferences(self, S: TopoDS_Shape) -> TopOpeBRepDS_ListOfInterference: ...
    @overload
    def ChangeShapeInterferences(self, I: int) -> TopOpeBRepDS_ListOfInterference: ...
    @overload
    def ChangeShapeSameDomain(self, S: TopoDS_Shape) -> TopTools_ListOfShape: ...
    @overload
    def ChangeShapeSameDomain(self, I: int) -> TopTools_ListOfShape: ...
    def ChangeShapes(self) -> TopOpeBRepDS_MapOfShapeData: ...
    def ChangeSurface(self, I: int) -> TopOpeBRepDS_Surface: ...
    def ChangeSurfaceInterferences(self, I: int) -> TopOpeBRepDS_ListOfInterference: ...
    def Curve(self, I: int) -> TopOpeBRepDS_Curve: ...
    def CurveInterferences(self, I: int) -> TopOpeBRepDS_ListOfInterference: ...
    @overload
    def FillShapesSameDomain(self, S1: TopoDS_Shape, S2: TopoDS_Shape, refFirst: Optional[bool] = True) -> None: ...
    @overload
    def FillShapesSameDomain(self, S1: TopoDS_Shape, S2: TopoDS_Shape, c1: TopOpeBRepDS_Config, c2: TopOpeBRepDS_Config, refFirst: Optional[bool] = True) -> None: ...
    def GetShapeWithState(self, aShape: TopoDS_Shape) -> TopOpeBRepDS_ShapeWithState: ...
    def HasGeometry(self, S: TopoDS_Shape) -> bool: ...
    def HasNewSurface(self, F: TopoDS_Shape) -> bool: ...
    def HasShape(self, S: TopoDS_Shape, FindKeep: Optional[bool] = True) -> bool: ...
    def Init(self) -> None: ...
    def InitSectionEdges(self) -> None: ...
    def IsSectionEdge(self, E: TopoDS_Edge, FindKeep: Optional[bool] = True) -> bool: ...
    @overload
    def Isfafa(self, isfafa: bool) -> None: ...
    @overload
    def Isfafa(self) -> bool: ...
    @overload
    def KeepCurve(self, I: int) -> bool: ...
    @overload
    def KeepCurve(self, C: TopOpeBRepDS_Curve) -> bool: ...
    @overload
    def KeepPoint(self, I: int) -> bool: ...
    @overload
    def KeepPoint(self, P: TopOpeBRepDS_Point) -> bool: ...
    @overload
    def KeepShape(self, I: int, FindKeep: Optional[bool] = True) -> bool: ...
    @overload
    def KeepShape(self, S: TopoDS_Shape, FindKeep: Optional[bool] = True) -> bool: ...
    @overload
    def KeepSurface(self, I: int) -> bool: ...
    @overload
    def KeepSurface(self, S: TopOpeBRepDS_Surface) -> bool: ...
    def NbCurves(self) -> int: ...
    def NbPoints(self) -> int: ...
    def NbSectionEdges(self) -> int: ...
    def NbShapes(self) -> int: ...
    def NbSurfaces(self) -> int: ...
    def NewSurface(self, F: TopoDS_Shape) -> Geom_Surface: ...
    def Point(self, I: int) -> TopOpeBRepDS_Point: ...
    def PointInterferences(self, I: int) -> TopOpeBRepDS_ListOfInterference: ...
    def RemoveCurve(self, I: int) -> None: ...
    def RemovePoint(self, I: int) -> None: ...
    def RemoveShapeInterference(self, S: TopoDS_Shape, I: TopOpeBRepDS_Interference) -> None: ...
    def RemoveShapeSameDomain(self, S: TopoDS_Shape, SSD: TopoDS_Shape) -> None: ...
    def RemoveSurface(self, I: int) -> None: ...
    @overload
    def SameDomainInd(self, I: int) -> int: ...
    @overload
    def SameDomainInd(self, S: TopoDS_Shape) -> int: ...
    @overload
    def SameDomainInd(self, I: int, Ind: int) -> None: ...
    @overload
    def SameDomainInd(self, S: TopoDS_Shape, Ind: int) -> None: ...
    @overload
    def SameDomainOri(self, I: int) -> TopOpeBRepDS_Config: ...
    @overload
    def SameDomainOri(self, S: TopoDS_Shape) -> TopOpeBRepDS_Config: ...
    @overload
    def SameDomainOri(self, I: int, Ori: TopOpeBRepDS_Config) -> None: ...
    @overload
    def SameDomainOri(self, S: TopoDS_Shape, Ori: TopOpeBRepDS_Config) -> None: ...
    @overload
    def SameDomainRef(self, I: int) -> int: ...
    @overload
    def SameDomainRef(self, S: TopoDS_Shape) -> int: ...
    @overload
    def SameDomainRef(self, I: int, Ref: int) -> None: ...
    @overload
    def SameDomainRef(self, S: TopoDS_Shape, Ref: int) -> None: ...
    @overload
    def SectionEdge(self, I: int, FindKeep: Optional[bool] = True) -> TopoDS_Edge: ...
    @overload
    def SectionEdge(self, E: TopoDS_Edge, FindKeep: Optional[bool] = True) -> int: ...
    def SetNewSurface(self, F: TopoDS_Shape, S: Geom_Surface) -> None: ...
    @overload
    def Shape(self, I: int, FindKeep: Optional[bool] = True) -> TopoDS_Shape: ...
    @overload
    def Shape(self, S: TopoDS_Shape, FindKeep: Optional[bool] = True) -> int: ...
    @overload
    def ShapeInterferences(self, S: TopoDS_Shape, FindKeep: Optional[bool] = True) -> TopOpeBRepDS_ListOfInterference: ...
    @overload
    def ShapeInterferences(self, I: int, FindKeep: Optional[bool] = True) -> TopOpeBRepDS_ListOfInterference: ...
    @overload
    def ShapeSameDomain(self, S: TopoDS_Shape) -> TopTools_ListOfShape: ...
    @overload
    def ShapeSameDomain(self, I: int) -> TopTools_ListOfShape: ...
    def Surface(self, I: int) -> TopOpeBRepDS_Surface: ...
    def SurfaceInterferences(self, I: int) -> TopOpeBRepDS_ListOfInterference: ...
    def UnfillShapesSameDomain(self, S1: TopoDS_Shape, S2: TopoDS_Shape) -> None: ...

class TopOpeBRepDS_Dumper:
    def __init__(self, HDS: TopOpeBRepDS_HDataStructure) -> None: ...
    @overload
    def SDumpRefOri(self, K: TopOpeBRepDS_Kind, I: int) -> str: ...
    @overload
    def SDumpRefOri(self, S: TopoDS_Shape) -> str: ...
    @overload
    def SPrintShape(self, I: int) -> str: ...
    @overload
    def SPrintShape(self, S: TopoDS_Shape) -> str: ...
    @overload
    def SPrintShapeRefOri(self, S: TopoDS_Shape, B: Optional[str] = "") -> str: ...
    @overload
    def SPrintShapeRefOri(self, L: TopTools_ListOfShape, B: Optional[str] = "") -> str: ...

class TopOpeBRepDS_EIR:
    def __init__(self, HDS: TopOpeBRepDS_HDataStructure) -> None: ...
    @overload
    def ProcessEdgeInterferences(self) -> None: ...
    @overload
    def ProcessEdgeInterferences(self, I: int) -> None: ...

class TopOpeBRepDS_Edge3dInterferenceTool:
    def __init__(self) -> None: ...
    def Add(self, Eref: TopoDS_Shape, E: TopoDS_Shape, F: TopoDS_Shape, I: TopOpeBRepDS_Interference) -> None: ...
    def Init(self, Eref: TopoDS_Shape, E: TopoDS_Shape, F: TopoDS_Shape, I: TopOpeBRepDS_Interference) -> None: ...
    def InitPointVertex(self, IsVertex: int, VonOO: TopoDS_Shape) -> None: ...
    def Transition(self, I: TopOpeBRepDS_Interference) -> None: ...

class TopOpeBRepDS_EdgeInterferenceTool:
    def __init__(self) -> None: ...
    @overload
    def Add(self, E: TopoDS_Shape, V: TopoDS_Shape, I: TopOpeBRepDS_Interference) -> None: ...
    @overload
    def Add(self, E: TopoDS_Shape, P: TopOpeBRepDS_Point, I: TopOpeBRepDS_Interference) -> None: ...
    def Init(self, E: TopoDS_Shape, I: TopOpeBRepDS_Interference) -> None: ...
    def Transition(self, I: TopOpeBRepDS_Interference) -> None: ...

class TopOpeBRepDS_Explorer:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, HDS: TopOpeBRepDS_HDataStructure, T: Optional[TopAbs_ShapeEnum] = TopAbs_SHAPE, findkeep: Optional[bool] = True) -> None: ...
    def Current(self) -> TopoDS_Shape: ...
    def Edge(self) -> TopoDS_Edge: ...
    def Face(self) -> TopoDS_Face: ...
    def Index(self) -> int: ...
    def Init(self, HDS: TopOpeBRepDS_HDataStructure, T: Optional[TopAbs_ShapeEnum] = TopAbs_SHAPE, findkeep: Optional[bool] = True) -> None: ...
    def More(self) -> bool: ...
    def Next(self) -> None: ...
    def Type(self) -> TopAbs_ShapeEnum: ...
    def Vertex(self) -> TopoDS_Vertex: ...

class TopOpeBRepDS_FIR:
    def __init__(self, HDS: TopOpeBRepDS_HDataStructure) -> None: ...
    @overload
    def ProcessFaceInterferences(self, M: TopOpeBRepDS_DataMapOfShapeListOfShapeOn1State) -> None: ...
    @overload
    def ProcessFaceInterferences(self, I: int, M: TopOpeBRepDS_DataMapOfShapeListOfShapeOn1State) -> None: ...

class TopOpeBRepDS_FaceInterferenceTool:
    def __init__(self, P: TopOpeBRepDS_PDataStructure) -> None: ...
    @overload
    def Add(self, FI: TopoDS_Shape, F: TopoDS_Shape, E: TopoDS_Shape, Eisnew: bool, I: TopOpeBRepDS_Interference) -> None: ...
    @overload
    def Add(self, E: TopoDS_Shape, C: TopOpeBRepDS_Curve, I: TopOpeBRepDS_Interference) -> None: ...
    def GetEdgePntPar(self, P: gp_Pnt) -> float: ...
    def Init(self, FI: TopoDS_Shape, E: TopoDS_Shape, Eisnew: bool, I: TopOpeBRepDS_Interference) -> None: ...
    def IsEdgePntParDef(self) -> bool: ...
    def SetEdgePntPar(self, P: gp_Pnt, par: float) -> None: ...
    def Transition(self, I: TopOpeBRepDS_Interference) -> None: ...

class TopOpeBRepDS_Filter:
    def __init__(self, HDS: TopOpeBRepDS_HDataStructure, pClassif: Optional[TopOpeBRepTool_PShapeClassifier] = 0) -> None: ...
    @overload
    def ProcessCurveInterferences(self) -> None: ...
    @overload
    def ProcessCurveInterferences(self, I: int) -> None: ...
    @overload
    def ProcessEdgeInterferences(self) -> None: ...
    @overload
    def ProcessEdgeInterferences(self, I: int) -> None: ...
    @overload
    def ProcessFaceInterferences(self, MEsp: TopOpeBRepDS_DataMapOfShapeListOfShapeOn1State) -> None: ...
    @overload
    def ProcessFaceInterferences(self, I: int, MEsp: TopOpeBRepDS_DataMapOfShapeListOfShapeOn1State) -> None: ...
    def ProcessInterferences(self) -> None: ...

class TopOpeBRepDS_GapFiller:
    def __init__(self, HDS: TopOpeBRepDS_HDataStructure) -> None: ...
    def AddPointsOnConnexShape(self, F: TopoDS_Shape, LI: TopOpeBRepDS_ListOfInterference) -> None: ...
    def AddPointsOnShape(self, S: TopoDS_Shape, LI: TopOpeBRepDS_ListOfInterference) -> None: ...
    def BuildNewGeometries(self) -> None: ...
    def CheckConnexity(self, LI: TopOpeBRepDS_ListOfInterference) -> bool: ...
    def FilterByEdge(self, E: TopoDS_Edge, LI: TopOpeBRepDS_ListOfInterference) -> None: ...
    def FilterByFace(self, F: TopoDS_Face, LI: TopOpeBRepDS_ListOfInterference) -> None: ...
    def FilterByIncidentDistance(self, F: TopoDS_Face, I: TopOpeBRepDS_Interference, LI: TopOpeBRepDS_ListOfInterference) -> None: ...
    def FindAssociatedPoints(self, I: TopOpeBRepDS_Interference, LI: TopOpeBRepDS_ListOfInterference) -> None: ...
    def IsOnEdge(self, I: TopOpeBRepDS_Interference, E: TopoDS_Edge) -> bool: ...
    def IsOnFace(self, I: TopOpeBRepDS_Interference, F: TopoDS_Face) -> bool: ...
    def Perform(self) -> None: ...
    def ReBuildGeom(self, I1: TopOpeBRepDS_Interference, Done: TColStd_MapOfInteger) -> None: ...

class TopOpeBRepDS_GapTool(Standard_Transient):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, HDS: TopOpeBRepDS_HDataStructure) -> None: ...
    def ChangeSameInterferences(self, I: TopOpeBRepDS_Interference) -> TopOpeBRepDS_ListOfInterference: ...
    def Curve(self, I: TopOpeBRepDS_Interference, C: TopOpeBRepDS_Curve) -> bool: ...
    def EdgeSupport(self, I: TopOpeBRepDS_Interference, E: TopoDS_Shape) -> bool: ...
    def FacesSupport(self, I: TopOpeBRepDS_Interference, F1: TopoDS_Shape, F2: TopoDS_Shape) -> bool: ...
    def Init(self, HDS: TopOpeBRepDS_HDataStructure) -> None: ...
    def Interferences(self, IndexPoint: int) -> TopOpeBRepDS_ListOfInterference: ...
    def ParameterOnEdge(self, I: TopOpeBRepDS_Interference, E: TopoDS_Shape) -> Tuple[bool, float]: ...
    def SameInterferences(self, I: TopOpeBRepDS_Interference) -> TopOpeBRepDS_ListOfInterference: ...
    def SetParameterOnEdge(self, I: TopOpeBRepDS_Interference, E: TopoDS_Shape, U: float) -> None: ...
    def SetPoint(self, I: TopOpeBRepDS_Interference, IndexPoint: int) -> None: ...

class TopOpeBRepDS_GeometryData:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, Other: TopOpeBRepDS_GeometryData) -> None: ...
    def AddInterference(self, I: TopOpeBRepDS_Interference) -> None: ...
    def Assign(self, Other: TopOpeBRepDS_GeometryData) -> None: ...
    def ChangeInterferences(self) -> TopOpeBRepDS_ListOfInterference: ...
    def Interferences(self) -> TopOpeBRepDS_ListOfInterference: ...

class TopOpeBRepDS_Interference(Standard_Transient):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, Transition: TopOpeBRepDS_Transition, SupportType: TopOpeBRepDS_Kind, Support: int, GeometryType: TopOpeBRepDS_Kind, Geometry: int) -> None: ...
    @overload
    def __init__(self, I: TopOpeBRepDS_Interference) -> None: ...
    def ChangeTransition(self) -> TopOpeBRepDS_Transition: ...
    def GKGSKS(self) -> Tuple[TopOpeBRepDS_Kind, int, TopOpeBRepDS_Kind, int]: ...
    @overload
    def Geometry(self) -> int: ...
    @overload
    def Geometry(self, G: int) -> None: ...
    @overload
    def GeometryType(self) -> TopOpeBRepDS_Kind: ...
    @overload
    def GeometryType(self, GT: TopOpeBRepDS_Kind) -> None: ...
    def HasSameGeometry(self, Other: TopOpeBRepDS_Interference) -> bool: ...
    def HasSameSupport(self, Other: TopOpeBRepDS_Interference) -> bool: ...
    def SetGeometry(self, GI: int) -> None: ...
    @overload
    def Support(self) -> int: ...
    @overload
    def Support(self, S: int) -> None: ...
    @overload
    def SupportType(self) -> TopOpeBRepDS_Kind: ...
    @overload
    def SupportType(self, ST: TopOpeBRepDS_Kind) -> None: ...
    @overload
    def Transition(self) -> TopOpeBRepDS_Transition: ...
    @overload
    def Transition(self, T: TopOpeBRepDS_Transition) -> None: ...

class TopOpeBRepDS_InterferenceIterator:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, L: TopOpeBRepDS_ListOfInterference) -> None: ...
    def ChangeIterator(self) -> TopOpeBRepDS_ListIteratorOfListOfInterference: ...
    def Geometry(self, G: int) -> None: ...
    def GeometryKind(self, GK: TopOpeBRepDS_Kind) -> None: ...
    def Init(self, L: TopOpeBRepDS_ListOfInterference) -> None: ...
    def Match(self) -> None: ...
    def MatchInterference(self, I: TopOpeBRepDS_Interference) -> bool: ...
    def More(self) -> bool: ...
    def Next(self) -> None: ...
    def Support(self, S: int) -> None: ...
    def SupportKind(self, ST: TopOpeBRepDS_Kind) -> None: ...
    def Value(self) -> TopOpeBRepDS_Interference: ...

class TopOpeBRepDS_InterferenceTool:
    @staticmethod
    def DuplicateCurvePointInterference(I: TopOpeBRepDS_Interference) -> TopOpeBRepDS_Interference: ...
    @staticmethod
    def MakeCurveInterference(T: TopOpeBRepDS_Transition, SK: TopOpeBRepDS_Kind, SI: int, GK: TopOpeBRepDS_Kind, GI: int, P: float) -> TopOpeBRepDS_Interference: ...
    @staticmethod
    def MakeEdgeInterference(T: TopOpeBRepDS_Transition, SK: TopOpeBRepDS_Kind, SI: int, GK: TopOpeBRepDS_Kind, GI: int, P: float) -> TopOpeBRepDS_Interference: ...
    @staticmethod
    def MakeEdgeVertexInterference(Transition: TopOpeBRepDS_Transition, EdgeI: int, VertexI: int, VertexIsBound: bool, Config: TopOpeBRepDS_Config, param: float) -> TopOpeBRepDS_Interference: ...
    @staticmethod
    def MakeFaceCurveInterference(Transition: TopOpeBRepDS_Transition, FaceI: int, CurveI: int, PC: Geom2d_Curve) -> TopOpeBRepDS_Interference: ...
    @staticmethod
    def MakeFaceEdgeInterference(Transition: TopOpeBRepDS_Transition, FaceI: int, EdgeI: int, EdgeIsBound: bool, Config: TopOpeBRepDS_Config) -> TopOpeBRepDS_Interference: ...
    @staticmethod
    def MakeSolidSurfaceInterference(Transition: TopOpeBRepDS_Transition, SolidI: int, SurfaceI: int) -> TopOpeBRepDS_Interference: ...
    @overload
    @staticmethod
    def Parameter(CPI: TopOpeBRepDS_Interference) -> float: ...
    @overload
    @staticmethod
    def Parameter(CPI: TopOpeBRepDS_Interference, Par: float) -> None: ...

class TopOpeBRepDS_ListOfShapeOn1State:
    def __init__(self) -> None: ...
    def ChangeListOnState(self) -> TopTools_ListOfShape: ...
    def Clear(self) -> None: ...
    def IsSplit(self) -> bool: ...
    def ListOnState(self) -> TopTools_ListOfShape: ...
    def Split(self, B: Optional[bool] = True) -> None: ...

class TopOpeBRepDS_Marker(Standard_Transient):
    def __init__(self) -> None: ...
    def Allocate(self, n: int) -> None: ...
    def GetI(self, i: int) -> bool: ...
    def Reset(self) -> None: ...
    @overload
    def Set(self, i: int, b: bool) -> None: ...
    @overload
    def Set(self, b: bool, n: int, a: None) -> None: ...

class TopOpeBRepDS_Point:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt, T: float) -> None: ...
    @overload
    def __init__(self, S: TopoDS_Shape) -> None: ...
    def ChangeKeep(self, B: bool) -> None: ...
    def ChangePoint(self) -> gp_Pnt: ...
    def IsEqual(self, other: TopOpeBRepDS_Point) -> bool: ...
    def Keep(self) -> bool: ...
    def Point(self) -> gp_Pnt: ...
    @overload
    def Tolerance(self) -> float: ...
    @overload
    def Tolerance(self, Tol: float) -> None: ...

class TopOpeBRepDS_PointExplorer:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, DS: TopOpeBRepDS_DataStructure, FindOnlyKeep: Optional[bool] = True) -> None: ...
    def Index(self) -> int: ...
    def Init(self, DS: TopOpeBRepDS_DataStructure, FindOnlyKeep: Optional[bool] = True) -> None: ...
    def IsPoint(self, I: int) -> bool: ...
    def IsPointKeep(self, I: int) -> bool: ...
    def More(self) -> bool: ...
    def NbPoint(self) -> int: ...
    def Next(self) -> None: ...
    @overload
    def Point(self) -> TopOpeBRepDS_Point: ...
    @overload
    def Point(self, I: int) -> TopOpeBRepDS_Point: ...

class TopOpeBRepDS_Reducer:
    def __init__(self, HDS: TopOpeBRepDS_HDataStructure) -> None: ...
    def ProcessEdgeInterferences(self) -> None: ...
    def ProcessFaceInterferences(self, M: TopOpeBRepDS_DataMapOfShapeListOfShapeOn1State) -> None: ...

class TopOpeBRepDS_ShapeData:
    def __init__(self) -> None: ...
    def ChangeInterferences(self) -> TopOpeBRepDS_ListOfInterference: ...
    def ChangeKeep(self, B: bool) -> None: ...
    def Interferences(self) -> TopOpeBRepDS_ListOfInterference: ...
    def Keep(self) -> bool: ...

class TopOpeBRepDS_ShapeWithState:
    def __init__(self) -> None: ...
    def AddPart(self, aShape: TopoDS_Shape, aState: TopAbs_State) -> None: ...
    def AddParts(self, aListOfShape: TopTools_ListOfShape, aState: TopAbs_State) -> None: ...
    def IsSplitted(self) -> bool: ...
    def Part(self, aState: TopAbs_State) -> TopTools_ListOfShape: ...
    def SetIsSplitted(self, anIsSplitted: bool) -> None: ...
    def SetState(self, aState: TopAbs_State) -> None: ...
    def State(self) -> TopAbs_State: ...

class TopOpeBRepDS_Surface:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, P: Geom_Surface, T: float) -> None: ...
    @overload
    def __init__(self, Other: TopOpeBRepDS_Surface) -> None: ...
    def Assign(self, Other: TopOpeBRepDS_Surface) -> None: ...
    def ChangeKeep(self, theToKeep: bool) -> None: ...
    def Keep(self) -> bool: ...
    def Surface(self) -> Geom_Surface: ...
    @overload
    def Tolerance(self) -> float: ...
    @overload
    def Tolerance(self, theTol: float) -> None: ...

class TopOpeBRepDS_SurfaceExplorer:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, DS: TopOpeBRepDS_DataStructure, FindOnlyKeep: Optional[bool] = True) -> None: ...
    def Index(self) -> int: ...
    def Init(self, DS: TopOpeBRepDS_DataStructure, FindOnlyKeep: Optional[bool] = True) -> None: ...
    def IsSurface(self, I: int) -> bool: ...
    def IsSurfaceKeep(self, I: int) -> bool: ...
    def More(self) -> bool: ...
    def NbSurface(self) -> int: ...
    def Next(self) -> None: ...
    @overload
    def Surface(self) -> TopOpeBRepDS_Surface: ...
    @overload
    def Surface(self, I: int) -> TopOpeBRepDS_Surface: ...

class TopOpeBRepDS_TKI:
    def __init__(self) -> None: ...
    @overload
    def Add(self, K: TopOpeBRepDS_Kind, G: int) -> None: ...
    @overload
    def Add(self, K: TopOpeBRepDS_Kind, G: int, HI: TopOpeBRepDS_Interference) -> None: ...
    def ChangeInterferences(self, K: TopOpeBRepDS_Kind, G: int) -> TopOpeBRepDS_ListOfInterference: ...
    def ChangeValue(self) -> Tuple[TopOpeBRepDS_ListOfInterference, TopOpeBRepDS_Kind, int]: ...
    def Clear(self) -> None: ...
    def DumpTKIIterator(self, s1: Optional[str] = "", s2: Optional[str] = "") -> None: ...
    def FillOnGeometry(self, L: TopOpeBRepDS_ListOfInterference) -> None: ...
    def FillOnSupport(self, L: TopOpeBRepDS_ListOfInterference) -> None: ...
    def HasInterferences(self, K: TopOpeBRepDS_Kind, G: int) -> bool: ...
    def Init(self) -> None: ...
    def Interferences(self, K: TopOpeBRepDS_Kind, G: int) -> TopOpeBRepDS_ListOfInterference: ...
    def IsBound(self, K: TopOpeBRepDS_Kind, G: int) -> bool: ...
    def More(self) -> bool: ...
    def Next(self) -> None: ...
    def Value(self) -> Tuple[TopOpeBRepDS_ListOfInterference, TopOpeBRepDS_Kind, int]: ...

class TopOpeBRepDS_TOOL:
    @staticmethod
    def EShareG(HDS: TopOpeBRepDS_HDataStructure, E: TopoDS_Edge, lEsd: TopTools_ListOfShape) -> int: ...
    @staticmethod
    def GetConfig(HDS: TopOpeBRepDS_HDataStructure, MEspON: TopOpeBRepDS_DataMapOfShapeListOfShapeOn1State, ie: int, iesd: int) -> Tuple[bool, int]: ...
    @staticmethod
    def GetEsd(HDS: TopOpeBRepDS_HDataStructure, S: TopoDS_Shape, ie: int) -> Tuple[bool, int]: ...
    @staticmethod
    def ShareG(HDS: TopOpeBRepDS_HDataStructure, is1: int, is2: int) -> bool: ...
    @staticmethod
    def ShareSplitON(HDS: TopOpeBRepDS_HDataStructure, MspON: TopOpeBRepDS_DataMapOfShapeListOfShapeOn1State, i1: int, i2: int, spON: TopoDS_Shape) -> bool: ...

class TopOpeBRepDS_Transition:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, StateBefore: TopAbs_State, StateAfter: TopAbs_State, ShapeBefore: Optional[TopAbs_ShapeEnum] = TopAbs_FACE, ShapeAfter: Optional[TopAbs_ShapeEnum] = TopAbs_FACE) -> None: ...
    @overload
    def __init__(self, O: TopAbs_Orientation) -> None: ...
    @overload
    def After(self, S: TopAbs_State, ShapeAfter: Optional[TopAbs_ShapeEnum] = TopAbs_FACE) -> None: ...
    @overload
    def After(self) -> TopAbs_State: ...
    @overload
    def Before(self, S: TopAbs_State, ShapeBefore: Optional[TopAbs_ShapeEnum] = TopAbs_FACE) -> None: ...
    @overload
    def Before(self) -> TopAbs_State: ...
    def Complement(self) -> TopOpeBRepDS_Transition: ...
    @overload
    def Index(self, I: int) -> None: ...
    @overload
    def Index(self) -> int: ...
    @overload
    def IndexAfter(self, I: int) -> None: ...
    @overload
    def IndexAfter(self) -> int: ...
    @overload
    def IndexBefore(self, I: int) -> None: ...
    @overload
    def IndexBefore(self) -> int: ...
    def IsUnknown(self) -> bool: ...
    def ONAfter(self) -> TopAbs_ShapeEnum: ...
    def ONBefore(self) -> TopAbs_ShapeEnum: ...
    def Orientation(self, S: TopAbs_State, T: Optional[TopAbs_ShapeEnum] = TopAbs_FACE) -> TopAbs_Orientation: ...
    @overload
    def Set(self, StateBefore: TopAbs_State, StateAfter: TopAbs_State, ShapeBefore: Optional[TopAbs_ShapeEnum] = TopAbs_FACE, ShapeAfter: Optional[TopAbs_ShapeEnum] = TopAbs_FACE) -> None: ...
    @overload
    def Set(self, O: TopAbs_Orientation) -> None: ...
    @overload
    def ShapeAfter(self, SE: TopAbs_ShapeEnum) -> None: ...
    @overload
    def ShapeAfter(self) -> TopAbs_ShapeEnum: ...
    @overload
    def ShapeBefore(self, SE: TopAbs_ShapeEnum) -> None: ...
    @overload
    def ShapeBefore(self) -> TopAbs_ShapeEnum: ...
    def StateAfter(self, S: TopAbs_State) -> None: ...
    def StateBefore(self, S: TopAbs_State) -> None: ...

class TopOpeBRepDS_CurveData(TopOpeBRepDS_GeometryData):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, C: TopOpeBRepDS_Curve) -> None: ...

class TopOpeBRepDS_CurveIterator(TopOpeBRepDS_InterferenceIterator):
    def __init__(self, L: TopOpeBRepDS_ListOfInterference) -> None: ...
    def Current(self) -> int: ...
    def MatchInterference(self, I: TopOpeBRepDS_Interference) -> bool: ...
    def Orientation(self, S: TopAbs_State) -> TopAbs_Orientation: ...
    def PCurve(self) -> Geom2d_Curve: ...

class TopOpeBRepDS_CurvePointInterference(TopOpeBRepDS_Interference):
    def __init__(self, T: TopOpeBRepDS_Transition, ST: TopOpeBRepDS_Kind, S: int, GT: TopOpeBRepDS_Kind, G: int, P: float) -> None: ...
    @overload
    def Parameter(self) -> float: ...
    @overload
    def Parameter(self, P: float) -> None: ...

class TopOpeBRepDS_PointData(TopOpeBRepDS_GeometryData):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, P: TopOpeBRepDS_Point) -> None: ...
    @overload
    def __init__(self, P: TopOpeBRepDS_Point, I1: int, I2: int) -> None: ...
    def GetShapes(self) -> Tuple[int, int]: ...
    def SetShapes(self, I1: int, I2: int) -> None: ...

class TopOpeBRepDS_PointIterator(TopOpeBRepDS_InterferenceIterator):
    def __init__(self, L: TopOpeBRepDS_ListOfInterference) -> None: ...
    def Current(self) -> int: ...
    def DiffOriented(self) -> bool: ...
    def IsPoint(self) -> bool: ...
    def IsVertex(self) -> bool: ...
    def MatchInterference(self, I: TopOpeBRepDS_Interference) -> bool: ...
    def Orientation(self, S: TopAbs_State) -> TopAbs_Orientation: ...
    def Parameter(self) -> float: ...
    def SameOriented(self) -> bool: ...
    def Support(self) -> int: ...

class TopOpeBRepDS_ShapeShapeInterference(TopOpeBRepDS_Interference):
    def __init__(self, T: TopOpeBRepDS_Transition, ST: TopOpeBRepDS_Kind, S: int, GT: TopOpeBRepDS_Kind, G: int, GBound: bool, C: TopOpeBRepDS_Config) -> None: ...
    def Config(self) -> TopOpeBRepDS_Config: ...
    def GBound(self) -> bool: ...
    def SetGBound(self, b: bool) -> None: ...

class TopOpeBRepDS_SolidSurfaceInterference(TopOpeBRepDS_Interference):
    def __init__(self, Transition: TopOpeBRepDS_Transition, SupportType: TopOpeBRepDS_Kind, Support: int, GeometryType: TopOpeBRepDS_Kind, Geometry: int) -> None: ...

class TopOpeBRepDS_SurfaceCurveInterference(TopOpeBRepDS_Interference):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, Transition: TopOpeBRepDS_Transition, SupportType: TopOpeBRepDS_Kind, Support: int, GeometryType: TopOpeBRepDS_Kind, Geometry: int, PC: Geom2d_Curve) -> None: ...
    @overload
    def __init__(self, I: TopOpeBRepDS_Interference) -> None: ...
    @overload
    def PCurve(self) -> Geom2d_Curve: ...
    @overload
    def PCurve(self, PC: Geom2d_Curve) -> None: ...

class TopOpeBRepDS_SurfaceData(TopOpeBRepDS_GeometryData):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, S: TopOpeBRepDS_Surface) -> None: ...

class TopOpeBRepDS_SurfaceIterator(TopOpeBRepDS_InterferenceIterator):
    def __init__(self, L: TopOpeBRepDS_ListOfInterference) -> None: ...
    def Current(self) -> int: ...
    def Orientation(self, S: TopAbs_State) -> TopAbs_Orientation: ...

class TopOpeBRepDS_EdgeVertexInterference(TopOpeBRepDS_ShapeShapeInterference):
    @overload
    def __init__(self, T: TopOpeBRepDS_Transition, ST: TopOpeBRepDS_Kind, S: int, G: int, GIsBound: bool, C: TopOpeBRepDS_Config, P: float) -> None: ...
    @overload
    def __init__(self, T: TopOpeBRepDS_Transition, S: int, G: int, GIsBound: bool, C: TopOpeBRepDS_Config, P: float) -> None: ...
    @overload
    def Parameter(self) -> float: ...
    @overload
    def Parameter(self, P: float) -> None: ...

class TopOpeBRepDS_FaceEdgeInterference(TopOpeBRepDS_ShapeShapeInterference):
    def __init__(self, T: TopOpeBRepDS_Transition, S: int, G: int, GIsBound: bool, C: TopOpeBRepDS_Config) -> None: ...

#classnotwrapped
class TopOpeBRepDS_DSS: ...

#classnotwrapped
class TopOpeBRepDS_HDataStructure: ...

# harray1 classes

class TopOpeBRepDS_HArray1OfDataMapOfIntegerListOfInterference(TopOpeBRepDS_Array1OfDataMapOfIntegerListOfInterference, Standard_Transient):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> TopOpeBRepDS_Array1OfDataMapOfIntegerListOfInterference: ...

# harray2 classes
# hsequence classes

