import { EndpointParameterInstructions } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@smithy/types";
import {
  CloudFormationClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../CloudFormationClient";
import { TestTypeInput, TestTypeOutput } from "../models/models_0";
export { __MetadataBearer, $Command };
export interface TestTypeCommandInput extends TestTypeInput {}
export interface TestTypeCommandOutput
  extends TestTypeOutput,
    __MetadataBearer {}
export declare class TestTypeCommand extends $Command<
  TestTypeCommandInput,
  TestTypeCommandOutput,
  CloudFormationClientResolvedConfig
> {
  readonly input: TestTypeCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: TestTypeCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: CloudFormationClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<TestTypeCommandInput, TestTypeCommandOutput>;
  private serialize;
  private deserialize;
}
