/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.network;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.parosproxy.paros.network.HttpBody;
import org.parosproxy.paros.network.HttpResponseHeader;

public class HttpOutputStream
extends BufferedOutputStream {
    private static final int BUFFER_SIZE = 4096;
    private static final String CODEPAGE = "8859_1";

    public HttpOutputStream(OutputStream out) {
        super(out, 4096);
    }

    public void write(String data) throws IOException {
        super.write(data.getBytes(CODEPAGE));
        this.flush();
    }

    public void write(HttpBody body) throws IOException {
        if (body != null && body.length() > 0) {
            this.write(body.toString().getBytes(CODEPAGE));
        }
    }

    public void write(HttpResponseHeader resHeader) throws IOException {
        this.write(resHeader.toString());
    }

    @Override
    public void write(byte[] buf) throws IOException {
        if (buf == null) {
            return;
        }
        this.write(buf, 0, buf.length);
    }

    public void write(byte[] buf, int len) throws IOException {
        this.write(buf, 0, len);
    }

    @Override
    public synchronized void write(byte[] buf, int off, int len) throws IOException {
        if (buf == null) {
            return;
        }
        super.write(buf, off, len);
        this.flush();
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void flush() throws IOException {
        super.flush();
    }
}

