/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.filter.condition;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.freeplane.features.filter.condition.ConditionFactory;
import org.freeplane.features.filter.condition.ICondition;
import org.freeplane.features.filter.condition.JCondition;
import org.freeplane.n3.nanoxml.XMLElement;

public abstract class ASelectableCondition
implements ICondition {
    public static final float STRING_MIN_MATCH_PROB = 0.7f;
    private transient String description;
    private transient JComponent renderer;
    private String userName;
    private static Method EQUALS;
    private static Method HASH;

    public int hashCode() {
        if (HASH == null) {
            return super.hashCode();
        }
        try {
            return (Integer)HASH.invoke(null, this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return super.hashCode();
        }
    }

    public boolean equals(final Object obj) {
        if (EQUALS == null) {
            return super.equals(obj);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                    return (Boolean)EQUALS.invoke(null, ASelectableCondition.this, obj);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            return super.equals(obj);
        }
    }

    protected abstract String createDescription();

    public final JComponent getListCellRendererComponent() {
        if (this.renderer == null) {
            this.renderer = this.createGraphicComponent();
        }
        return this.renderer;
    }

    public JComponent createGraphicComponent() {
        JComponent renderer = this.createRendererComponent();
        if (this.userName != null) {
            JCondition jCondition = new JCondition();
            jCondition.add(new JLabel(this.userName + " : "));
            jCondition.add(renderer);
            renderer = jCondition;
        }
        return renderer;
    }

    protected JComponent createRendererComponent() {
        return ConditionFactory.createCellRendererComponent(this.toString());
    }

    public final String toString() {
        if (this.description == null) {
            this.description = this.createDescription();
        }
        return this.description;
    }

    public void toXml(XMLElement element) {
        XMLElement child = new XMLElement();
        child.setName(this.getName());
        if (this.userName != null) {
            child.setAttribute("user_name", this.userName);
        }
        this.fillXML(child);
        element.addChild(child);
    }

    protected void fillXML(XMLElement element) {
    }

    protected abstract String getName();

    public void setUserName(String userName) {
        if (userName == this.userName || userName != null && userName.equals(this.userName)) {
            return;
        }
        this.userName = userName;
        this.renderer = null;
    }

    public String getUserName() {
        return this.userName;
    }

    protected JComponent createShortRendererComponent() {
        if (this.userName == null) {
            return this.createRendererComponent();
        }
        JLabel label = new JLabel('\"' + this.userName + '\"');
        return label;
    }

    public boolean canBePersisted() {
        return true;
    }

    static {
        try {
            ClassLoader classLoader = ASelectableCondition.class.getClassLoader();
            EQUALS = classLoader.loadClass("org.apache.commons.lang.builder.EqualsBuilder").getMethod("reflectionEquals", Object.class, Object.class);
            HASH = classLoader.loadClass("org.apache.commons.lang.builder.HashCodeBuilder").getMethod("reflectionHashCode", Object.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

