/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.hibernate;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEventPublisher;
import ca.odell.glazedlists.hibernate.CategoryEventListFactory;
import ca.odell.glazedlists.hibernate.EventListFactory;
import ca.odell.glazedlists.hibernate.PersistentEventList;
import ca.odell.glazedlists.util.concurrent.ReadWriteLock;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserCollectionType;

public class EventListType
implements UserCollectionType,
ParameterizedType {
    public static final String PROPERTYNAME_EVENTLIST_CATEGORY = "EventList.category";
    private EventListFactory listFactory = EventListFactory.DEFAULT;

    public final EventListFactory getListFactory() {
        return this.listFactory;
    }

    public final void setListFactory(EventListFactory newListFactory) {
        if (newListFactory == null) {
            throw new IllegalArgumentException("EventListFactory must not be null");
        }
        this.listFactory = newListFactory;
    }

    public final void setParameterValues(Properties parameters) {
        if (parameters == null) {
            return;
        }
        String category = parameters.getProperty(PROPERTYNAME_EVENTLIST_CATEGORY);
        if (category != null) {
            this.useListCategory(category);
        }
    }

    protected final void useListCategory(String category) {
        this.setListFactory(new CategoryEventListFactory(category));
    }

    protected final void useListCategory(String category, ReadWriteLock lock, ListEventPublisher publisher) {
        this.setListFactory(new CategoryEventListFactory(category, lock, publisher));
    }

    public boolean contains(Object collection, Object entity) {
        return ((EventList)collection).contains(entity);
    }

    public Iterator getElementsIterator(Object collection) {
        return ((EventList)collection).iterator();
    }

    public Object indexOf(Object collection, Object obj) {
        int index = ((EventList)collection).indexOf(obj);
        return index < 0 ? null : new Integer(index);
    }

    public Object instantiate() {
        return this.getListFactory().createEventList();
    }

    public Object instantiate(int anticipatedSize) {
        EventListFactory fac = this.getListFactory();
        return anticipatedSize < 0 ? fac.createEventList() : fac.createEventList(anticipatedSize);
    }

    public PersistentCollection instantiate(SessionImplementor session, CollectionPersister persister) throws HibernateException {
        return new PersistentEventList(session, this.getListFactory());
    }

    public Object replaceElements(Object original, Object target, CollectionPersister persister, Object owner, Map copyCache, SessionImplementor session) throws HibernateException {
        EventList result = (EventList)target;
        EventList source2 = (EventList)original;
        result.clear();
        result.addAll(source2);
        return result;
    }

    public PersistentCollection wrap(SessionImplementor session, Object collection) {
        return new PersistentEventList(session, (EventList)collection);
    }
}

