"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = adPlugin;
var _constants = require("../../utils/constants");
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

function adPlugin(Client, config, components) {
  const ca = components.clientAction.factory;
  Client.prototype.ad = components.clientAction.namespaceFactory();
  const ad = Client.prototype.ad.prototype;
  ad.deleteDetector = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/<%=detectorId%>`,
      req: {
        detectorId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'DELETE'
  });
  ad.previewDetector = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/_preview`
    },
    needBody: true,
    method: 'POST'
  });
  ad.createDetector = ca({
    url: {
      fmt: _constants.API.DETECTOR_BASE
    },
    needBody: true,
    method: 'POST'
  });
  ad.validateDetector = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/_validate/<%=validationType%>`,
      req: {
        validationType: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'POST'
  });
  ad.searchDetector = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/_search`
    },
    needBody: true,
    method: 'POST'
  });
  ad.searchTasks = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/tasks/_search`
    },
    needBody: true,
    method: 'POST'
  });
  ad.updateDetector = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/<%=detectorId%>?if_seq_no=<%=ifSeqNo%>&if_primary_term=<%=ifPrimaryTerm%>&refresh=wait_for`,
      req: {
        detectorId: {
          type: 'string',
          required: true
        },
        ifSeqNo: {
          type: 'string',
          required: true
        },
        ifPrimaryTerm: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'PUT'
  });
  ad.getDetector = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/<%=detectorId%>?job=true&task=true`,
      req: {
        detectorId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  ad.searchResults = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/results/_search`
    },
    needBody: true,
    method: 'POST'
  });
  ad.searchResultsFromCustomResultIndex = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/results/_search/<%=resultIndex%>?only_query_custom_result_index=<%=onlyQueryCustomResultIndex%>`,
      req: {
        resultIndex: {
          type: 'string',
          required: false
        },
        onlyQueryCustomResultIndex: {
          type: 'string',
          required: false
        }
      }
    },
    needBody: true,
    method: 'POST'
  });
  ad.startDetector = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/<%=detectorId%>/_start`,
      req: {
        detectorId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'POST'
  });
  ad.startHistoricalDetector = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/<%=detectorId%>/_start`,
      req: {
        detectorId: {
          type: 'string',
          required: true
        }
      },
      needBody: true
    },
    method: 'POST'
  });
  ad.stopDetector = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/<%=detectorId%>/_stop`,
      req: {
        detectorId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'POST'
  });
  ad.stopHistoricalDetector = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/<%=detectorId%>/_stop?historical=true`,
      req: {
        detectorId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'POST'
  });
  ad.detectorProfile = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/<%=detectorId%>/_profile/init_progress,state,error`,
      req: {
        detectorId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  ad.matchDetector = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/match?name=<%=detectorName%>`,
      req: {
        detectorName: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'GET'
  });
  ad.detectorCount = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/count`
    },
    method: 'GET'
  });
  ad.topAnomalyResults = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/<%=detectorId%>/results/_topAnomalies?historical=false`,
      req: {
        detectorId: {
          type: 'string',
          required: true
        }
      },
      needBody: true
    },
    method: 'POST'
  });
  ad.topHistoricalAnomalyResults = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/<%=detectorId%>/results/_topAnomalies?historical=true`,
      req: {
        detectorId: {
          type: 'string',
          required: true
        }
      },
      needBody: true
    },
    method: 'POST'
  });
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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