/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import java.util.NoSuchElementException;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.LinearSeqOps;
import scala.collection.SeqFactory;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StrictOptimizedSeqOps;
import scala.collection.generic.DefaultSerializable;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.AbstractBuffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.MutationTracker;
import scala.collection.mutable.ReusableBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.Statics;

public class ListBuffer<A>
extends AbstractBuffer<A>
implements StrictOptimizedSeqOps<A, ListBuffer, ListBuffer<A>>,
DefaultSerializable,
ReusableBuilder<A, List<A>> {
    private transient int mutationCount = 0;
    private List<A> first = Nil$.MODULE$;
    private $colon$colon<A> last0 = null;
    private boolean aliased = false;
    private int len = 0;

    /*
     * WARNING - void declaration
     */
    @Override
    public void sizeHint(int size) {
        void var1_1;
        Builder.sizeHint$(this, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void sizeHint(IterableOnce<?> coll, int delta) {
        void var2_2;
        void var1_1;
        Builder.sizeHint$(this, (IterableOnce)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <NewTo> Builder<A, NewTo> mapResult(Function1<List<A>, NewTo> f) {
        void var1_1;
        return Builder.mapResult$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object distinctBy(Function1 f) {
        void var1_1;
        return StrictOptimizedSeqOps.distinctBy$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object prepended(Object elem) {
        void var1_1;
        return StrictOptimizedSeqOps.prepended$(this, (Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object appended(Object elem) {
        void var1_1;
        return StrictOptimizedSeqOps.appended$(this, (Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object appendedAll(IterableOnce suffix) {
        void var1_1;
        return StrictOptimizedSeqOps.appendedAll$(this, (IterableOnce)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Tuple2<ListBuffer<A>, ListBuffer<A>> partition(Function1<A, Object> p) {
        void var1_1;
        return StrictOptimizedIterableOps.partition$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <A1, A2> Tuple2<ListBuffer<A1>, ListBuffer<A2>> unzip(Function1<A, Tuple2<A1, A2>> asPair) {
        void var1_1;
        return StrictOptimizedIterableOps.unzip$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object map(Function1 f) {
        void var1_1;
        return StrictOptimizedIterableOps.map$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object flatMap(Function1 f) {
        void var1_1;
        return StrictOptimizedIterableOps.flatMap$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object collect(PartialFunction pf) {
        void var1_1;
        return StrictOptimizedIterableOps.collect$(this, (PartialFunction)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object flatten(Function1 toIterableOnce) {
        void var1_1;
        return StrictOptimizedIterableOps.flatten$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object zip(IterableOnce that) {
        void var1_1;
        return StrictOptimizedIterableOps.zip$(this, (IterableOnce)var1_1);
    }

    @Override
    public Object zipWithIndex() {
        return StrictOptimizedIterableOps.zipWithIndex$(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object filter(Function1 pred) {
        void var1_1;
        return StrictOptimizedIterableOps.filter$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object filterNot(Function1 pred) {
        void var1_1;
        return StrictOptimizedIterableOps.filterNot$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object filterImpl(Function1 pred, boolean isFlipped) {
        void var2_2;
        void var1_1;
        return StrictOptimizedIterableOps.filterImpl$(this, (Function1)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object dropRight(int n) {
        void var1_1;
        return StrictOptimizedIterableOps.dropRight$(this, (int)var1_1);
    }

    private List<A> first() {
        return this.first;
    }

    /*
     * WARNING - void declaration
     */
    private void first_$eq(List<A> x$1) {
        void var1_1;
        this.first = var1_1;
    }

    private $colon$colon<A> last0() {
        return this.last0;
    }

    /*
     * WARNING - void declaration
     */
    private void last0_$eq($colon$colon<A> x$1) {
        void var1_1;
        this.last0 = var1_1;
    }

    @Override
    public Iterator<A> iterator() {
        return new MutationTracker.CheckedIterator<A>(this.first().iterator(), () -> $this.mutationCount);
    }

    @Override
    public SeqFactory<ListBuffer> iterableFactory() {
        return ListBuffer$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public A apply(int i) throws IndexOutOfBoundsException {
        void var1_1;
        List<A> list = this.first();
        if (list == null) {
            throw null;
        }
        return (A)LinearSeqOps.apply$(list, (int)var1_1);
    }

    @Override
    public int length() {
        return this.len;
    }

    @Override
    public int knownSize() {
        return this.len;
    }

    @Override
    public boolean isEmpty() {
        return this.len == 0;
    }

    /*
     * WARNING - void declaration
     */
    private void copyElems() {
        void var1_1;
        ListBuffer<A> buf = new ListBuffer<A>().scala$collection$mutable$ListBuffer$$freshFrom(this);
        this.first_$eq(super.first());
        this.last0_$eq(super.last0());
        this.aliased = false;
    }

    private void ensureUnaliased() {
        ++this.mutationCount;
        if (this.aliased) {
            this.copyElems();
            return;
        }
    }

    @Override
    public List<A> toList() {
        this.aliased = this.nonEmpty();
        Statics.releaseFence();
        return this.first();
    }

    @Override
    public List<A> result() {
        return this.toList();
    }

    /*
     * WARNING - void declaration
     */
    public List<A> prependToList(List<A> xs) {
        void var1_1;
        if (this.isEmpty()) {
            return xs;
        }
        this.ensureUnaliased();
        this.last0().next_$eq((List<A>)var1_1);
        return this.toList();
    }

    @Override
    public void clear() {
        ++this.mutationCount;
        this.first_$eq(Nil$.MODULE$);
        this.len = 0;
        this.last0_$eq(null);
        this.aliased = false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ListBuffer<A> addOne(A elem) {
        void var1_1;
        this.ensureUnaliased();
        $colon$colon<Nothing$> last1 = new $colon$colon<Nothing$>((Nothing$)elem, Nil$.MODULE$);
        if (this.len == 0) {
            this.first_$eq(last1);
        } else {
            this.last0().next_$eq(last1);
        }
        this.last0_$eq(($colon$colon<A>)var1_1);
        ++this.len;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ListBuffer<A> scala$collection$mutable$ListBuffer$$freshFrom(IterableOnce<A> xs) {
        Iterator<A> it = xs.iterator();
        if (it.hasNext()) {
            void var3_3;
            void var2_2;
            int len = 1;
            $colon$colon<Nothing$> last0 = new $colon$colon<Nothing$>((Nothing$)it.next(), Nil$.MODULE$);
            this.first_$eq(last0);
            while (it.hasNext()) {
                $colon$colon<Nothing$> last1 = new $colon$colon<Nothing$>((Nothing$)it.next(), Nil$.MODULE$);
                last0.next_$eq(last1);
                last0 = last1;
                ++len;
            }
            this.len = var2_2;
            this.last0_$eq(($colon$colon<A>)var3_3);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ListBuffer<A> addAll(IterableOnce<A> xs) {
        Iterator<A> it = xs.iterator();
        if (it.hasNext()) {
            void var1_1;
            ListBuffer<A> fresh = new ListBuffer<A>().scala$collection$mutable$ListBuffer$$freshFrom(it);
            this.ensureUnaliased();
            if (this.len == 0) {
                this.first_$eq(super.first());
            } else {
                this.last0().next_$eq(super.first());
            }
            this.last0_$eq(super.last0());
            this.len += var1_1.length();
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ListBuffer<A> subtractOne(A elem) {
        this.ensureUnaliased();
        if (!this.isEmpty()) {
            if (BoxesRunTime.equals(this.first().head(), elem)) {
                ListBuffer listBuffer = this;
                listBuffer.first_$eq((List)listBuffer.first().tail());
                this.reduceLengthBy(1);
            } else {
                List cursor = this.first();
                while (!((List)cursor.tail()).isEmpty() && !BoxesRunTime.equals(((IterableOps)cursor.tail()).head(), elem)) {
                    cursor = (List)cursor.tail();
                }
                if (!((List)cursor.tail()).isEmpty()) {
                    void var2_2;
                    void var1_1;
                    $colon$colon z = ($colon$colon)cursor;
                    List list = z.next();
                    $colon$colon<A> $colon$colon = this.last0();
                    if (!(list != null ? !((Object)list).equals($colon$colon) : $colon$colon != null)) {
                        this.last0_$eq(z);
                    }
                    var1_1.next_$eq((List)((IterableOps)var2_2.tail()).tail());
                    this.reduceLengthBy(1);
                }
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private void reduceLengthBy(int num) {
        void var1_1;
        this.len -= var1_1;
        if (this.len <= 0) {
            this.last0_$eq(null);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private $colon$colon<A> locate(int i) {
        void var2_2;
        if (i == 0) {
            return null;
        }
        if (i == this.len) {
            return this.last0();
        }
        List p = this.first();
        for (int j = i - 1; j > 0; --j) {
            p = (List)p.tail();
        }
        return ($colon$colon)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private List<A> getNext($colon$colon<A> p) {
        void var1_1;
        if (p == null) {
            return this.first();
        }
        return var1_1.next();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void update(int idx, A elem) {
        void var2_4;
        void var1_3;
        void newElem2;
        this.ensureUnaliased();
        if (idx < 0 || idx >= this.len) {
            throw new IndexOutOfBoundsException(new StringBuilder(31).append(idx).append(" is out of bounds (min 0, max ").append(this.len - 1).append(")").toString());
        }
        if (idx == 0) {
            $colon$colon<A> newElem2 = new $colon$colon<A>(elem, (List)this.first().tail());
            if (this.last0() == this.first()) {
                this.last0_$eq(newElem2);
            }
            this.first_$eq(newElem2);
            return;
        }
        $colon$colon<A> p = this.locate((int)newElem2);
        if (p == null) {
            throw null;
        }
        $colon$colon<A> newElem3 = new $colon$colon<A>(elem, (List)p.next().tail());
        if (this.last0() == p.next()) {
            this.last0_$eq(newElem3);
        }
        var1_3.next_$eq(var2_4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public A remove(int idx) {
        void var2_3;
        this.ensureUnaliased();
        if (idx < 0 || idx >= this.len) {
            throw new IndexOutOfBoundsException(new StringBuilder(31).append(idx).append(" is out of bounds (min 0, max ").append(this.len - 1).append(")").toString());
        }
        $colon$colon<A> p = this.locate(idx);
        List<A> nx = this.getNext(p);
        if (p == null) {
            this.first_$eq((List)nx.tail());
            if (this.first().isEmpty()) {
                this.last0_$eq(null);
            }
        } else {
            void var1_2;
            if (this.last0() == nx) {
                this.last0_$eq(p);
            }
            var1_2.next_$eq((List)nx.tail());
        }
        --this.len;
        return var2_3.head();
    }

    @Override
    public A last() {
        if (this.last0() == null) {
            throw new NoSuchElementException("last of empty ListBuffer");
        }
        return this.last0().head();
    }

    @Override
    public Option<A> lastOption() {
        if (this.last0() == null) {
            return None$.MODULE$;
        }
        return new Some<A>(this.last0().head());
    }

    @Override
    public String stringPrefix() {
        return "ListBuffer";
    }
}

