/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge.svg12;

import io.sf.carte.echosvg.anim.dom.XBLOMContentElement;
import io.sf.carte.echosvg.bridge.AbstractGraphicsNodeBridge;
import io.sf.carte.echosvg.bridge.Bridge;
import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.GVTBuilder;
import io.sf.carte.echosvg.bridge.svg12.ContentManager;
import io.sf.carte.echosvg.bridge.svg12.ContentSelectionChangedEvent;
import io.sf.carte.echosvg.bridge.svg12.ContentSelectionChangedListener;
import io.sf.carte.echosvg.bridge.svg12.DefaultXBLManager;
import io.sf.carte.echosvg.dom.AbstractDocument;
import io.sf.carte.echosvg.gvt.CompositeGraphicsNode;
import io.sf.carte.echosvg.gvt.GraphicsNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XBLContentElementBridge
extends AbstractGraphicsNodeBridge {
    protected ContentChangedListener contentChangedListener;
    protected ContentManager contentManager;

    @Override
    public String getLocalName() {
        return "content";
    }

    @Override
    public String getNamespaceURI() {
        return "http://www.w3.org/2004/xbl";
    }

    @Override
    public Bridge getInstance() {
        return new XBLContentElementBridge();
    }

    @Override
    public GraphicsNode createGraphicsNode(BridgeContext bridgeContext, Element element) {
        CompositeGraphicsNode compositeGraphicsNode = this.buildCompositeGraphicsNode(bridgeContext, element, null);
        return compositeGraphicsNode;
    }

    public CompositeGraphicsNode buildCompositeGraphicsNode(BridgeContext bridgeContext, Element element, CompositeGraphicsNode compositeGraphicsNode) {
        XBLOMContentElement xBLOMContentElement = (XBLOMContentElement)element;
        AbstractDocument abstractDocument = (AbstractDocument)element.getOwnerDocument();
        DefaultXBLManager defaultXBLManager = (DefaultXBLManager)abstractDocument.getXBLManager();
        this.contentManager = defaultXBLManager.getContentManager(element);
        if (compositeGraphicsNode == null) {
            compositeGraphicsNode = new CompositeGraphicsNode();
            this.associateSVGContext(bridgeContext, element, (GraphicsNode)compositeGraphicsNode);
        } else {
            int n = compositeGraphicsNode.size();
            for (int i = 0; i < n; ++i) {
                compositeGraphicsNode.remove(0);
            }
        }
        GVTBuilder gVTBuilder = bridgeContext.getGVTBuilder();
        NodeList nodeList = this.contentManager.getSelectedContent(xBLOMContentElement);
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                GraphicsNode graphicsNode;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || (graphicsNode = gVTBuilder.build(bridgeContext, (Element)node)) == null) continue;
                compositeGraphicsNode.add(graphicsNode);
            }
        }
        if (bridgeContext.isDynamic() && this.contentChangedListener == null) {
            this.contentChangedListener = new ContentChangedListener();
            this.contentManager.addContentSelectionChangedListener(xBLOMContentElement, this.contentChangedListener);
        }
        return compositeGraphicsNode;
    }

    @Override
    protected GraphicsNode instantiateGraphicsNode() {
        return null;
    }

    @Override
    public void buildGraphicsNode(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode) {
        this.initializeDynamicSupport(bridgeContext, element, graphicsNode);
    }

    @Override
    public boolean getDisplay(Element element) {
        return true;
    }

    @Override
    public boolean isComposite() {
        return false;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.contentChangedListener != null) {
            this.contentManager.removeContentSelectionChangedListener((XBLOMContentElement)this.e, this.contentChangedListener);
        }
    }

    protected class ContentChangedListener
    implements ContentSelectionChangedListener {
        protected ContentChangedListener() {
        }

        @Override
        public void contentSelectionChanged(ContentSelectionChangedEvent contentSelectionChangedEvent) {
            XBLContentElementBridge.this.buildCompositeGraphicsNode(XBLContentElementBridge.this.ctx, XBLContentElementBridge.this.e, (CompositeGraphicsNode)XBLContentElementBridge.this.node);
        }
    }
}

