/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.swift.internal;

import java.util.Collections;
import org.gradle.api.file.FileCollection;
import org.gradle.internal.Cast;
import org.gradle.language.internal.DefaultBinaryCollection;
import org.gradle.language.nativeplatform.internal.ComponentWithNames;
import org.gradle.language.nativeplatform.internal.DefaultNativeComponent;
import org.gradle.language.nativeplatform.internal.Names;
import org.gradle.language.swift.SwiftBinary;
import org.gradle.language.swift.SwiftComponent;

public abstract class DefaultSwiftComponent<T extends SwiftBinary>
extends DefaultNativeComponent
implements SwiftComponent,
ComponentWithNames {
    private final DefaultBinaryCollection<T> binaries;
    private final FileCollection swiftSource;
    private final String name;
    private final Names names;

    public DefaultSwiftComponent(String name) {
        this(name, SwiftBinary.class);
    }

    public DefaultSwiftComponent(String name, Class<? extends SwiftBinary> binaryType) {
        this.name = name;
        this.swiftSource = this.createSourceView("src/" + name + "/swift", Collections.singletonList("swift"));
        this.names = Names.of(name);
        this.binaries = (DefaultBinaryCollection)Cast.uncheckedCast((Object)this.getObjectFactory().newInstance(DefaultBinaryCollection.class, new Object[]{binaryType}));
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Names getNames() {
        return this.names;
    }

    @Override
    public FileCollection getSwiftSource() {
        return this.swiftSource;
    }

    public DefaultBinaryCollection<T> getBinaries() {
        return this.binaries;
    }
}

