#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 clash-prelude
version:              1.8.2
visibility:           public
id:                   clash-prelude-1.8.2-5KishcDrCxwDF51IuUYG14
key:                  clash-prelude-1.8.2-5KishcDrCxwDF51IuUYG14
license:              BSD-2-Clause
copyright:
    Copyright © 2013-2016, University of Twente,
    2016-2017, Myrtle Software Ltd,
    2017-2019, QBayLogic B.V., Google Inc.,
    2021-2023, QBayLogic B.V.

maintainer:           QBayLogic B.V. <devops@qbaylogic.com>
author:               The Clash Authors
homepage:             https://clash-lang.org/
synopsis:
    Clash: a functional hardware description language - Prelude library

description:
    Clash is a functional hardware description language that borrows both its
    syntax and semantics from the functional programming language Haskell. The
    Clash compiler transforms these high-level descriptions to low-level
    synthesizable VHDL, Verilog, or SystemVerilog.

    Features of Clash:

    * Strongly typed, but with a very high degree of type inference, enabling both
    safe and fast prototyping using concise descriptions.

    * Interactive REPL: load your designs in an interpreter and easily test all
    your component without needing to setup a test bench.

    * Higher-order functions, with type inference, result in designs that are
    fully parametric by default.

    * Synchronous sequential circuit design based on streams of values, called
    @Signal@s, lead to natural descriptions of feedback loops.

    * Support for multiple clock domains, with type safe clock domain crossing.


    This package provides:

    * Prelude library containing datatypes and functions for circuit design

    To use the library:

    * Import "Clash.Prelude"

    * Alternatively, if you want to explicitly route clock and reset ports,
    for more straightforward multi-clock designs, you can import the
    "Clash.Explicit.Prelude" module. Note that you should not import
    "Clash.Prelude" and "Clash.Explicit.Prelude" at the same time as they
    have overlapping definitions.

    A preliminary version of a tutorial can be found in "Clash.Tutorial", for a
    general overview of the library you should however check out "Clash.Prelude".
    Some circuit examples can be found in "Clash.Examples".

category:             Hardware
abi:                  c5ab0b62011f1e0f2114869e902e89c6
exposed:              True
exposed-modules:
    Clash.Annotations.BitRepresentation
    Clash.Annotations.BitRepresentation.Deriving
    Clash.Annotations.BitRepresentation.Internal
    Clash.Annotations.BitRepresentation.Util
    Clash.Annotations.Primitive Clash.Annotations.SynthesisAttributes
    Clash.Annotations.TH Clash.Annotations.TopEntity
    Clash.Class.AutoReg Clash.Class.AutoReg.Internal
    Clash.Class.BitPack Clash.Class.BitPack.BitIndex
    Clash.Class.BitPack.BitReduction Clash.Class.BitPack.Internal
    Clash.Class.BitPack.Internal.TH Clash.Class.Counter
    Clash.Class.Counter.Internal Clash.Class.Counter.TH Clash.Class.Exp
    Clash.Class.HasDomain Clash.Class.HasDomain.CodeGen
    Clash.Class.HasDomain.Common Clash.Class.HasDomain.HasSingleDomain
    Clash.Class.HasDomain.HasSpecificDomain Clash.Class.Num
    Clash.Class.Parity Clash.Class.Resize Clash.Clocks Clash.Examples
    Clash.Examples.Internal Clash.Explicit.BlockRam
    Clash.Explicit.BlockRam.Blob Clash.Explicit.BlockRam.File
    Clash.Explicit.BlockRam.Internal Clash.Explicit.BlockRam.Model
    Clash.Explicit.DDR Clash.Explicit.Mealy Clash.Explicit.Moore
    Clash.Explicit.Prelude Clash.Explicit.Prelude.Safe
    Clash.Explicit.RAM Clash.Explicit.ROM Clash.Explicit.ROM.Blob
    Clash.Explicit.ROM.File Clash.Explicit.Reset Clash.Explicit.Signal
    Clash.Explicit.Signal.Delayed Clash.Explicit.SimIO
    Clash.Explicit.Synchronizer Clash.Explicit.Testbench
    Clash.Explicit.Verification Clash.HaskellPrelude Clash.Hidden
    Clash.Intel.ClockGen Clash.Intel.DDR Clash.Magic Clash.NamedTypes
    Clash.Num.Erroring Clash.Num.Overflowing Clash.Num.Saturating
    Clash.Num.Wrapping Clash.Num.Zeroing Clash.Prelude
    Clash.Prelude.BlockRam Clash.Prelude.BlockRam.Blob
    Clash.Prelude.BlockRam.File Clash.Prelude.DataFlow
    Clash.Prelude.Mealy Clash.Prelude.Moore Clash.Prelude.RAM
    Clash.Prelude.ROM Clash.Prelude.ROM.Blob Clash.Prelude.ROM.File
    Clash.Prelude.Safe Clash.Prelude.Testbench Clash.Promoted.Nat
    Clash.Promoted.Nat.Literals Clash.Promoted.Nat.TH
    Clash.Promoted.Nat.Unsafe Clash.Promoted.Symbol Clash.Signal
    Clash.Signal.BiSignal Clash.Signal.Bundle Clash.Signal.Delayed
    Clash.Signal.Delayed.Bundle Clash.Signal.Delayed.Internal
    Clash.Signal.Internal Clash.Signal.Internal.Ambiguous
    Clash.Signal.Trace Clash.Sized.BitVector Clash.Sized.Fixed
    Clash.Sized.Index Clash.Sized.Internal.BitVector
    Clash.Sized.Internal.Index Clash.Sized.Internal.Mod
    Clash.Sized.Internal.Signed Clash.Sized.Internal.Unsigned
    Clash.Sized.RTree Clash.Sized.Signed Clash.Sized.Unsigned
    Clash.Sized.Vector Clash.Sized.Vector.ToTuple
    Clash.Sized.Vector.ToTuple.TH Clash.Tutorial Clash.Verification
    Clash.Verification.DSL Clash.Verification.Internal Clash.XException
    Clash.XException.Internal Clash.XException.MaybeX
    Clash.XException.TH Clash.Xilinx.ClockGen Clash.Xilinx.DDR

hidden-modules:
    Clash.Class.AutoReg.Instances Clash.Clocks.Internal Clash.CPP
    Clash.Signal.Bundle.Internal Clash.Sized.Internal
    Language.Haskell.TH.Compat Paths_clash_prelude

import-dirs:          /usr/lib/ghc-9.6.6/site-local/clash-prelude-1.8.2
library-dirs:         /usr/lib/ghc-9.6.6/site-local/clash-prelude-1.8.2
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/clash-prelude-1.8.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-clash-prelude
hs-libraries:         HSclash-prelude-1.8.2-5KishcDrCxwDF51IuUYG14
depends:
    QuickCheck-2.15.0.1-LaRIQHiwv8U7w9VIoXbmQQ array-0.5.6.0
    arrows-0.4.4.2-QQ6OjwHnwbJCiA91zkYwd base-4.18.2.1 binary-0.8.9.1
    bytestring-0.11.5.3 constraints-0.14.2-4oXgIWlCgTD7y1AcVwITbb
    containers-0.6.7 data-binary-ieee754-0.4.4-4UW07Uhzyok6gyNDRTrrKK
    data-default-class-0.1.2.2-CDKXYK1wrFx3d5as0Pbjkc deepseq-1.4.8.1
    extra-1.7.16-8dGAsSrJDrL2Qv7CcA7Z6y ghc-bignum-1.3 ghc-prim-0.10.0
    ghc-typelits-extra-0.4.8-CtDWaBUQyO02dMYF5SREfC
    ghc-typelits-knownnat-0.7.12-9oan1iGGrGzC87GqjWKn1
    ghc-typelits-natnormalise-0.7.12-CYDhBaqN6ea6g35Bkj0Ij4
    half-0.3.3-4QCzYOXOYrh36480cTiYfP
    hashable-1.4.7.0-2TMrYujL0SWBJEdw6jCOMM
    infinite-list-0.1.3-JCaAZ04VcJ2qYX4tm7URK
    lens-5.3.3-J3Ejqn7P12hA3GpyJcCxW8 mtl-2.3.1
    recursion-schemes-5.2.3-4kumDhbq0w4CHkdeQ0fGIx
    reflection-2.1.9-DmwixYaWoIU9H8GRJKEAw4
    singletons-3.0.4-BBdD2FQs1xYFOGLWminZ1a
    string-interpolate-0.3.4.0-8K0m06mi14QJXSerq72zdb
    tagged-0.8.9-2fCpivRH6QIGdlOWfdc5ig template-haskell-2.20.0.0
    text-2.0.2 th-abstraction-0.5.0.0-HAFjiAO2nGN58SdxVZCnLH
    th-lift-0.8.6-IRGSsrKtWq3BZSHvMwfeE6
    th-orphans-0.13.16-Hmf6phI6E0E2Pkj3QsdH0F time-1.12.2
    transformers-0.6.1.0 type-errors-0.2.0.2-HnfEgP8jwoMA6CCm3xo6Sx
    uniplate-1.6.13-A8zwL5hEDFDZxij87DDBG
    vector-0.13.2.0-8Ien1418VpU5tGTMA2qRu7

haddock-interfaces:
    /usr/share/doc/haskell-clash-prelude/html/clash-prelude.haddock

haddock-html:         /usr/share/doc/haskell-clash-prelude/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

