#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 turtle
version:              1.6.2
visibility:           public
id:                   turtle-1.6.2-LmIryAE0Ms7146SWTowLIj
key:                  turtle-1.6.2-LmIryAE0Ms7146SWTowLIj
license:              BSD-3-Clause
copyright:            2015 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             Shell programming, Haskell-style
description:
    @turtle@ is a reimplementation of the Unix command line environment
    in Haskell so that you can use Haskell as both a shell and a scripting
    language.

    Features include:

    * Batteries included: Command an extended suite of predefined utilities

    * Interoperability: You can still run external shell commands

    * Portability: Works on Windows, OS X, and Linux

    * Exception safety: Safely acquire and release resources

    * Streaming: Transform or fold command output in constant space

    * Patterns: Use typed regular expressions that can parse structured values

    * Formatting: Type-safe @printf@-style text formatting

    * Modern: Supports @text@

    Read "Turtle.Tutorial" for a detailed tutorial or "Turtle.Prelude" for a
    quick-start guide

    @turtle@ is designed to be beginner-friendly, but as a result lacks certain
    features, like tracing commands.  If you feel comfortable using @turtle@
    then you should also check out the @Shelly@ library which provides similar
    functionality.

category:             System
abi:                  6d6c49ca5e7082b0bdd38d48f47a8ea3
exposed:              True
exposed-modules:
    Turtle Turtle.Bytes Turtle.Format Turtle.Line Turtle.Options
    Turtle.Pattern Turtle.Prelude Turtle.Shell Turtle.Tutorial

hidden-modules:       Turtle.Internal
import-dirs:          /usr/lib/ghc-9.6.6/site-local/turtle-1.6.2
library-dirs:         /usr/lib/ghc-9.6.6/site-local/turtle-1.6.2
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/turtle-1.6.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-turtle
hs-libraries:         HSturtle-1.6.2-LmIryAE0Ms7146SWTowLIj
depends:
    ansi-wl-pprint-1.0.2-95YnaC3fNbfLsNzVSxIj4T
    async-2.2.5-A7cw4gHfrNnBMjsgvHD8kq base-4.18.2.1
    bytestring-0.11.5.3 clock-0.8.4-1cUGuQXmqrCBQUn40x7fVi
    containers-0.6.7 directory-1.3.8.5 exceptions-0.10.7
    filepath-1.4.300.1 foldl-1.4.18-D33NgMGLNQu5LmaSDf1RNM
    hostname-1.0-EOhxbdAArOFEFh3i6bjNP6
    managed-1.0.10-3NCzxZ3vsssApqbea8Sbwa
    optional-args-1.0.2-F0xejbU8T85GOpMOmS9nLh
    optparse-applicative-0.18.1.0-3S7fKkQk1IxEovxwORLzkN
    process-1.6.19.0 stm-2.5.1.0
    streaming-commons-0.2.3.1-5B3GfFRukpC1TsahHGTkYo
    temporary-1.3-D64vl65CCuJL1VfIJwvdvy text-2.0.2 time-1.12.2
    transformers-0.6.1.0 unix-2.8.4.0
    unix-compat-0.7.4.1-HX6CmWtGzNSCIQWePfXCFw

haddock-interfaces:   /usr/share/doc/haskell-turtle/html/turtle.haddock
haddock-html:         /usr/share/doc/haskell-turtle/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

