/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping;

import java.util.function.BiConsumer;
import java.util.function.IntFunction;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.mapping.SelectableMapping;

@FunctionalInterface
public interface SelectableConsumer {
    public void accept(int var1, SelectableMapping var2);

    default public void accept(String tableName, JdbcMappingContainer base, String[] columnNames) {
        if (!1.$assertionsDisabled && base.getJdbcTypeCount() != columnNames.length) {
            throw new AssertionError();
        }
        MutableSelectableMapping mutableSelectableMapping = new MutableSelectableMapping(tableName, base, columnNames);
        mutableSelectableMapping.forEach(this::accept);
    }

    default public void accept(final String tableName, final String[] columnNames, final IntFunction<JdbcMapping> jdbcMappings) {
        class SelectableMappingIterator
        implements SelectableMapping {
            private int index;

            SelectableMappingIterator() {
            }

            @Override
            public String getContainingTableExpression() {
                return tableName;
            }

            @Override
            public String getSelectionExpression() {
                return columnNames[this.index];
            }

            @Override
            public String getCustomReadExpression() {
                return null;
            }

            @Override
            public String getCustomWriteExpression() {
                return null;
            }

            @Override
            public String getColumnDefinition() {
                return null;
            }

            @Override
            public Long getLength() {
                return null;
            }

            @Override
            public Integer getPrecision() {
                return null;
            }

            @Override
            public Integer getScale() {
                return null;
            }

            @Override
            public Integer getTemporalPrecision() {
                return null;
            }

            @Override
            public boolean isFormula() {
                return false;
            }

            @Override
            public boolean isNullable() {
                return true;
            }

            @Override
            public boolean isInsertable() {
                return true;
            }

            @Override
            public boolean isUpdateable() {
                return true;
            }

            @Override
            public boolean isPartitioned() {
                return false;
            }

            @Override
            public JdbcMapping getJdbcMapping() {
                return (JdbcMapping)jdbcMappings.apply(this.index);
            }
        }
        SelectableMappingIterator iterator = new SelectableMappingIterator();
        while (iterator.index < columnNames.length) {
            this.accept(iterator.index, iterator);
            ++iterator.index;
        }
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static class MutableSelectableMapping
    implements SelectableMapping {
        private final String tableName;
        private final JdbcMappingContainer base;
        private final String[] columnNames;
        private int index;

        public MutableSelectableMapping(String tableName, JdbcMappingContainer base, String[] columnNames) {
            this.tableName = tableName;
            this.base = base;
            this.columnNames = columnNames;
            assert (base.getJdbcTypeCount() == columnNames.length);
        }

        private void forEach(BiConsumer<Integer, SelectableMapping> consumer) {
            this.index = 0;
            while (this.index < this.columnNames.length) {
                consumer.accept(this.index, this);
                ++this.index;
            }
        }

        @Override
        public String getContainingTableExpression() {
            return this.tableName;
        }

        @Override
        public String getSelectionExpression() {
            return this.columnNames[this.index];
        }

        @Override
        public JdbcMapping getJdbcMapping() {
            return this.base.getJdbcMapping(this.index);
        }

        @Override
        public boolean isFormula() {
            return false;
        }

        @Override
        public boolean isNullable() {
            return false;
        }

        @Override
        public boolean isInsertable() {
            return true;
        }

        @Override
        public boolean isUpdateable() {
            return false;
        }

        @Override
        public boolean isPartitioned() {
            return false;
        }

        @Override
        public String getColumnDefinition() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long getLength() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getPrecision() {
            return null;
        }

        @Override
        public Integer getScale() {
            return null;
        }

        @Override
        public Integer getTemporalPrecision() {
            return null;
        }

        @Override
        public String getCustomReadExpression() {
            return null;
        }

        @Override
        public String getCustomWriteExpression() {
            return null;
        }
    }
}

