/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.expiration;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mediathek.gui.expiration.ExpiryInfo;
import mediathek.tool.datum.DateUtil;
import mediathek.tool.http.MVHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class ArteExpiryHelper {
    private static final ObjectMapper JSON = new ObjectMapper();
    private static final Logger LOG = LogManager.getLogger();
    private static final Pattern TEXT_DATE_PATTERN = Pattern.compile("(Verf\u00fcgbar bis zum|Available until|Disponible hasta el|Disponible jusqu'?au|Disponibile fino al|Dost\u0119pny do)\\s*(\\d{2}/\\d{2}/\\d{4})");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<ExpiryInfo> getExpiryInfo(String url) {
        Request request = new Request.Builder().url(url).get().header("User-Agent", "Mozilla/5.0").build();
        try {
            String bodyText;
            Matcher m;
            Iterator iterator;
            Document doc;
            block16: {
                Response response = MVHttpClient.getInstance().getHttpClient().newCall(request).execute();
                if (response.isSuccessful()) {
                    doc = Jsoup.parse(response.body().string());
                    Elements scripts = doc.select("script[type=application/ld+json]");
                    iterator = scripts.iterator();
                    break block16;
                } else {
                    LOG.error("Could not fetch expiry data from {}", (Object)url);
                    return Optional.empty();
                }
                finally {
                    if (response != null) {
                        response.close();
                    }
                }
            }
            while (iterator.hasNext()) {
                Element script = (Element)iterator.next();
                JsonNode root = JSON.readTree(script.html());
                Optional<ExpiryInfo> info = ArteExpiryHelper.searchRecursiveForDate(root);
                if (!info.isPresent()) continue;
                Optional<ExpiryInfo> optional = info;
                return optional;
            }
            Element video = doc.selectFirst("video[data-configuration], video[data-href]");
            if (video != null) {
                JsonNode root2;
                JsonNode avail;
                String cfgUrl;
                String string = cfgUrl = video.hasAttr("data-configuration") ? video.attr("data-configuration") : video.attr("data-href");
                if (!(cfgUrl.isBlank() || (avail = (root2 = JSON.readTree(Jsoup.connect(cfgUrl).ignoreContentType(true).execute().body())).path("availability").path("availabilityEnds")).isMissingNode() || avail.asText().isBlank())) {
                    Instant expiry = Instant.parse(avail.asText());
                    Optional<ExpiryInfo> optional = Optional.of(ArteExpiryHelper.buildInfo(expiry));
                    return optional;
                }
            }
            if (!(m = TEXT_DATE_PATTERN.matcher(bodyText = doc.body().text())).find()) return Optional.empty();
            String rawDate = m.group(2);
            LocalDate date = LocalDate.parse(rawDate, DateTimeFormatter.ofPattern("dd/MM/yyyy"));
            ZonedDateTime z = date.atTime(23, 59).atZone(ZoneId.of("Europe/Paris"));
            Instant expiry = z.toInstant();
            Optional<ExpiryInfo> optional = Optional.of(ArteExpiryHelper.buildInfo(expiry));
            return optional;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Optional.empty();
    }

    private static Optional<ExpiryInfo> searchRecursiveForDate(JsonNode node) {
        String text;
        if (node == null) {
            return Optional.empty();
        }
        if (node.has("availabilityEnds") && !(text = node.get("availabilityEnds").asText()).isBlank()) {
            return Optional.of(ArteExpiryHelper.buildInfo(Instant.parse(text)));
        }
        if (node.has("expires") && !(text = node.get("expires").asText()).isBlank()) {
            return Optional.of(ArteExpiryHelper.buildInfo(Instant.parse(text)));
        }
        for (JsonNode child : node) {
            Optional<ExpiryInfo> found = ArteExpiryHelper.searchRecursiveForDate(child);
            if (!found.isPresent()) continue;
            return found;
        }
        return Optional.empty();
    }

    private static ExpiryInfo buildInfo(Instant expiry) {
        return new ExpiryInfo(LocalDate.ofInstant(expiry, DateUtil.MV_DEFAULT_TIMEZONE));
    }
}

