/*
 * Decompiled with CFR 0.152.
 */
package com.github.kokorin.jaffree.ffmpeg;

import com.github.kokorin.jaffree.ffmpeg.BaseInput;
import com.github.kokorin.jaffree.ffmpeg.Input;
import com.github.kokorin.jaffree.net.NegotiatingTcpServer;
import com.github.kokorin.jaffree.net.TcpNegotiator;
import com.github.kokorin.jaffree.net.TcpServer;
import com.github.kokorin.jaffree.process.ProcessHelper;

public abstract class TcpInput<T extends TcpInput<T>>
extends BaseInput<T>
implements Input {
    private final TcpServer tcpServer;

    public TcpInput(TcpNegotiator tcpNegotiator) {
        this("tcp", tcpNegotiator);
    }

    public TcpInput(String protocol, TcpNegotiator tcpNegotiator) {
        this(protocol, "", tcpNegotiator);
    }

    public TcpInput(String protocol, String suffix, TcpNegotiator tcpNegotiator) {
        this(protocol, suffix, NegotiatingTcpServer.onRandomPort(tcpNegotiator));
    }

    protected TcpInput(String protocol, String suffix, TcpServer tcpServer) {
        super(protocol + "://" + tcpServer.getAddressAndPort() + suffix);
        this.tcpServer = tcpServer;
    }

    @Override
    public final ProcessHelper helperThread() {
        return this.tcpServer;
    }
}

