/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.calendar;

import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jdesktop.swingx.calendar.AbstractDateSelectionModel;
import org.jdesktop.swingx.calendar.DateSelectionModel;
import org.jdesktop.swingx.event.DateSelectionEvent;
import org.jdesktop.swingx.event.EventListenerMap;
import org.jdesktop.swingx.util.Contract;

public class DaySelectionModel
extends AbstractDateSelectionModel {
    private DateSelectionModel.SelectionMode selectionMode;
    private SortedSet<Date> selectedDates;
    private SortedSet<Date> unselectableDates;

    public DaySelectionModel() {
        this(null);
    }

    public DaySelectionModel(Locale locale) {
        super(locale);
        this.listenerMap = new EventListenerMap();
        this.selectionMode = DateSelectionModel.SelectionMode.SINGLE_SELECTION;
        this.selectedDates = new TreeSet<Date>();
        this.unselectableDates = new TreeSet<Date>();
    }

    @Override
    public DateSelectionModel.SelectionMode getSelectionMode() {
        return this.selectionMode;
    }

    @Override
    public void setSelectionMode(DateSelectionModel.SelectionMode selectionMode) {
        this.selectionMode = selectionMode;
        this.clearSelection();
    }

    @Override
    public void addSelectionInterval(Date startDate, Date endDate) {
        if (startDate.after(endDate)) {
            return;
        }
        startDate = this.startOfDay(startDate);
        endDate = this.startOfDay(endDate);
        boolean added = false;
        switch (this.selectionMode) {
            case SINGLE_SELECTION: {
                if (this.isSelected(startDate)) {
                    return;
                }
                this.clearSelectionImpl();
                added = this.addSelectionImpl(startDate, startDate);
                break;
            }
            case SINGLE_INTERVAL_SELECTION: {
                if (this.isIntervalSelected(startDate, endDate)) {
                    return;
                }
                this.clearSelectionImpl();
                added = this.addSelectionImpl(startDate, endDate);
                break;
            }
            case MULTIPLE_INTERVAL_SELECTION: {
                if (this.isIntervalSelected(startDate, endDate)) {
                    return;
                }
                added = this.addSelectionImpl(startDate, endDate);
                break;
            }
        }
        if (added) {
            this.fireValueChanged(DateSelectionEvent.EventType.DATES_ADDED);
        }
    }

    @Override
    public void setSelectionInterval(Date startDate, Date endDate) {
        startDate = this.startOfDay(startDate);
        endDate = this.startOfDay(endDate);
        if (DateSelectionModel.SelectionMode.SINGLE_SELECTION.equals((Object)this.selectionMode)) {
            if (this.isSelected(startDate)) {
                return;
            }
            endDate = startDate;
        } else if (this.isIntervalSelected(startDate, endDate)) {
            return;
        }
        this.clearSelectionImpl();
        if (this.addSelectionImpl(startDate, endDate)) {
            this.fireValueChanged(DateSelectionEvent.EventType.DATES_SET);
        }
    }

    private boolean isIntervalSelected(Date startDate, Date endDate) {
        if (this.isSelectionEmpty()) {
            return false;
        }
        startDate = this.startOfDay(startDate);
        endDate = this.startOfDay(endDate);
        return this.selectedDates.first().equals(startDate) && this.selectedDates.last().equals(endDate);
    }

    @Override
    public void removeSelectionInterval(Date startDate, Date endDate) {
        if (startDate.after(endDate)) {
            return;
        }
        startDate = this.startOfDay(startDate);
        endDate = this.startOfDay(endDate);
        long startDateMs = startDate.getTime();
        long endDateMs = endDate.getTime();
        ArrayList<Date> datesToRemove = new ArrayList<Date>();
        for (Date selectedDate : this.selectedDates) {
            long selectedDateMs = selectedDate.getTime();
            if (selectedDateMs < startDateMs || selectedDateMs > endDateMs) continue;
            datesToRemove.add(selectedDate);
        }
        if (!datesToRemove.isEmpty()) {
            this.selectedDates.removeAll(datesToRemove);
            this.fireValueChanged(DateSelectionEvent.EventType.DATES_REMOVED);
        }
    }

    @Override
    public void clearSelection() {
        if (this.isSelectionEmpty()) {
            return;
        }
        this.clearSelectionImpl();
        this.fireValueChanged(DateSelectionEvent.EventType.SELECTION_CLEARED);
    }

    private void clearSelectionImpl() {
        this.selectedDates.clear();
    }

    @Override
    public SortedSet<Date> getSelection() {
        return new TreeSet<Date>(this.selectedDates);
    }

    @Override
    public Date getFirstSelectionDate() {
        return this.isSelectionEmpty() ? null : this.selectedDates.first();
    }

    @Override
    public Date getLastSelectionDate() {
        return this.isSelectionEmpty() ? null : this.selectedDates.last();
    }

    @Override
    public boolean isSelected(Date date) {
        return this.selectedDates.contains(this.startOfDay(date));
    }

    @Override
    public boolean isSelectionEmpty() {
        return this.selectedDates.isEmpty();
    }

    @Override
    public SortedSet<Date> getUnselectableDates() {
        return new TreeSet<Date>(this.unselectableDates);
    }

    @Override
    public void setUnselectableDates(SortedSet<Date> unselectables) {
        this.unselectableDates.clear();
        for (Date date : unselectables) {
            this.unselectableDates.add(this.startOfDay(date));
        }
        for (Date unselectableDate : this.unselectableDates) {
            this.removeSelectionInterval(unselectableDate, unselectableDate);
        }
        this.fireValueChanged(DateSelectionEvent.EventType.UNSELECTED_DATES_CHANGED);
    }

    @Override
    public boolean isUnselectableDate(Date date) {
        date = this.startOfDay(date);
        return this.upperBound != null && this.upperBound.getTime() < date.getTime() || this.lowerBound != null && this.lowerBound.getTime() > date.getTime() || this.unselectableDates != null && this.unselectableDates.contains(date);
    }

    private boolean addSelectionImpl(Date startDate, Date endDate) {
        boolean hasAdded = false;
        this.calendar.setTime(startDate);
        Date date = this.calendar.getTime();
        while (date.before(endDate) || date.equals(endDate)) {
            if (!this.isUnselectableDate(date)) {
                hasAdded = true;
                this.selectedDates.add(date);
            }
            this.calendar.add(5, 1);
            date = this.calendar.getTime();
        }
        return hasAdded;
    }

    @Override
    public Date getNormalizedDate(Date date) {
        Contract.asNotNull(date, "date must not be null");
        return this.startOfDay(date);
    }
}

