/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.compare;

import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.parameters.RequestBody;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import org.openapitools.openapidiff.core.compare.OpenApiDiff;
import org.openapitools.openapidiff.core.compare.ReferenceDiffCache;
import org.openapitools.openapidiff.core.model.ChangedRequestBody;
import org.openapitools.openapidiff.core.model.DiffContext;
import org.openapitools.openapidiff.core.model.deferred.DeferredBuilder;
import org.openapitools.openapidiff.core.model.deferred.DeferredChanged;
import org.openapitools.openapidiff.core.utils.RefPointer;
import org.openapitools.openapidiff.core.utils.RefType;

public class RequestBodyDiff
extends ReferenceDiffCache<RequestBody, ChangedRequestBody> {
    private static final RefPointer<RequestBody> refPointer = new RefPointer(RefType.REQUEST_BODIES);
    private final OpenApiDiff openApiDiff;

    public RequestBodyDiff(OpenApiDiff openApiDiff) {
        this.openApiDiff = openApiDiff;
    }

    private static Map<String, Object> getExtensions(RequestBody body) {
        return Optional.ofNullable(body).map(RequestBody::getExtensions).orElse(null);
    }

    public DeferredChanged<ChangedRequestBody> diff(RequestBody left, RequestBody right, DiffContext context) {
        String leftRef = left != null ? left.get$ref() : null;
        String rightRef = right != null ? right.get$ref() : null;
        return this.cachedDiff(new HashSet<String>(), left, right, leftRef, rightRef, context);
    }

    @Override
    protected DeferredChanged<ChangedRequestBody> computeDiff(HashSet<String> refSet, RequestBody left, RequestBody right, DiffContext context) {
        DeferredBuilder builder = new DeferredBuilder();
        Content oldRequestContent = new Content();
        Content newRequestContent = new Content();
        RequestBody oldRequestBody = null;
        RequestBody newRequestBody = null;
        if (left != null && (oldRequestBody = refPointer.resolveRef(this.openApiDiff.getOldSpecOpenApi().getComponents(), left, left.get$ref())).getContent() != null) {
            oldRequestContent = oldRequestBody.getContent();
        }
        if (right != null && (newRequestBody = refPointer.resolveRef(this.openApiDiff.getNewSpecOpenApi().getComponents(), right, right.get$ref())).getContent() != null) {
            newRequestContent = newRequestBody.getContent();
        }
        boolean leftRequired = oldRequestBody != null && Boolean.TRUE.equals(oldRequestBody.getRequired());
        boolean rightRequired = newRequestBody != null && Boolean.TRUE.equals(newRequestBody.getRequired());
        ChangedRequestBody changedRequestBody = new ChangedRequestBody(oldRequestBody, newRequestBody, context).setChangeRequired(leftRequired != rightRequired);
        builder.with(this.openApiDiff.getMetadataDiff().diff(oldRequestBody != null ? oldRequestBody.getDescription() : null, newRequestBody != null ? newRequestBody.getDescription() : null, context)).ifPresent(changedRequestBody::setDescription);
        builder.with(this.openApiDiff.getContentDiff().diff(oldRequestContent, newRequestContent, context)).ifPresent(changedRequestBody::setContent);
        builder.with(this.openApiDiff.getExtensionsDiff().diff(RequestBodyDiff.getExtensions(left), RequestBodyDiff.getExtensions(right), context)).ifPresent(changedRequestBody::setExtensions);
        return builder.buildIsChanged(changedRequestBody);
    }
}

