/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CapacityBlock;
import software.amazon.awssdk.services.ec2.model.CapacityBlockSetCopier;
import software.amazon.awssdk.services.ec2.model.CapacityReservation;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PurchaseCapacityBlockResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, PurchaseCapacityBlockResponse> {
    private static final SdkField<CapacityReservation> CAPACITY_RESERVATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CapacityReservation").getter(PurchaseCapacityBlockResponse.getter(PurchaseCapacityBlockResponse::capacityReservation)).setter(PurchaseCapacityBlockResponse.setter(Builder::capacityReservation)).constructor(CapacityReservation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservation").unmarshallLocationName("capacityReservation").build()}).build();
    private static final SdkField<List<CapacityBlock>> CAPACITY_BLOCKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CapacityBlocks").getter(PurchaseCapacityBlockResponse.getter(PurchaseCapacityBlockResponse::capacityBlocks)).setter(PurchaseCapacityBlockResponse.setter(Builder::capacityBlocks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityBlockSet").unmarshallLocationName("capacityBlockSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CapacityBlock::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_RESERVATION_FIELD, CAPACITY_BLOCKS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PurchaseCapacityBlockResponse.memberNameToFieldInitializer();
    private final CapacityReservation capacityReservation;
    private final List<CapacityBlock> capacityBlocks;

    private PurchaseCapacityBlockResponse(BuilderImpl builder) {
        super(builder);
        this.capacityReservation = builder.capacityReservation;
        this.capacityBlocks = builder.capacityBlocks;
    }

    public final CapacityReservation capacityReservation() {
        return this.capacityReservation;
    }

    public final boolean hasCapacityBlocks() {
        return this.capacityBlocks != null && !(this.capacityBlocks instanceof SdkAutoConstructList);
    }

    public final List<CapacityBlock> capacityBlocks() {
        return this.capacityBlocks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityReservation());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapacityBlocks() ? this.capacityBlocks() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseCapacityBlockResponse)) {
            return false;
        }
        PurchaseCapacityBlockResponse other = (PurchaseCapacityBlockResponse)((Object)obj);
        return Objects.equals(this.capacityReservation(), other.capacityReservation()) && this.hasCapacityBlocks() == other.hasCapacityBlocks() && Objects.equals(this.capacityBlocks(), other.capacityBlocks());
    }

    public final String toString() {
        return ToString.builder((String)"PurchaseCapacityBlockResponse").add("CapacityReservation", (Object)this.capacityReservation()).add("CapacityBlocks", this.hasCapacityBlocks() ? this.capacityBlocks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CapacityReservation": {
                return Optional.ofNullable(clazz.cast(this.capacityReservation()));
            }
            case "CapacityBlocks": {
                return Optional.ofNullable(clazz.cast(this.capacityBlocks()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CapacityReservation", CAPACITY_RESERVATION_FIELD);
        map.put("CapacityBlockSet", CAPACITY_BLOCKS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PurchaseCapacityBlockResponse, T> g) {
        return obj -> g.apply((PurchaseCapacityBlockResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private CapacityReservation capacityReservation;
        private List<CapacityBlock> capacityBlocks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseCapacityBlockResponse model) {
            super(model);
            this.capacityReservation(model.capacityReservation);
            this.capacityBlocks(model.capacityBlocks);
        }

        public final CapacityReservation.Builder getCapacityReservation() {
            return this.capacityReservation != null ? this.capacityReservation.toBuilder() : null;
        }

        public final void setCapacityReservation(CapacityReservation.BuilderImpl capacityReservation) {
            this.capacityReservation = capacityReservation != null ? capacityReservation.build() : null;
        }

        @Override
        public final Builder capacityReservation(CapacityReservation capacityReservation) {
            this.capacityReservation = capacityReservation;
            return this;
        }

        public final List<CapacityBlock.Builder> getCapacityBlocks() {
            List<CapacityBlock.Builder> result = CapacityBlockSetCopier.copyToBuilder(this.capacityBlocks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCapacityBlocks(Collection<CapacityBlock.BuilderImpl> capacityBlocks) {
            this.capacityBlocks = CapacityBlockSetCopier.copyFromBuilder(capacityBlocks);
        }

        @Override
        public final Builder capacityBlocks(Collection<CapacityBlock> capacityBlocks) {
            this.capacityBlocks = CapacityBlockSetCopier.copy(capacityBlocks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityBlocks(CapacityBlock ... capacityBlocks) {
            this.capacityBlocks(Arrays.asList(capacityBlocks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityBlocks(Consumer<CapacityBlock.Builder> ... capacityBlocks) {
            this.capacityBlocks(Stream.of(capacityBlocks).map(c -> (CapacityBlock)((CapacityBlock.Builder)CapacityBlock.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public PurchaseCapacityBlockResponse build() {
            return new PurchaseCapacityBlockResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PurchaseCapacityBlockResponse> {
        public Builder capacityReservation(CapacityReservation var1);

        default public Builder capacityReservation(Consumer<CapacityReservation.Builder> capacityReservation) {
            return this.capacityReservation((CapacityReservation)((CapacityReservation.Builder)CapacityReservation.builder().applyMutation(capacityReservation)).build());
        }

        public Builder capacityBlocks(Collection<CapacityBlock> var1);

        public Builder capacityBlocks(CapacityBlock ... var1);

        public Builder capacityBlocks(Consumer<CapacityBlock.Builder> ... var1);
    }
}

