/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.rowset.FilteredRowSet;
import javax.sql.rowset.Predicate;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.rowset.OracleWebRowSet;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.ROWSET})
public class OracleFilteredRowSet
extends OracleWebRowSet
implements FilteredRowSet {
    private Predicate predicate;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;

    public OracleFilteredRowSet() throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, OracleFilteredRowSet.class, $$$methodRef$$$6, null, new Object[0]);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, OracleFilteredRowSet.class, $$$methodRef$$$6, null);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleFilteredRowSet.class, $$$methodRef$$$6, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleFilteredRowSet.class, $$$methodRef$$$6, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setFilter(Predicate predicate) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void p2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleFilteredRowSet.class, $$$methodRef$$$0, this, predicate);
            }
            this.predicate = p2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleFilteredRowSet.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleFilteredRowSet.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleFilteredRowSet.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Predicate getFilter() {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleFilteredRowSet.class, $$$methodRef$$$1, this, new Object[0]);
            }
            Predicate predicate = this.predicate;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleFilteredRowSet.class, $$$methodRef$$$1, this, predicate);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleFilteredRowSet.class, $$$methodRef$$$1, this, null);
            }
            return predicate;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleFilteredRowSet.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean next() throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OracleFilteredRowSet.class, $$$methodRef$$$2, this, new Object[0]);
            }
            if (bl) {
                this.debug($$$loggerRef$$$2, Level.FINEST, $$$methodRef$$$2, "OracleFilteredRowSet.next(), rowCount=" + this.rowCount + ", fetchDirection=" + this.fetchDirection + ", presentRow=" + this.presentRow);
            }
            if (this.rowCount <= 0) {
                boolean bl2 = false;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleFilteredRowSet.class, $$$methodRef$$$2, this, bl2);
                    ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleFilteredRowSet.class, $$$methodRef$$$2, this, null);
                }
                return false;
            }
            if (this.presentRow >= this.rowCount) {
                boolean bl3 = false;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleFilteredRowSet.class, $$$methodRef$$$2, this, bl3);
                    ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleFilteredRowSet.class, $$$methodRef$$$2, this, null);
                }
                return false;
            }
            boolean isPresentRowQualified = false;
            do {
                ++this.presentRow;
                if (this.predicate != null && (this.predicate == null || !this.predicate.evaluate(this))) continue;
                isPresentRowQualified = true;
                break;
            } while (this.presentRow <= this.rowCount);
            if (isPresentRowQualified) {
                this.notifyCursorMoved();
                boolean bl4 = true;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleFilteredRowSet.class, $$$methodRef$$$2, this, bl4);
                    ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleFilteredRowSet.class, $$$methodRef$$$2, this, null);
                }
                return true;
            }
            boolean bl5 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleFilteredRowSet.class, $$$methodRef$$$2, this, bl5);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleFilteredRowSet.class, $$$methodRef$$$2, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleFilteredRowSet.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean previous() throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, OracleFilteredRowSet.class, $$$methodRef$$$3, this, new Object[0]);
            }
            if (bl) {
                this.debug($$$loggerRef$$$3, Level.FINEST, $$$methodRef$$$3, "OracleFilteredRowSet.previous(), rowCount=" + this.rowCount + ", fetchDirection=" + this.fetchDirection + ", presentRow=" + this.presentRow);
            }
            if (this.rowsetType == 1003) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(344).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, OracleFilteredRowSet.class, $$$methodRef$$$3, this, sQLException);
                }
                throw sQLException;
            }
            if (this.rowCount <= 0) {
                boolean bl2 = false;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleFilteredRowSet.class, $$$methodRef$$$3, this, bl2);
                    ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleFilteredRowSet.class, $$$methodRef$$$3, this, null);
                }
                return false;
            }
            if (this.presentRow <= 1) {
                boolean bl3 = false;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleFilteredRowSet.class, $$$methodRef$$$3, this, bl3);
                    ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleFilteredRowSet.class, $$$methodRef$$$3, this, null);
                }
                return false;
            }
            boolean isPresentRowQualified = false;
            do {
                --this.presentRow;
                if (this.predicate != null && (this.predicate == null || !this.predicate.evaluate(this))) continue;
                isPresentRowQualified = true;
                break;
            } while (this.presentRow >= 1);
            if (isPresentRowQualified) {
                this.notifyCursorMoved();
                boolean bl4 = true;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleFilteredRowSet.class, $$$methodRef$$$3, this, bl4);
                    ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleFilteredRowSet.class, $$$methodRef$$$3, this, null);
                }
                return true;
            }
            boolean bl5 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleFilteredRowSet.class, $$$methodRef$$$3, this, bl5);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleFilteredRowSet.class, $$$methodRef$$$3, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleFilteredRowSet.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean absolute(int n2) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            int num;
            void row;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, OracleFilteredRowSet.class, $$$methodRef$$$4, this, n2);
            }
            if (bl) {
                this.debug($$$loggerRef$$$4, Level.FINEST, $$$methodRef$$$4, "OracleFilteredRowSet.absolute(" + (int)row + "), rowsetType=" + this.rowsetType + ", presentRow=" + this.presentRow);
            }
            if (this.rowsetType == 1003) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(344).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, OracleFilteredRowSet.class, $$$methodRef$$$4, this, sQLException);
                }
                throw sQLException;
            }
            if (row == false || Math.abs((int)row) > this.rowCount) {
                boolean bl2 = false;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleFilteredRowSet.class, $$$methodRef$$$4, this, bl2);
                    ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleFilteredRowSet.class, $$$methodRef$$$4, this, null);
                }
                return false;
            }
            int positiveRow = row < 0 ? this.rowCount + row + 1 : row;
            this.presentRow = 0;
            for (num = 0; num < positiveRow && this.presentRow <= this.rowCount; ++num) {
                if (this.next()) {
                    continue;
                }
                boolean bl3 = false;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleFilteredRowSet.class, $$$methodRef$$$4, this, bl3);
                    ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleFilteredRowSet.class, $$$methodRef$$$4, this, null);
                }
                return false;
            }
            if (num == positiveRow) {
                this.notifyCursorMoved();
                boolean bl4 = true;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleFilteredRowSet.class, $$$methodRef$$$4, this, bl4);
                    ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleFilteredRowSet.class, $$$methodRef$$$4, this, null);
                }
                return true;
            }
            boolean bl5 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleFilteredRowSet.class, $$$methodRef$$$4, this, bl5);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleFilteredRowSet.class, $$$methodRef$$$4, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleFilteredRowSet.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void checkAndFilterObject(int n2, Object object) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void columnIndex;
            void obj;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, OracleFilteredRowSet.class, $$$methodRef$$$5, this, n2, object);
            }
            if (this.predicate != null && !this.predicate.evaluate((Object)obj, (int)columnIndex)) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(345).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, OracleFilteredRowSet.class, $$$methodRef$$$5, this, sQLException);
                }
                throw sQLException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleFilteredRowSet.class, $$$methodRef$$$5, this);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleFilteredRowSet.class, $$$methodRef$$$5, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleFilteredRowSet.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Log
    protected void debug(Logger logger, Level level, Executable method, String msg) {
        ClioSupport.log(logger, level, this.getClass(), method, msg);
    }

    static {
        try {
            $$$methodRef$$$6 = OracleFilteredRowSet.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleFilteredRowSet.class.getDeclaredMethod("checkAndFilterObject", Integer.TYPE, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleFilteredRowSet.class.getDeclaredMethod("absolute", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleFilteredRowSet.class.getDeclaredMethod("previous", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleFilteredRowSet.class.getDeclaredMethod("next", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleFilteredRowSet.class.getDeclaredMethod("getFilter", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleFilteredRowSet.class.getDeclaredMethod("setFilter", Predicate.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

