/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.flavor.oracledb;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.regex.AbstractConstantKeysObject;
import com.oracle.truffle.regex.RegexSource;
import com.oracle.truffle.regex.RegexSyntaxException;
import com.oracle.truffle.regex.util.TruffleReadOnlyKeysArray;

@ExportLibrary(value=InteropLibrary.class)
public final class OracleDBFlags
extends AbstractConstantKeysObject {
    private static final String PROP_IGNORE_CASE = "i";
    private static final String PROP_FORCE_ACCENT_AND_CASE_SENSITIVE = "c";
    private static final String PROP_DOTALL = "n";
    private static final String PROP_MULTILINE = "m";
    private static final String PROP_VERBOSE = "x";
    private static final TruffleReadOnlyKeysArray KEYS = new TruffleReadOnlyKeysArray("i", "c", "n", "m", "x");
    private final int value;
    private static final int FLAG_IGNORE_CASE = 1;
    private static final int FLAG_FORCE_ACCENT_AND_CASE_SENSITIVE = 2;
    private static final int FLAG_DOT_ALL = 4;
    private static final int FLAG_MULTILINE = 8;
    private static final int FLAG_IGNORE_WHITESPACE = 16;
    private static final char[] ALL_FLAGS = new char[]{'i', 'c', 'n', 'm', 'x'};
    public static final OracleDBFlags EMPTY_INSTANCE = new OracleDBFlags(0);

    private OracleDBFlags(int value) {
        this.value = value;
    }

    public static OracleDBFlags parseFlags(RegexSource source) throws RegexSyntaxException {
        String flagsStr = source.getFlags();
        int flags = 0;
        block7: for (int i = 0; i < flagsStr.length(); ++i) {
            char ch = flagsStr.charAt(i);
            switch (ch) {
                case 'i': {
                    flags |= 1;
                    flags &= 0xFFFFFFFD;
                    continue block7;
                }
                case 'c': {
                    flags |= 2;
                    flags &= 0xFFFFFFFE;
                    continue block7;
                }
                case 'n': {
                    flags |= 4;
                    continue block7;
                }
                case 'm': {
                    flags |= 8;
                    continue block7;
                }
                case 'x': {
                    flags |= 0x10;
                    continue block7;
                }
                default: {
                    throw RegexSyntaxException.createFlags(source, "Unsupported match_param flag", i);
                }
            }
        }
        return flags == 0 ? EMPTY_INSTANCE : new OracleDBFlags(flags);
    }

    private boolean hasFlag(int flag) {
        return (this.value & flag) != 0;
    }

    public boolean isIgnoreCase() {
        return this.hasFlag(1);
    }

    public boolean isForceAccentAndCaseSensitive() {
        return this.hasFlag(2);
    }

    public boolean isDotAll() {
        return this.hasFlag(4);
    }

    public boolean isMultiline() {
        return this.hasFlag(8);
    }

    public boolean isIgnoreWhitespace() {
        return this.hasFlag(16);
    }

    public boolean equals(Object other) {
        return other instanceof OracleDBFlags && this.value == ((OracleDBFlags)other).value;
    }

    public int hashCode() {
        return this.value;
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        char[] out = new char[Integer.bitCount(this.value)];
        int iOut = 0;
        for (int i = 0; i < ALL_FLAGS.length; ++i) {
            if (!this.hasFlag(1 << i)) continue;
            out[iOut++] = ALL_FLAGS[i];
        }
        return new String(out);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    public Object toDisplayString(boolean allowSideEffects) {
        return "TRegexOracleDBFlags{flags=" + String.valueOf(this) + "}";
    }

    @Override
    public TruffleReadOnlyKeysArray getKeys() {
        return KEYS;
    }

    @Override
    public boolean isMemberReadableImpl(String symbol) {
        switch (symbol) {
            case "i": 
            case "c": 
            case "n": 
            case "m": 
            case "x": {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object readMemberImpl(String symbol) throws UnknownIdentifierException {
        switch (symbol) {
            case "i": {
                return this.isIgnoreCase();
            }
            case "c": {
                return this.isForceAccentAndCaseSensitive();
            }
            case "n": {
                return this.isDotAll();
            }
            case "m": {
                return this.isMultiline();
            }
            case "x": {
                return this.isIgnoreWhitespace();
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw UnknownIdentifierException.create((String)symbol);
    }
}

