/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.repository.jar;

import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.ivy.plugins.repository.Resource;

public class JarResource
implements Resource {
    private final JarFile jarFile;
    private final String path;
    private ZipEntry entry;

    public JarResource(JarFile jarFile, String path) {
        this.jarFile = jarFile;
        this.path = path;
        this.entry = jarFile.getEntry(path);
    }

    @Override
    public String getName() {
        return this.path;
    }

    @Override
    public long getLastModified() {
        return this.entry.getTime();
    }

    @Override
    public long getContentLength() {
        return this.entry.getSize();
    }

    @Override
    public boolean exists() {
        return this.entry != null;
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public Resource clone(String cloneName) {
        return new JarResource(this.jarFile, cloneName);
    }

    @Override
    public InputStream openStream() throws IOException {
        return this.jarFile.getInputStream(this.entry);
    }

    public String toString() {
        return this.jarFile.getName() + "!" + this.getName();
    }
}

