/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.code;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.modules.MarshalModuleBuiltins;
import com.oracle.graal.python.builtins.objects.code.CodeNodesFactory;
import com.oracle.graal.python.builtins.objects.code.PCode;
import com.oracle.graal.python.builtins.objects.function.PFunction;
import com.oracle.graal.python.builtins.objects.function.Signature;
import com.oracle.graal.python.compiler.BytecodeCodeUnit;
import com.oracle.graal.python.compiler.CodeUnit;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRootNode;
import com.oracle.graal.python.nodes.bytecode.PBytecodeGeneratorFunctionRootNode;
import com.oracle.graal.python.nodes.bytecode.PBytecodeRootNode;
import com.oracle.graal.python.nodes.bytecode_dsl.BytecodeDSLCodeUnit;
import com.oracle.graal.python.nodes.bytecode_dsl.PBytecodeDSLGeneratorFunctionRootNode;
import com.oracle.graal.python.nodes.bytecode_dsl.PBytecodeDSLRootNode;
import com.oracle.graal.python.nodes.util.BadOPCodeNode;
import com.oracle.graal.python.runtime.ExecutionContext;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.graal.python.util.Supplier;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.Arrays;
import org.graalvm.polyglot.io.ByteSequence;

public abstract class CodeNodes {

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class GetCodeRootNode
    extends Node {
        public abstract RootNode execute(Node var1, PCode var2);

        public static RootNode executeUncached(PCode code) {
            return CodeNodesFactory.GetCodeRootNodeGen.getUncached().execute(null, code);
        }

        @Specialization
        static RootNode doIt(Node inliningTarget, PCode code, @Cached GetCodeCallTargetNode getCodeCallTargetNode) {
            return getCodeCallTargetNode.execute(inliningTarget, code).getRootNode();
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class GetCodeSignatureNode
    extends PNodeWithContext {
        public abstract Signature execute(Node var1, PCode var2);

        @Specialization(guards={"cachedCode == code", "isSingleContext(inliningTarget)"}, limit="2")
        static Signature doCached(Node inliningTarget, PCode code, @Cached(value="code") PCode cachedCode) {
            return GetCodeSignatureNode.getInSingleContextMode(inliningTarget, cachedCode);
        }

        public static Signature getInSingleContextMode(Node inliningTarget, PFunction fun) {
            assert (GetCodeSignatureNode.isSingleContext(inliningTarget));
            CompilerAsserts.partialEvaluationConstant((Object)fun);
            if (CompilerDirectives.inCompiledCode()) {
                return GetCodeSignatureNode.getInSingleContextMode(inliningTarget, fun.getCode());
            }
            PCode code = fun.getCode();
            return code.getSignature();
        }

        public static Signature getInSingleContextMode(Node inliningTarget, PCode code) {
            assert (GetCodeSignatureNode.isSingleContext(inliningTarget));
            CompilerAsserts.partialEvaluationConstant((Object)code);
            return code.getSignature();
        }

        @Specialization(replaces={"doCached"})
        static Signature doCode(PCode code) {
            return code.getSignature();
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class GetCodeCallTargetNode
    extends PNodeWithContext {
        public abstract RootCallTarget execute(Node var1, PCode var2);

        @Specialization(guards={"cachedCode == code", "isSingleContext()"}, limit="2")
        static RootCallTarget doCachedCode(PCode code, @Cached(value="code", weak=true) PCode cachedCode) {
            return cachedCode.getRootCallTarget();
        }

        @Specialization(replaces={"doCachedCode"})
        static RootCallTarget doGeneric(PCode code) {
            return code.getRootCallTarget();
        }
    }

    public static class CreateCodeNode
    extends PNodeWithContext {
        private final IndirectCallData indirectCallData = IndirectCallData.createFor(this);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PCode execute(VirtualFrame frame, int argcount, int posonlyargcount, int kwonlyargcount, int nlocals, int stacksize, int flags, byte[] codedata, Object[] constants, TruffleString[] names, TruffleString[] varnames, TruffleString[] freevars, TruffleString[] cellvars, TruffleString filename, TruffleString name, TruffleString qualname, int firstlineno, byte[] linetable) {
            PythonContext context = PythonContext.get(this);
            PythonLanguage language = context.getLanguage(this);
            Object state = ExecutionContext.IndirectCallContext.enter(frame, language, context, this.indirectCallData);
            try {
                PCode pCode = CreateCodeNode.createCode(language, context, argcount, posonlyargcount, kwonlyargcount, nlocals, stacksize, flags, codedata, constants, names, varnames, freevars, cellvars, filename, name, qualname, firstlineno, linetable);
                return pCode;
            }
            finally {
                ExecutionContext.IndirectCallContext.exit(frame, language, context, state);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static PCode createCode(PythonLanguage language, PythonContext context, int argCount, int positionalOnlyArgCount, int kwOnlyArgCount, int nlocals, int stacksize, int flags, byte[] codedata, Object[] constants, TruffleString[] names, TruffleString[] varnames, TruffleString[] freevars, TruffleString[] cellvars, TruffleString filename, TruffleString name, TruffleString qualname, int firstlineno, byte[] linetable) {
            Signature signature;
            RootCallTarget ct;
            if (codedata.length == 0) {
                TruffleString[] kwOnlyNames;
                TruffleString[] parameterNames;
                ct = language.createCachedCallTarget(l -> new BadOPCodeNode((TruffleLanguage<?>)l, name), BadOPCodeNode.class, name.toJavaStringUncached());
                int posArgCount = argCount + positionalOnlyArgCount;
                if (varnames != null) {
                    parameterNames = Arrays.copyOf(varnames, posArgCount);
                    kwOnlyNames = Arrays.copyOfRange(varnames, posArgCount, posArgCount + kwOnlyArgCount);
                } else {
                    kwOnlyNames = PythonUtils.EMPTY_TRUFFLESTRING_ARRAY;
                    parameterNames = PythonUtils.EMPTY_TRUFFLESTRING_ARRAY;
                }
                int varArgsIndex = (flags & 4) != 0 ? posArgCount : -1;
                signature = new Signature(positionalOnlyArgCount, (flags & 8) != 0, varArgsIndex, parameterNames, kwOnlyNames);
            } else {
                ct = CreateCodeNode.create().deserializeForBytecodeInterpreter(language, context, codedata, cellvars, freevars);
                signature = ((PRootNode)ct.getRootNode()).getSignature();
            }
            if (filename != null) {
                context.setCodeFilename((CallTarget)ct, filename);
            }
            return PFactory.createCode(language, ct, signature, nlocals, stacksize, flags, constants, names, varnames, freevars, cellvars, filename, name, qualname, firstlineno, linetable);
        }

        private RootCallTarget deserializeForBytecodeInterpreter(PythonLanguage language, PythonContext context, byte[] data, TruffleString[] cellvars, TruffleString[] freevars) {
            CodeUnit codeUnit = MarshalModuleBuiltins.deserializeCodeUnit(null, context, data);
            PRootNode rootNode = null;
            if (PythonOptions.ENABLE_BYTECODE_DSL_INTERPRETER) {
                BytecodeDSLCodeUnit code = (BytecodeDSLCodeUnit)codeUnit;
                rootNode = code.createRootNode(context, PythonUtils.createFakeSource());
                if (code.isGeneratorOrCoroutine()) {
                    rootNode = new PBytecodeDSLGeneratorFunctionRootNode(language, rootNode.getFrameDescriptor(), (PBytecodeDSLRootNode)rootNode, code.name);
                }
            } else {
                BytecodeCodeUnit code = (BytecodeCodeUnit)codeUnit;
                if (cellvars != null && !Arrays.equals(code.cellvars, cellvars) || freevars != null && !Arrays.equals(code.freevars, freevars)) {
                    code = new BytecodeCodeUnit(code.name, code.qualname, code.argCount, code.kwOnlyArgCount, code.positionalOnlyArgCount, code.flags, code.names, code.varnames, cellvars != null ? cellvars : code.cellvars, freevars != null ? freevars : code.freevars, code.cell2arg, code.constants, code.startLine, code.startColumn, code.endLine, code.endColumn, code.code, code.srcOffsetTable, code.primitiveConstants, code.exceptionHandlerRanges, code.stacksize, code.conditionProfileCount, code.outputCanQuicken, code.variableShouldUnbox, code.generalizeInputsMap, code.generalizeVarsMap);
                }
                rootNode = PBytecodeRootNode.create(context.getLanguage(), code, PythonUtils.createFakeSource());
                if (code.isGeneratorOrCoroutine()) {
                    rootNode = new PBytecodeGeneratorFunctionRootNode(context.getLanguage(), rootNode.getFrameDescriptor(), (PBytecodeRootNode)rootNode, code.name);
                }
            }
            return PythonUtils.getOrCreateCallTarget(rootNode);
        }

        @CompilerDirectives.TruffleBoundary
        public static PCode createCode(PythonContext context, int flags, byte[] codedata, TruffleString filename, int firstlineno, byte[] lnotab) {
            boolean isNotAModule = (flags & 0x1000) == 0;
            String jFilename = filename.toJavaStringUncached();
            PythonLanguage language = context.getLanguage();
            Supplier createCode = () -> {
                ByteSequence bytes = ByteSequence.create((byte[])codedata);
                Source source = Source.newBuilder((String)"python", (ByteSequence)bytes, (String)jFilename).mimeType("application/x-python-bytecode").cached(!language.isSingleContext()).build();
                return context.getEnv().parsePublic(source, new String[0]);
            };
            if (context.isCoreInitialized() || isNotAModule) {
                return PFactory.createCode(language, (RootCallTarget)createCode.get(), flags, firstlineno, lnotab, filename);
            }
            RootCallTarget ct = (RootCallTarget)language.cacheCode(filename, createCode);
            return PFactory.createCode(language, ct, flags, firstlineno, lnotab, filename);
        }

        @NeverDefault
        public static CreateCodeNode create() {
            return new CreateCodeNode();
        }
    }
}

