/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.type.slots;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.capi.ExternalFunctionNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTiming;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.BuiltinSlotWrapperSignature;
import com.oracle.graal.python.builtins.objects.type.slots.NodeFactoryUtils;
import com.oracle.graal.python.builtins.objects.type.slots.PythonDispatchers;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlot;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotDescrSetFactory;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.attributes.LookupAttributeInMRONode;
import com.oracle.graal.python.nodes.call.CallDispatchers;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.utilities.TruffleWeakReference;

public abstract class TpSlotDescrSet {
    private TpSlotDescrSet() {
    }

    public static boolean PyDescr_IsData(TpSlots descrSlots) {
        return descrSlots.tp_descr_set() != null;
    }

    private static PException raiseAttributeError(Node inliningTarget, PRaiseNode raiseNode, TruffleString attrName) {
        return raiseNode.raise(inliningTarget, PythonBuiltinClassType.AttributeError, attrName);
    }

    @GenerateInline(inlineByDefault=true)
    @GenerateCached
    @GenerateUncached
    @ImportStatic(value={PGuards.class})
    public static abstract class CallSlotDescrSet
    extends Node {
        @NeverDefault
        public static CallSlotDescrSet create() {
            return TpSlotDescrSetFactory.CallSlotDescrSetNodeGen.create();
        }

        public abstract void execute(VirtualFrame var1, Node var2, TpSlot var3, Object var4, Object var5, Object var6);

        public final void executeCached(VirtualFrame frame, TpSlot slot, Object self, Object obj, Object value) {
            this.execute(frame, this, slot, self, obj, value);
        }

        @Specialization(guards={"cachedSlot == slot"}, limit="3")
        static void callCachedBuiltin(VirtualFrame frame, TpSlotDescrSetBuiltin slot, Object self, Object obj, Object value, @Cached(value="slot") TpSlotDescrSetBuiltin cachedSlot, @Cached(value="cachedSlot.createSlotNode()") DescrSetBuiltinNode slotNode) {
            slotNode.executeVoid(frame, self, obj, value);
        }

        @Specialization(guards={"!isNoValue(value)"})
        static void callPythonSet(VirtualFrame frame, Node inliningTarget, TpSlotDescrSetPython slot, Object self, Object obj, Object value, @Cached PythonDispatchers.TernaryPythonSlotDispatcherNode dispatcherNode, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            Object callable = slot.getSetCallable();
            if (callable == null) {
                throw TpSlotDescrSet.raiseAttributeError(inliningTarget, raiseNode, SpecialMethodNames.T___SET__);
            }
            dispatcherNode.execute(frame, inliningTarget, callable, slot.getType(), self, obj, value);
        }

        @Specialization(guards={"isNoValue(value)"})
        @HostCompilerDirectives.InliningCutoff
        static void callPythonDel(VirtualFrame frame, Node inliningTarget, TpSlotDescrSetPython slot, Object self, Object obj, Object value, @Cached PythonDispatchers.BinaryPythonSlotDispatcherNode dispatcherNode, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            Object callable = slot.getDelCallable();
            if (callable == null) {
                throw TpSlotDescrSet.raiseAttributeError(inliningTarget, raiseNode, SpecialMethodNames.T___DEL__);
            }
            dispatcherNode.execute(frame, inliningTarget, callable, slot.getType(), self, obj);
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        static void callNative(VirtualFrame frame, Node inliningTarget, TpSlot.TpSlotNative slot, Object self, Object obj, Object value, @Cached CallNativeSlotDescrSet callNativeSlot) {
            callNativeSlot.execute(frame, inliningTarget, slot, self, obj, value);
        }

        @Specialization(replaces={"callCachedBuiltin"})
        @HostCompilerDirectives.InliningCutoff
        static void callGenericBuiltin(VirtualFrame frame, Node inliningTarget, TpSlotDescrSetBuiltin slot, Object self, Object obj, Object value, @Cached CallDispatchers.SimpleIndirectInvokeNode invoke) {
            Object[] arguments = PArguments.create(3);
            PArguments.setArgument(arguments, 0, self);
            PArguments.setArgument(arguments, 1, obj);
            PArguments.setArgument(arguments, 2, value);
            RootCallTarget callTarget = PythonLanguage.get(inliningTarget).getBuiltinSlotCallTarget(slot.callTargetIndex);
            invoke.execute((Frame)frame, inliningTarget, callTarget, arguments);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    static abstract class CallNativeSlotDescrSet
    extends Node {
        private static final CApiTiming C_API_TIMING = CApiTiming.create(true, "tp_descr_set");

        CallNativeSlotDescrSet() {
        }

        public abstract void execute(VirtualFrame var1, Node var2, TpSlot var3, Object var4, Object var5, Object var6);

        @Specialization
        static void callNative(VirtualFrame frame, Node inliningTarget, TpSlot.TpSlotNative slot, Object self, Object obj, Object value, @Cached PythonContext.GetThreadStateNode getThreadStateNode, @Cached(inline=false) CApiTransitions.PythonToNativeNode selfToNativeNode, @Cached(inline=false) CApiTransitions.PythonToNativeNode objToNativeNode, @Cached(inline=false) CApiTransitions.PythonToNativeNode valueToNativeNode, @Cached ExternalFunctionNodes.ExternalFunctionInvokeNode externalInvokeNode, @Cached(inline=false) ExternalFunctionNodes.InitCheckFunctionResultNode checkResultNode) {
            PythonContext ctx = PythonContext.get(inliningTarget);
            PythonContext.PythonThreadState threadState = getThreadStateNode.execute(inliningTarget, ctx);
            Object result = externalInvokeNode.call(frame, inliningTarget, threadState, C_API_TIMING, SpecialMethodNames.T___SET__, slot.callable, selfToNativeNode.execute(self), objToNativeNode.execute(obj), valueToNativeNode.execute(value));
            checkResultNode.execute(threadState, SpecialMethodNames.T___SET__, result);
        }
    }

    @GenerateInline(value=false, inherit=true)
    public static abstract class DescrSetBuiltinNode
    extends PythonTernaryBuiltinNode {
        public abstract void executeVoid(VirtualFrame var1, Object var2, Object var3, Object var4);

        @Override
        public final Object execute(VirtualFrame frame, Object arg, Object arg2, Object arg3) {
            this.executeVoid(frame, arg, arg2, arg3);
            return PNone.NONE;
        }
    }

    public static final class TpSlotDescrSetPython
    extends TpSlot.TpSlotPython {
        private final TruffleWeakReference<Object> setCallable;
        private final TruffleWeakReference<Object> delCallable;
        private final TruffleWeakReference<Object> type;

        public TpSlotDescrSetPython(Object setCallable, Object delCallable, Object type) {
            this.setCallable = TpSlotDescrSetPython.asWeakRef(setCallable);
            this.delCallable = TpSlotDescrSetPython.asWeakRef(delCallable);
            this.type = new TruffleWeakReference(type);
        }

        public static TpSlotDescrSetPython create(Object[] callables, TruffleString[] callableNames, Object klass) {
            assert (callables.length == 2);
            assert (callableNames == null || callableNames[0].equals((Object)SpecialMethodNames.T___SET__) && callableNames[1].equals((Object)SpecialMethodNames.T___DELETE__));
            return new TpSlotDescrSetPython(callables[0], callables[1], klass);
        }

        @Override
        public TpSlot.TpSlotPython forNewType(Object klass) {
            Object set = LookupAttributeInMRONode.Dynamic.getUncached().execute(klass, SpecialMethodNames.T___SET__);
            Object delete = LookupAttributeInMRONode.Dynamic.getUncached().execute(klass, SpecialMethodNames.T___DELETE__);
            if (set != this.getSetCallable() || delete != this.getDelCallable()) {
                return new TpSlotDescrSetPython(set, delete, this.getType());
            }
            return this;
        }

        public Object getSetCallable() {
            return this.safeGet(this.setCallable);
        }

        public Object getDelCallable() {
            return this.safeGet(this.delCallable);
        }

        public Object getType() {
            return this.safeGet(this.type);
        }
    }

    public static abstract class TpSlotDescrSetBuiltin<T extends DescrSetBuiltinNode>
    extends TpSlot.TpSlotBuiltin<T> {
        private static final BuiltinSlotWrapperSignature SET_SIGNATURE = BuiltinSlotWrapperSignature.of(BuiltinSlotWrapperSignature.J_DOLLAR_SELF, "object", "value");
        private static final BuiltinSlotWrapperSignature GET_SIGNATURE = BuiltinSlotWrapperSignature.of(BuiltinSlotWrapperSignature.J_DOLLAR_SELF, "object");
        private final int callTargetIndex = TpSlot.TpSlotBuiltinCallTargetRegistry.getNextCallTargetIndex();

        protected TpSlotDescrSetBuiltin(NodeFactory<T> nodeFactory) {
            super(nodeFactory);
        }

        final DescrSetBuiltinNode createSlotNode() {
            return (DescrSetBuiltinNode)((Object)this.createNode());
        }

        @Override
        public void initialize(PythonLanguage language) {
            RootCallTarget target = TpSlotDescrSetBuiltin.createSlotCallTarget(language, SET_SIGNATURE, this.getNodeFactory(), "__set__");
            language.setBuiltinSlotCallTarget(this.callTargetIndex, target);
        }

        @Override
        public PBuiltinFunction createBuiltin(Python3Core core, Object type, TruffleString tsName, ExternalFunctionNodes.PExternalFunctionWrapper wrapper) {
            return switch (wrapper) {
                case ExternalFunctionNodes.PExternalFunctionWrapper.DESCR_SET -> this.createBuiltin(core, type, tsName, SET_SIGNATURE, ExternalFunctionNodes.PExternalFunctionWrapper.DESCR_SET, this.getNodeFactory());
                case ExternalFunctionNodes.PExternalFunctionWrapper.DESCR_DELETE -> this.createBuiltin(core, type, tsName, GET_SIGNATURE, ExternalFunctionNodes.PExternalFunctionWrapper.DESCR_DELETE, NodeFactoryUtils.BinaryToTernaryBuiltinNode.wrapFactory(this.getNodeFactory()));
                default -> null;
            };
        }
    }
}

