/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.AbstractManager;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.appender.OutputStreamManager;
import org.apache.logging.log4j.core.util.Closer;
import org.apache.logging.log4j.core.util.FileUtils;
import org.apache.logging.log4j.core.util.NullOutputStream;
import org.apache.logging.log4j.core.util.internal.UnsafeUtil;
import org.apache.logging.log4j.util.Constants;

public class MemoryMappedFileManager
extends OutputStreamManager {
    static final int DEFAULT_REGION_LENGTH = 0x2000000;
    private static final int MAX_REMAP_COUNT = 10;
    private static final MemoryMappedFileManagerFactory FACTORY = new MemoryMappedFileManagerFactory();
    private static final double NANOS_PER_MILLISEC = 1000000.0;
    private final boolean immediateFlush;
    private final int regionLength;
    private final String advertiseURI;
    private final RandomAccessFile randomAccessFile;
    private MappedByteBuffer mappedBuffer;
    private long mappingOffset;

    protected MemoryMappedFileManager(RandomAccessFile file, String fileName, OutputStream os, boolean immediateFlush, long position, int regionLength, String advertiseURI, Layout<? extends Serializable> layout, boolean writeHeader) throws IOException {
        super(os, fileName, layout, writeHeader, ByteBuffer.wrap(Constants.EMPTY_BYTE_ARRAY));
        this.immediateFlush = immediateFlush;
        this.randomAccessFile = Objects.requireNonNull(file, "RandomAccessFile");
        this.regionLength = regionLength;
        this.advertiseURI = advertiseURI;
        this.mappedBuffer = MemoryMappedFileManager.mmap(this.randomAccessFile.getChannel(), this.getFileName(), position, regionLength);
        this.byteBuffer = this.mappedBuffer;
        this.mappingOffset = position;
    }

    public static MemoryMappedFileManager getFileManager(String fileName, boolean append, boolean immediateFlush, int regionLength, String advertiseURI, Layout<? extends Serializable> layout) {
        return MemoryMappedFileManager.narrow(MemoryMappedFileManager.class, MemoryMappedFileManager.getManager(fileName, new FactoryData(append, immediateFlush, regionLength, advertiseURI, layout), FACTORY));
    }

    @Deprecated
    public Boolean isEndOfBatch() {
        return Boolean.FALSE;
    }

    @Deprecated
    public void setEndOfBatch(boolean endOfBatch) {
    }

    @Override
    protected synchronized void write(byte[] bytes, int offset, int length, boolean immediateFlush) {
        int currentLength;
        int chunk;
        int currentOffset = offset;
        for (currentLength = length; currentLength > this.mappedBuffer.remaining(); currentLength -= chunk) {
            chunk = this.mappedBuffer.remaining();
            this.mappedBuffer.put(bytes, currentOffset, chunk);
            currentOffset += chunk;
            this.remap();
        }
        this.mappedBuffer.put(bytes, currentOffset, currentLength);
    }

    private synchronized void remap() {
        long offset = this.mappingOffset + (long)this.mappedBuffer.position();
        int length = this.mappedBuffer.remaining() + this.regionLength;
        try {
            MemoryMappedFileManager.unsafeUnmap(this.mappedBuffer);
            long fileLength = this.randomAccessFile.length() + (long)this.regionLength;
            LOGGER.debug("{} {} extending {} by {} bytes to {}", (Object)this.getClass().getSimpleName(), (Object)this.getName(), (Object)this.getFileName(), (Object)this.regionLength, (Object)fileLength);
            long startNanos = System.nanoTime();
            this.randomAccessFile.setLength(fileLength);
            float millis = (float)((double)(System.nanoTime() - startNanos) / 1000000.0);
            LOGGER.debug("{} {} extended {} OK in {} millis", (Object)this.getClass().getSimpleName(), (Object)this.getName(), (Object)this.getFileName(), (Object)Float.valueOf(millis));
            this.mappedBuffer = MemoryMappedFileManager.mmap(this.randomAccessFile.getChannel(), this.getFileName(), offset, length);
            this.byteBuffer = this.mappedBuffer;
            this.mappingOffset = offset;
        }
        catch (Exception ex) {
            this.logError("Unable to remap", ex);
        }
    }

    @Override
    public synchronized void flush() {
        this.mappedBuffer.force();
    }

    @Override
    public synchronized boolean closeOutputStream() {
        long position = this.mappedBuffer.position();
        long length = this.mappingOffset + position;
        try {
            MemoryMappedFileManager.unsafeUnmap(this.mappedBuffer);
        }
        catch (Exception ex) {
            this.logError("Unable to unmap MappedBuffer", ex);
        }
        try {
            LOGGER.debug("MMapAppender closing. Setting {} length to {} (offset {} + position {})", (Object)this.getFileName(), (Object)length, (Object)this.mappingOffset, (Object)position);
            this.randomAccessFile.setLength(length);
            this.randomAccessFile.close();
            return true;
        }
        catch (IOException ex) {
            this.logError("Unable to close MemoryMappedFile", ex);
            return false;
        }
    }

    public static MappedByteBuffer mmap(FileChannel fileChannel, String fileName, long start, int size2) throws IOException {
        int i = 1;
        while (true) {
            try {
                LOGGER.debug("MMapAppender remapping {} start={}, size={}", (Object)fileName, (Object)start, (Object)size2);
                long startNanos = System.nanoTime();
                MappedByteBuffer map2 = fileChannel.map(FileChannel.MapMode.READ_WRITE, start, size2);
                map2.order(ByteOrder.nativeOrder());
                float millis = (float)((double)(System.nanoTime() - startNanos) / 1000000.0);
                LOGGER.debug("MMapAppender remapped {} OK in {} millis", (Object)fileName, (Object)Float.valueOf(millis));
                return map2;
            }
            catch (IOException e) {
                if (e.getMessage() == null || !e.getMessage().endsWith("user-mapped section open")) {
                    throw e;
                }
                LOGGER.debug("Remap attempt {}/{} failed. Retrying...", (Object)i, (Object)10, (Object)e);
                if (i < 10) {
                    Thread.yield();
                } else {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException ignored) {
                        Thread.currentThread().interrupt();
                        throw e;
                    }
                }
                ++i;
                continue;
            }
            break;
        }
    }

    private static void unsafeUnmap(MappedByteBuffer mbb) throws Exception {
        LOGGER.debug("MMapAppender unmapping old buffer...");
        long startNanos = System.nanoTime();
        UnsafeUtil.clean(mbb);
        float millis = (float)((double)(System.nanoTime() - startNanos) / 1000000.0);
        LOGGER.debug("MMapAppender unmapped buffer OK in {} millis", (Object)Float.valueOf(millis));
    }

    public String getFileName() {
        return this.getName();
    }

    public int getRegionLength() {
        return this.regionLength;
    }

    public boolean isImmediateFlush() {
        return this.immediateFlush;
    }

    @Override
    public Map<String, String> getContentFormat() {
        HashMap<String, String> result2 = new HashMap<String, String>(super.getContentFormat());
        result2.put("fileURI", this.advertiseURI);
        return result2;
    }

    @Override
    protected void flushBuffer(ByteBuffer buffer) {
    }

    @Override
    public ByteBuffer getByteBuffer() {
        return this.mappedBuffer;
    }

    @Override
    public ByteBuffer drain(ByteBuffer buf) {
        this.remap();
        return this.mappedBuffer;
    }

    private static class FactoryData {
        private final boolean append;
        private final boolean immediateFlush;
        private final int regionLength;
        private final String advertiseURI;
        private final Layout<? extends Serializable> layout;

        public FactoryData(boolean append, boolean immediateFlush, int regionLength, String advertiseURI, Layout<? extends Serializable> layout) {
            this.append = append;
            this.immediateFlush = immediateFlush;
            this.regionLength = regionLength;
            this.advertiseURI = advertiseURI;
            this.layout = layout;
        }
    }

    private static class MemoryMappedFileManagerFactory
    implements ManagerFactory<MemoryMappedFileManager, FactoryData> {
        private MemoryMappedFileManagerFactory() {
        }

        @Override
        @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="The destination file should be specified in the configuration file.")
        public MemoryMappedFileManager createManager(String name, FactoryData data2) {
            File file = new File(name);
            if (!data2.append) {
                file.delete();
            }
            boolean writeHeader = !data2.append || !file.exists();
            NullOutputStream os = NullOutputStream.getInstance();
            RandomAccessFile raf2 = null;
            try {
                FileUtils.makeParentDirs(file);
                raf2 = new RandomAccessFile(name, "rw");
                long position = data2.append ? raf2.length() : 0L;
                raf2.setLength(position + (long)data2.regionLength);
                return new MemoryMappedFileManager(raf2, name, os, data2.immediateFlush, position, data2.regionLength, data2.advertiseURI, data2.layout, writeHeader);
            }
            catch (Exception ex) {
                AbstractManager.LOGGER.error("MemoryMappedFileManager (" + name + ") " + ex, (Throwable)ex);
                Closer.closeSilently(raf2);
                return null;
            }
        }
    }
}

