/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.binding.impl;

import java.net.URI;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.common.binding.BindingException;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.saml2.ecp.Response;
import org.opensaml.soap.messaging.SOAPMessagingSupport;
import org.opensaml.soap.util.SOAPSupport;
import org.slf4j.Logger;

public class AddECPResponseHeaderHandler
extends AbstractMessageHandler {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AddECPResponseHeaderHandler.class);
    @NonnullBeforeExec
    private URI assertionConsumerURL;

    @Override
    protected boolean doPreInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        if (!super.doPreInvoke(messageContext)) {
            return false;
        }
        try {
            this.assertionConsumerURL = SAMLBindingSupport.getEndpointURL(messageContext);
        }
        catch (BindingException e) {
            this.log.debug("{} No ACS location available in message context", (Object)this.getLogPrefix());
            return false;
        }
        return true;
    }

    @Override
    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        SAMLObjectBuilder responseBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(Response.DEFAULT_ELEMENT_NAME);
        Response header = (Response)responseBuilder.buildObject();
        header.setAssertionConsumerServiceURL(this.assertionConsumerURL.toString());
        SOAPSupport.addSOAP11MustUnderstandAttribute(header, true);
        SOAPSupport.addSOAP11ActorAttribute(header, "http://schemas.xmlsoap.org/soap/actor/next");
        try {
            SOAPMessagingSupport.addHeaderBlock(messageContext, header);
        }
        catch (Exception e) {
            throw new MessageHandlerException(e);
        }
    }
}

