/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.policyeditor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import net.sourceforge.jnlp.runtime.Translator;
import sun.security.provider.PolicyParser;

public class PolicyIdentifier
implements Comparable<PolicyIdentifier>,
Serializable {
    public static final PolicyIdentifier ALL_APPLETS_IDENTIFIER = new PolicyIdentifier(null, (Collection)Collections.emptySet(), null){

        @Override
        public String toString() {
            return Translator.R("PEGlobalSettings");
        }
    };
    private final String signedBy;
    private final LinkedHashSet<PolicyParser.PrincipalEntry> principals = new LinkedHashSet();
    private final String codebase;

    public PolicyIdentifier(String signedBy, Collection<PolicyParser.PrincipalEntry> principals, String codebase) {
        this.signedBy = signedBy != null && signedBy.isEmpty() ? null : signedBy;
        this.principals.addAll(principals);
        this.codebase = codebase == null ? "" : codebase;
    }

    public String getSignedBy() {
        return this.signedBy;
    }

    public Set<PolicyParser.PrincipalEntry> getPrincipals() {
        return this.principals;
    }

    public String getCodebase() {
        return this.codebase;
    }

    public static boolean isDefaultPolicyIdentifier(PolicyIdentifier policyIdentifier) {
        return policyIdentifier.getSignedBy() == null && policyIdentifier.getPrincipals().isEmpty() && policyIdentifier.getCodebase().isEmpty();
    }

    public String toString() {
        String newline = "<br>";
        ArrayList<String> props = new ArrayList<String>();
        if (!this.codebase.isEmpty()) {
            props.add("codebase=" + this.codebase);
            props.add("<br>");
        }
        if (!this.principals.isEmpty()) {
            props.add("principals=" + this.principals);
            props.add("<br>");
        }
        if (this.signedBy != null && !this.signedBy.isEmpty()) {
            props.add("signedBy=" + this.signedBy);
            props.add("<br>");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        if (!props.isEmpty()) {
            for (String prop : props.subList(0, props.size() - 1)) {
                sb.append(prop);
            }
        }
        sb.append("</html>");
        return sb.toString();
    }

    public String toStringNoHtml() {
        return "codebase='" + this.codebase + '\'' + " principals=" + this.principals + " signedBy='" + this.signedBy + '\'';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PolicyIdentifier)) {
            return false;
        }
        PolicyIdentifier that = (PolicyIdentifier)o;
        if (this.signedBy != null ? !this.signedBy.equals(that.signedBy) : that.signedBy != null) {
            return false;
        }
        if (!this.principals.equals(that.principals)) {
            return false;
        }
        return this.codebase.equals(that.codebase);
    }

    public int hashCode() {
        int result = this.signedBy != null ? this.signedBy.hashCode() : 0;
        result = 31 * result + (this.principals != null ? this.principals.hashCode() : 0);
        result = 31 * result + this.codebase.hashCode();
        return result;
    }

    @Override
    public int compareTo(PolicyIdentifier policyIdentifier) {
        if (this.equals(ALL_APPLETS_IDENTIFIER) && policyIdentifier.equals(ALL_APPLETS_IDENTIFIER)) {
            return 0;
        }
        if (this.equals(ALL_APPLETS_IDENTIFIER) && !policyIdentifier.equals(ALL_APPLETS_IDENTIFIER)) {
            return -1;
        }
        if (!this.equals(ALL_APPLETS_IDENTIFIER) && policyIdentifier.equals(ALL_APPLETS_IDENTIFIER)) {
            return 1;
        }
        int codebaseComparison = PolicyIdentifier.compareComparable(this.getCodebase(), policyIdentifier.getCodebase());
        if (codebaseComparison != 0) {
            return codebaseComparison;
        }
        int signedByComparison = PolicyIdentifier.compareComparable(this.getSignedBy(), policyIdentifier.getSignedBy());
        if (signedByComparison != 0) {
            return signedByComparison;
        }
        return Integer.compare(this.getPrincipals().hashCode(), policyIdentifier.getPrincipals().hashCode());
    }

    private static <T extends Comparable<T>> int compareComparable(T a, T b) {
        if (a == null && b != null) {
            return 1;
        }
        if (a != null && b == null) {
            return -1;
        }
        if (a == b) {
            return 0;
        }
        return a.compareTo(b);
    }
}

