/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index;

import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;

public final class ShardIndexingPressureSettings {
    public static final String SHARD_INDEXING_PRESSURE_ENABLED_ATTRIBUTE_KEY = "shard_indexing_pressure_enabled";
    public static final Setting<Boolean> SHARD_INDEXING_PRESSURE_ENABLED = Setting.boolSetting("shard_indexing_pressure.enabled", false, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Boolean> SHARD_INDEXING_PRESSURE_ENFORCED = Setting.boolSetting("shard_indexing_pressure.enforced", false, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Integer> REQUEST_SIZE_WINDOW = Setting.intSetting("shard_indexing_pressure.secondary_parameter.throughput.request_size_window", 2000, Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final Setting<Double> SHARD_MIN_LIMIT = Setting.doubleSetting("shard_indexing_pressure.primary_parameter.shard.min_limit", 0.001, 0.0, Setting.Property.NodeScope, Setting.Property.Dynamic);
    private volatile boolean shardIndexingPressureEnabled;
    private volatile boolean shardIndexingPressureEnforced;
    private volatile long shardPrimaryAndCoordinatingBaseLimits;
    private volatile long shardReplicaBaseLimits;
    private volatile int requestSizeWindow;
    private volatile double shardMinLimit;
    private final long primaryAndCoordinatingNodeLimits;

    public ShardIndexingPressureSettings(ClusterService clusterService, Settings settings, long primaryAndCoordinatingLimits) {
        ClusterSettings clusterSettings = clusterService.getClusterSettings();
        this.shardIndexingPressureEnabled = SHARD_INDEXING_PRESSURE_ENABLED.get(settings);
        clusterSettings.addSettingsUpdateConsumer(SHARD_INDEXING_PRESSURE_ENABLED, this::setShardIndexingPressureEnabled);
        this.shardIndexingPressureEnforced = SHARD_INDEXING_PRESSURE_ENFORCED.get(settings);
        clusterSettings.addSettingsUpdateConsumer(SHARD_INDEXING_PRESSURE_ENFORCED, this::setShardIndexingPressureEnforced);
        this.requestSizeWindow = REQUEST_SIZE_WINDOW.get(settings);
        clusterSettings.addSettingsUpdateConsumer(REQUEST_SIZE_WINDOW, this::setRequestSizeWindow);
        this.primaryAndCoordinatingNodeLimits = primaryAndCoordinatingLimits;
        this.shardMinLimit = SHARD_MIN_LIMIT.get(settings).floatValue();
        this.shardPrimaryAndCoordinatingBaseLimits = (long)((double)primaryAndCoordinatingLimits * this.shardMinLimit);
        this.shardReplicaBaseLimits = (long)((double)this.shardPrimaryAndCoordinatingBaseLimits * 1.5);
        clusterSettings.addSettingsUpdateConsumer(SHARD_MIN_LIMIT, this::setShardMinLimit);
    }

    private void setShardIndexingPressureEnabled(Boolean shardIndexingPressureEnableValue) {
        this.shardIndexingPressureEnabled = shardIndexingPressureEnableValue;
    }

    private void setShardIndexingPressureEnforced(Boolean shardIndexingPressureEnforcedValue) {
        this.shardIndexingPressureEnforced = shardIndexingPressureEnforcedValue;
    }

    private void setRequestSizeWindow(int requestSizeWindow) {
        this.requestSizeWindow = requestSizeWindow;
    }

    private void setShardMinLimit(double shardMinLimit) {
        this.shardMinLimit = shardMinLimit;
        this.setShardPrimaryAndCoordinatingBaseLimits();
        this.setShardReplicaBaseLimits();
    }

    private void setShardPrimaryAndCoordinatingBaseLimits() {
        this.shardPrimaryAndCoordinatingBaseLimits = (long)((double)this.primaryAndCoordinatingNodeLimits * this.shardMinLimit);
    }

    private void setShardReplicaBaseLimits() {
        this.shardReplicaBaseLimits = (long)((double)this.shardPrimaryAndCoordinatingBaseLimits * 1.5);
    }

    public boolean isShardIndexingPressureEnabled() {
        return this.shardIndexingPressureEnabled;
    }

    public boolean isShardIndexingPressureEnforced() {
        return this.shardIndexingPressureEnforced;
    }

    public int getRequestSizeWindow() {
        return this.requestSizeWindow;
    }

    public long getShardPrimaryAndCoordinatingBaseLimits() {
        return this.shardPrimaryAndCoordinatingBaseLimits;
    }

    public long getShardReplicaBaseLimits() {
        return this.shardReplicaBaseLimits;
    }

    public long getNodePrimaryAndCoordinatingLimits() {
        return this.primaryAndCoordinatingNodeLimits;
    }

    public long getNodeReplicaLimits() {
        return (long)((double)this.primaryAndCoordinatingNodeLimits * 1.5);
    }
}

