/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.search.collector;

import java.io.IOException;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.Query;
import org.opensearch.common.lucene.search.TopDocsAndMaxScore;
import org.opensearch.neuralsearch.search.collector.HybridSearchCollector;
import org.opensearch.neuralsearch.search.query.HybridCollectorManager;
import org.opensearch.neuralsearch.search.query.HybridCollectorResultsUtilParams;
import org.opensearch.neuralsearch.search.query.util.HybridSearchCollectorResultUtil;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.search.query.QueryCollectorContextSpec;
import org.opensearch.search.query.QuerySearchResult;
import org.opensearch.search.query.ReduceableSearchResult;

public class HybridQueryCollectorContextSpec
implements QueryCollectorContextSpec {
    @Generated
    private static final Logger log = LogManager.getLogger(HybridQueryCollectorContextSpec.class);
    private final HybridCollectorManager collectorManager;
    private final HybridSearchCollector collector;
    private final SearchContext searchContext;

    public HybridQueryCollectorContextSpec(SearchContext searchContext, Query query) {
        this.searchContext = searchContext;
        this.collectorManager = (HybridCollectorManager)HybridCollectorManager.createHybridCollectorManager(searchContext, query);
        this.collector = (HybridSearchCollector)this.collectorManager.newCollector();
    }

    public String getContextName() {
        return "search_top_hits";
    }

    public Collector create(Collector in) throws IOException {
        return this.collector;
    }

    public CollectorManager<?, ReduceableSearchResult> createManager(CollectorManager<?, ReduceableSearchResult> in) {
        return this.collectorManager;
    }

    public void postProcess(QuerySearchResult result) throws IOException {
        HybridSearchCollectorResultUtil hybridSearchCollectorResultUtil = new HybridSearchCollectorResultUtil(new HybridCollectorResultsUtilParams.Builder().searchContext(this.searchContext).build(), this.collector);
        TopDocsAndMaxScore topDocsAndMaxScore = hybridSearchCollectorResultUtil.getTopDocsAndMaxScore();
        hybridSearchCollectorResultUtil.reduceCollectorResults(result, topDocsAndMaxScore);
    }
}

