/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive;

import java.util.ArrayList;
import java.util.Arrays;
import org.ldaptive.ConnectionFactoryMetadata;
import org.ldaptive.ConnectionStrategy;

public class RoundRobinConnectionStrategy
implements ConnectionStrategy {
    private int invocationCount;
    private final boolean useConnectionCount;

    public RoundRobinConnectionStrategy() {
        this(true);
    }

    public RoundRobinConnectionStrategy(boolean b) {
        this.useConnectionCount = b;
    }

    @Override
    public String[] getLdapUrls(ConnectionFactoryMetadata metadata) {
        if (metadata == null || metadata.getLdapUrl() == null) {
            return null;
        }
        ArrayList<String> l = new ArrayList<String>(Arrays.asList(metadata.getLdapUrl().split(" ")));
        int count = this.getCount(metadata.getConnectionCount());
        for (int i = 0; i < count % l.size(); ++i) {
            l.add((String)l.remove(0));
        }
        return l.toArray(new String[l.size()]);
    }

    protected int getCount(int connectionCount) {
        if (this.useConnectionCount) {
            return connectionCount;
        }
        return this.returnAndIncrementInvocationCount();
    }

    private int returnAndIncrementInvocationCount() {
        int i = this.invocationCount++;
        if (this.invocationCount < 0) {
            this.invocationCount = 0;
        }
        return i;
    }
}

