/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.components;

import java.util.List;
import java.util.Set;
import org.eclipse.elk.alg.layered.components.ComponentGroup;
import org.eclipse.elk.alg.layered.components.ComponentGroupGraphPlacer;
import org.eclipse.elk.alg.layered.components.ComponentsCompactor;
import org.eclipse.elk.alg.layered.components.ModelOrderComponentGroup;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.EdgeRouting;
import org.eclipse.elk.core.options.PortSide;

public class ComponentGroupModelOrderGraphPlacer
extends ComponentGroupGraphPlacer {
    @Override
    public void combine(List<LGraph> components, LGraph target) {
        this.componentGroups.clear();
        assert (!components.contains(target));
        target.getLayerlessNodes().clear();
        if (components.isEmpty()) {
            target.getSize().x = 0.0;
            target.getSize().y = 0.0;
            return;
        }
        LGraph firstComponent = components.get(0);
        target.copyProperties(firstComponent);
        for (LGraph component : components) {
            this.addComponent(component);
        }
        KVector spaceBlockedBySouthEdges = new KVector();
        KVector spaceBlockedByComponents = new KVector();
        KVector offset = new KVector();
        KVector maxSize = new KVector();
        double componentSpacing = firstComponent.getProperty(LayeredOptions.SPACING_COMPONENT_COMPONENT);
        for (ComponentGroup group : this.componentGroups) {
            if (target.getProperty(CoreOptions.DIRECTION).isHorizontal()) {
                offset.x = spaceBlockedBySouthEdges.x;
                for (Set<PortSide> side : group.getPortSides()) {
                    if (!side.contains((Object)PortSide.NORTH)) continue;
                    offset.x = spaceBlockedByComponents.x;
                    break;
                }
            } else if (target.getProperty(CoreOptions.DIRECTION).isVertical()) {
                offset.y = spaceBlockedBySouthEdges.y;
                for (Set<PortSide> side : group.getPortSides()) {
                    if (!side.contains((Object)PortSide.WEST)) continue;
                    offset.y = spaceBlockedByComponents.y;
                    break;
                }
            }
            KVector groupSize = this.placeComponents((ModelOrderComponentGroup)group, componentSpacing);
            this.offsetGraphs(group.getComponents(), offset.x, offset.y);
            if (target.getProperty(CoreOptions.DIRECTION).isHorizontal()) {
                spaceBlockedByComponents.x = offset.x + groupSize.x;
                maxSize.x = Math.max(maxSize.x, spaceBlockedByComponents.x);
                for (Set<PortSide> side : group.getPortSides()) {
                    if (!side.contains((Object)PortSide.SOUTH)) continue;
                    spaceBlockedBySouthEdges.x = offset.x + groupSize.x;
                    break;
                }
                offset.y = spaceBlockedByComponents.y = offset.y + groupSize.y;
                maxSize.y = Math.max(maxSize.y, offset.y);
                continue;
            }
            if (!target.getProperty(CoreOptions.DIRECTION).isVertical()) continue;
            spaceBlockedByComponents.y = offset.y + groupSize.y;
            maxSize.y = Math.max(maxSize.y, spaceBlockedByComponents.y);
            for (Set<PortSide> side : group.getPortSides()) {
                if (!side.contains((Object)PortSide.EAST)) continue;
                spaceBlockedBySouthEdges.y = offset.y + groupSize.y;
                break;
            }
            offset.x = spaceBlockedByComponents.x = offset.x + groupSize.x;
            maxSize.x = Math.max(maxSize.x, offset.x);
        }
        target.getSize().x = maxSize.x - componentSpacing;
        target.getSize().y = maxSize.y - componentSpacing;
        if (firstComponent.getProperty(LayeredOptions.COMPACTION_CONNECTED_COMPONENTS).booleanValue() && firstComponent.getProperty(LayeredOptions.EDGE_ROUTING) == EdgeRouting.ORTHOGONAL) {
            for (LGraph h : components) {
                this.offsetGraph(h, h.getOffset().x, h.getOffset().y);
            }
            ComponentsCompactor compactor = new ComponentsCompactor();
            compactor.compact(components, target.getSize(), componentSpacing);
            for (LGraph h : components) {
                h.getOffset().reset().add(compactor.getOffset());
            }
            target.getSize().reset().add(compactor.getGraphSize());
        }
        for (ComponentGroup group : this.componentGroups) {
            this.moveGraphs(target, group.getComponents(), 0.0, 0.0);
        }
    }

    @Override
    protected void addComponent(LGraph component) {
        ModelOrderComponentGroup group;
        if (this.componentGroups.size() > 0 && (group = (ModelOrderComponentGroup)this.componentGroups.get(this.componentGroups.size() - 1)).add(component)) {
            return;
        }
        this.componentGroups.add(new ModelOrderComponentGroup(component));
    }
}

