#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-2MIryVSXNLUD3789jnn6pO
key:                  postgrest-10.0.0-2MIryVSXNLUD3789jnn6pO
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  3d202b62277c2cc7ef022838ec2f1a20
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.6.6/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.6.6/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-2MIryVSXNLUD3789jnn6pO
depends:
    HTTP-4000.4.1-8O75y29IWVNCX2I1ZksBH
    Ranged-sets-0.5.0-22TuzEKejczKmPIHDvrHbw
    aeson-2.1.2.1-JZeWX2s1eQL7Ta3HF3w6fW
    auto-update-0.1.6-1YTFJpMGicb2BLz3b8FTyw base-4.18.2.1
    base64-bytestring-1.2.1.0-B0w0hfBZVmq3UW6lmjr7G bytestring-0.11.5.3
    case-insensitive-1.2.1.0-LnNRkIvaVf25YvATjz2MZ1
    cassava-0.5.4.1-BNFig0Nv1LW4b1LMaP7WiA
    configurator-pg-0.2.11-CtYtgZ5Eh9tETagxPV7QJI containers-0.6.7
    contravariant-extras-0.3.5.4-3woyg6AJRP6Lk666ZeP5zR
    cookie-0.5.0-Dqi2dsQ09KG8Z0mbWITxu5 directory-1.3.8.5
    either-5.0.3-Hi3c9Ob3YV6GJY8mIIEmP0
    gitrev-1.3.1-HjgHeGOzFY1JvYhlt8eDSs
    hasql-1.5.0.5-BSzci0maUUH2z2s3ZLKsxP
    hasql-dynamic-statements-0.3.1.1-LBGHKYwXNrIKIMDAM2njme
    hasql-notifications-0.2.0.5-DNRHOGaobrlApoWju0Htnr
    hasql-pool-0.5.2.2-2701syfxJkC77QKvrX25FU
    hasql-transaction-1.0.1.1-7RiOWijgRaI5aTFmFVFNC8
    heredoc-0.2.0.0-6fzsisYvDUd6tBbd4jIzIt
    http-types-0.12.4-Ab6499xPt6j7ocIybq2ygA
    insert-ordered-containers-0.2.5.3-68KZlbg0u7nEIXHoneqXPO
    interpolatedstring-perl6-1.0.2-EAykRbKO1IMCFI7NLmMldA
    jose-0.10-6XSyExbf3Yr4FsZZdRDZBP lens-5.3.3-6yFfjYmjPBKuNNVCwyEN9
    lens-aeson-1.2.3-1Tdj2bMo4Ui3vkZhSclzpf mtl-2.3.1
    network-3.1.4.0-DqImTC0JtBs7wAjAQOfbw6
    network-uri-2.6.4.2-4GU1spYfCy5EsCjKjgc97p
    optparse-applicative-0.18.1.0-3S7fKkQk1IxEovxwORLzkN
    parsec-3.1.16.1 protolude-0.3.5-ESsXq1BsMF9AAVzclMnPlO
    regex-tdfa-1.3.2.5-qZoXOptISAJcpXFSPLOTl
    retry-0.9.3.1-8yeiyLHG1WMEv3ne7xNi6W
    scientific-0.3.8.0-7SlgUkp6kxxBFUUY5SNCvh
    swagger2-2.8.10-2us3e1fIx0BDGkxwlM6s6W text-2.0.2 time-1.12.2
    unix-2.8.4.0 unordered-containers-0.2.20.1-8SON4238u8N3rDHPceHjHx
    vault-0.3.1.5-6XoCCfgXDmrK1lP7OIwi21
    vector-0.13.2.0-JoP5POFPMLsLn1of7TvjGI
    wai-3.2.4-L3dKuQqjqvcGg94VR3jCz4
    wai-cors-0.2.7-7DdzWeEevoLGhcgpUdtWjB
    wai-extra-3.1.18-5trG4ApvUwyGbrzSbO3z4m
    wai-logger-2.5.0-KTJJVUbAJTmLVONr4EO435
    warp-3.4.0-2lWPYYPo1DQ9GQAHs0s6t9

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

