import { Color, ColorInformation, ColorPresentation, CompletionContext, CompletionList, Diagnostic, Hover, Position, Range, SymbolInformation, SelectionRange, DocumentHighlight, WorkspaceFolder } from 'vscode-languageserver';
import { Document, DocumentManager } from '../../lib/documents';
import { LSConfigManager } from '../../ls-config';
import { ColorPresentationsProvider, CompletionsProvider, DiagnosticsProvider, DocumentColorsProvider, DocumentHighlightProvider, DocumentSymbolsProvider, FoldingRangeProvider, HoverProvider, SelectionRangeProvider } from '../interfaces';
import { CSSLanguageServices } from './service';
import { FoldingRange } from 'vscode-languageserver-types';
export declare class CSSPlugin implements HoverProvider, CompletionsProvider, DiagnosticsProvider, DocumentColorsProvider, ColorPresentationsProvider, DocumentSymbolsProvider, SelectionRangeProvider, DocumentHighlightProvider, FoldingRangeProvider {
    __name: string;
    private configManager;
    private cssDocuments;
    private cssLanguageServices;
    private workspaceFolders;
    private triggerCharacters;
    private globalVars;
    constructor(docManager: DocumentManager, configManager: LSConfigManager, workspaceFolders: WorkspaceFolder[], cssLanguageServices: CSSLanguageServices);
    getSelectionRange(document: Document, position: Position): SelectionRange | null;
    getDiagnostics(document: Document): Diagnostic[];
    doHover(document: Document, position: Position): Hover | null;
    private doHoverInternal;
    getCompletions(document: Document, position: Position, completionContext?: CompletionContext): Promise<CompletionList | null>;
    private inStyleAttributeWithoutInterpolation;
    private getCompletionsInternal;
    private appendGlobalVars;
    getDocumentColors(document: Document): ColorInformation[];
    getColorPresentations(document: Document, range: Range, color: Color): ColorPresentation[];
    getDocumentSymbols(document: Document): SymbolInformation[];
    getFoldingRanges(document: Document): FoldingRange[];
    private nonSyntacticFolding;
    findDocumentHighlight(document: Document, position: Position): DocumentHighlight[] | null;
    private findDocumentHighlightInternal;
    private getCSSDoc;
    private updateConfigs;
    private featureEnabled;
    private getLanguageService;
}
