/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.history;

import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.utils.ZapNumberSpinner;
import org.zaproxy.zap.view.popup.PopupMenuItemHistoryReferenceContainer;

public class PopupMenuJumpTo
extends PopupMenuItemHistoryReferenceContainer {
    private static final Logger LOGGER = LogManager.getLogger(PopupMenuJumpTo.class);
    private static final List<Integer> DISPLAYED_HISTORY_TYPES = List.of(Integer.valueOf(1), Integer.valueOf(15), Integer.valueOf(16));
    private static final KeyStroke JUMP_KEY_STROKE = KeyStroke.getKeyStroke(74, 640);
    private static ZapNumberSpinner idSpinner = new ZapNumberSpinner(1, 1, Integer.MAX_VALUE);
    private final ExtensionHistory extension;

    public PopupMenuJumpTo(ExtensionHistory extension) {
        super(Constant.messages.getString("history.jumpto.popup.label"));
        this.extension = extension;
        String jumpTo = "zap.history.jumpto";
        View.getSingleton().getWorkbench().getInputMap(2).put(JUMP_KEY_STROKE, jumpTo);
        View.getSingleton().getWorkbench().getActionMap().put(jumpTo, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupMenuJumpTo.this.jump();
            }
        });
        this.setAccelerator(View.getSingleton().getMenuShortcutKeyStroke(JUMP_KEY_STROKE.getKeyCode(), JUMP_KEY_STROKE.getModifiers(), false));
    }

    @Override
    protected boolean isButtonEnabledForHistoryReference(HistoryReference historyReference) {
        return DISPLAYED_HISTORY_TYPES.contains(historyReference.getHistoryType());
    }

    @Override
    public void performAction(HistoryReference href) {
        this.jump();
    }

    private void jump() {
        int option = JOptionPane.showOptionDialog(null, new Object[]{Constant.messages.getString("history.jumpto.message"), idSpinner}, Constant.messages.getString("history.jumpto.title"), 2, 3, null, null, null);
        if (option == 0) {
            int historyId = idSpinner.getValue();
            if (this.extension.getHistoryReferencesTable().getModel().getEntryRowIndex(historyId) != -1) {
                this.extension.showInHistory(this.extension.getHistoryReference(historyId));
                return;
            }
            List<Integer> list = this.extension.getHistoryIds();
            if (list.isEmpty()) {
                return;
            }
            int nearestIdx = Math.abs(Collections.binarySearch(list, historyId)) - 1;
            if (nearestIdx >= list.size()) {
                nearestIdx = list.size() - 1;
            }
            HistoryReference nearestRef = this.extension.getHistoryReference(list.get(nearestIdx));
            this.extension.showInHistory(nearestRef);
            LOGGER.debug("Jumping to nearest ID: {}, after request for: {}", (Object)nearestRef.getHistoryId(), (Object)historyId);
        }
    }

    @Override
    public boolean isSafe() {
        return true;
    }
}

