/*
 * Tlf - contest logging program for amateur radio operators
 * Copyright (C) 2001-2002-2003 Rein Couperus <pa0rct@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
  	/* ------------------------------------------------------------
 	*        Initialize  call array for dupes
 	*
 	*--------------------------------------------------------------*/

#include "readcalls.h"
#include <curses.h>
#include "tlf.h"

 	int readcalls(void)
 	{
 	extern char callarray[MAX_CALLS][20];
	extern char qsos[MAX_QSOS][82];
	extern char logfile[];
 	extern int contest;
 	extern int cqww;
 	extern int arrldx_usa;
 	extern int pacc_pa_flg;
	extern int universal;
	extern int country_mult;
 	extern int other_flg;
 	extern int bandinx;
 	extern char hiscall[];
 	extern int total;
 	extern int call_band[MAX_CALLS];
	extern int call_country[MAX_CALLS];
	extern int band_score[9];
	extern int zones[41];
	extern int countries[MAX_DATALINES];
	extern char call_exchange[MAX_CALLS][12];
	extern int wpx;
	extern char prefixes_worked[MAX_CALLS][6];
	extern char mults[MAX_MULTS][12];
	extern int multarray_nr;
	extern int arrlss;
	extern int serial_section_mult;
	extern int sectn_mult;
	extern int dx_arrlsections;
	extern int mult_bands[];
	extern int wysiwyg_multi;
	extern int wysiwyg_once;
	extern int wysiwygmults;
	extern int multcount;
	extern int multscore[];
	extern char pxstr[];
	extern int nr_of_px;
	extern int zonescore[6];
	extern int countryscore[6];
	extern int qsonum;
    	extern int callarray_nr;
    	extern int countrynr;
    	extern int w_cty;
    	extern int ve_cty;

 	char inputbuffer[160];
 	char inp2buf[20];
 	char inp3buf[20];
 	char pointbuf[20];
 	char bndbuf[20];
 	char zonebuf[3];
 	char checkcall[20];
 	int i = 0, j = 0,  k =  0, l = 0, n = 0, p = 0, q = 0, r = 0, s=0;
 	int band = 0;
 	int found = 0;
 	int ii;
 	int m=0;
	int t=0;
	int z = 0;
	int add_ok;
	char multbuffer[40];
	int increase = 0;
	int ctr; // local counter
	char presentcall[20]; // copy of call..


 	int keep = 0, keep_band = 0, last_band;
 	int inx[9] = {32,16,8,0,4,0,2,0,1} ;

 	size_t x;

 	FILE *fp;

 	clear();
 	mvprintw(4,0,  "Reading logfile...\n");
 	refresh();

	for(s =0 ; s<MAX_QSOS; s++)
		qsos[s][0] = '\0';

	for (i = 0  ;  i <=  MAX_CALLS ;  i++)
 		callarray[i][0] =  '\0';

 	for (i = 1 ; i <=  MAX_DATALINES-1 ; i++)
 		countries[i] = 0;

 	for (i = 0; i <= 8 ; i++)
 		band_score[i] = 0;

 	for (i = 0; i <= 5 ; i++)
 		countryscore[i] = 0;

 	for (n = 1 ; n <= 40 ; n++)
      	zones[n]  = 0;

	for (n = 0 ; n <= 5 ; n++)
      	multscore[n]  = 0;

 	for (n = 0; n < MAX_MULTS; n++)
 		mult_bands[n] = 0;




 	if  ( (fp = fopen(logfile,"r"))  == NULL){
		mvprintw(5,0,  "Error opening logfile.\n");
		refresh();
		sleep(2);
		}
	i = 0;
	k = 0;
	l = 0;
	total = 0;
	s = 0;
	t = 0;


	while(!feof(fp)){

		fgets (inputbuffer, 90,  fp);


		r++;
		
		if (r >= 100){
		 	r = 0;
		 	printw("*");
		 	refresh();
		}

		strcat(inputbuffer, "                                                  ");          /* repair the logfile */
		inputbuffer[79]=' ';
		inputbuffer[80] = '\0';

		for (t = 0; t <= strlen(inputbuffer); t++) {
			if (inputbuffer[t] == '\n')  inputbuffer[t] = ' ';
		}

		strncpy (qsos[s], inputbuffer, 81);
		s++;


		if  (inputbuffer[0]  == ';')
			continue;                							 /*  note in  log  */


		strncpy(inp3buf, inputbuffer  + 29, 10);
		inp3buf[15]  = '\0';

		if (contest == 1){
			strncpy(pointbuf, inputbuffer  + 76, 2);   /* get the points */
			pointbuf[2] = '\0';
			
			strncpy(bndbuf, inputbuffer + 1 , 2);
			bndbuf[2] = '\0';
			
			if (bndbuf[0] == '1' && bndbuf[1] == '0'){
				band = BANDINDEX_10;	
				keep_band = 5;
			}
			if (bndbuf[0] == '1' && bndbuf[1] == '5'){
				band = BANDINDEX_15;	
				keep_band = 4;	
			}
			if (bndbuf[0] == '2' ){
				band = BANDINDEX_20;
				keep_band = 3;	
			}	
			if (bndbuf[0] == '4' ) {
				band = BANDINDEX_40;
				keep_band = 2;	
			}	
			if (bndbuf[0] == '8'){
				band = BANDINDEX_80;	
				keep_band = 1;
			}
			if (bndbuf[0] == '6' ){
				band = BANDINDEX_160;
				keep_band = 0;
			}
			
			bandinx = band;                /* get the band */
			

			if (cqww == 1){
				strncpy(zonebuf, inputbuffer + 54, 2);     /* get the zone */
				zonebuf[2] = '\0';
				z = zone_nr(zonebuf);
			}
			
			total = total + atoi(pointbuf);

			keep = atoi(pointbuf);
				
				pointbuf[0] = '0';

			/* get the country number, not known at this point */


			for (ctr=0 ; ctr < strlen(inp3buf); ctr++) { // concat the string
				if (inp3buf[ctr]==' ') {
					inp3buf[ctr]='\0';
					break;
				}
			}
			strcpy(presentcall, inp3buf);
			countrynr=getctydata(presentcall);


			if (wysiwyg_once ==1 ||
				wysiwyg_multi == 1 ||
				arrlss == 1|| 
				serial_section_mult == 1|| 
				sectn_mult == 1 ||
				(dx_arrlsections == 1) && ((countrynr == w_cty) || (countrynr == ve_cty))){

  					multbuffer[0] = '\0';

					if (arrlss == 1) {
						other_flg = 0;

						if (inputbuffer[63] == ' ')
							strncpy(multbuffer, inputbuffer+64, 3);
						else
							strncpy(multbuffer, inputbuffer+63, 3);

						multbuffer[3]='\0';

					} else if (serial_section_mult == 1)  {

							strncpy(multbuffer, inputbuffer+59, 8);

							for (t = 0; t < 9; t++){
								if (multbuffer[t] == ' '){
									multbuffer[t] = '\0';
									break;
								}
							}


					} else {

						strncpy(multbuffer, inputbuffer+54, 10);       // normal case

						multbuffer[10]= '\0';

						if ((strlen(multbuffer) > 9) && (multbuffer[9] == ' '))
							multbuffer[8] = '\0';
						if ((strlen(multbuffer) > 8) && (multbuffer[8] == ' '))
							multbuffer[8] = '\0';
						if ((strlen(multbuffer) > 7) && (multbuffer[7] == ' '))
							multbuffer[7] = '\0';
						if ((strlen(multbuffer) > 6) &&(multbuffer[6] == ' '))
							multbuffer[6] = '\0';
						if ((strlen(multbuffer) > 5) &&(multbuffer[5] == ' '))
							multbuffer[5] = '\0';
						if ((strlen(multbuffer) > 4) &&(multbuffer[4] == ' '))
							multbuffer[4] = '\0';
						if ((strlen(multbuffer) > 3) &&(multbuffer[3] == ' '))
							multbuffer[3] = '\0';
						if ((strlen(multbuffer) > 2) &&(multbuffer[2] == ' '))
							multbuffer[2] = '\0';
						if ((strlen(multbuffer) > 1) &&(multbuffer[1] == ' '))
							multbuffer[1] = '\0';

					}

						if (bndbuf[0] == '1' && bndbuf[1] == '0')
				    			band = BANDINDEX_10;
				    		if (bndbuf[0] == '1' && bndbuf[1] == '5')
				    			band = BANDINDEX_15;
				    		if (bndbuf[0] == '2' )
				    			band = BANDINDEX_20;
				    		if (bndbuf[0] == '4' )
				    			band = BANDINDEX_40;
				    		if (bndbuf[0] == '8')
				    			band = BANDINDEX_80;
				    		if (bndbuf[0] == '6' )
				    			band = BANDINDEX_160;

			for (ii = 0; ii <= multarray_nr; ii++) {


				if (strcmp(mults[ii], multbuffer) == 0) {                  // already there


					found = 1;

					if((mult_bands[ii] & inx[bandinx]) == 0) {        // this band?

						mult_bands[ii] = mult_bands[ii] | inx[bandinx];

						switch (band) {

            						case BANDINDEX_160:{
								last_band = 0;
            							multscore[0]++;
            							break;
            						}
            						case BANDINDEX_80:{
								last_band = 1;
            							multscore[1]++;
            							break;
            						}
            						case BANDINDEX_40:{
								last_band = 2;
            							multscore[2]++;
            							break;
            						}
            						case BANDINDEX_20:{
								last_band = 3;
            							multscore[3]++;
            							break;
            						}
            						case BANDINDEX_15:{
								last_band = 4;
            							multscore[4]++;
            							break;
            						}
            						case BANDINDEX_10:{
								last_band = 5;
            							multscore[5]++;
            							break;
            						}

            					}   // end switch

						break;

					}  else break;      // end if mark

				}   else found = 0;   // end cmp
			}     // end for loop

			if ( found == 0) {                    // add it

					multarray_nr++;

					strcpy(mults[multarray_nr], multbuffer);

					if (strlen(mults[multarray_nr]) > 0)
						mult_bands[multarray_nr] = mult_bands[multarray_nr] | inx[bandinx];

					switch (band) {

            					case BANDINDEX_160:{
							last_band = 0;
            						multscore[0]++;
            						break;
            					}
            					case BANDINDEX_80:{
							last_band = 1;
            						multscore[1]++;
            						break;
            					}
            					case BANDINDEX_40:{
							last_band = 2;
            						multscore[2]++;
            						break;
            					}
            					case BANDINDEX_20:{
							last_band = 3;
            						multscore[3]++;
            						break;
            					}
            					case BANDINDEX_15:{
							last_band = 4;
            						multscore[4]++;
            						break;
            					}
            					case BANDINDEX_10:{
							last_band = 5;
            						multscore[5]++;
            						break;
            					}


					}     // end switch


				 	wysiwygmults++;
					multcount++;




				}       // end not found

			}         // end wysiwig

			if (other_flg == 1) {                         /* mult = max 3 characters */

				    	if (bndbuf[0] == '1' && bndbuf[1] == '0'){
				    		band = BANDINDEX_10;
				    		last_band = 5;
				    	}
				    	if (bndbuf[0] == '1' && bndbuf[1] == '5'){
				    		band = BANDINDEX_15;
				    		last_band = 4;
				    	}
				    	if (bndbuf[0] == '2' ) {
				    		band = BANDINDEX_20;
				    		last_band = 3;
				    	}
				    	if (bndbuf[0] == '4' ) {
				    		band = BANDINDEX_40;
				    		last_band = 2;
				    	}
				    	if (bndbuf[0] == '8')  {
				    		band = BANDINDEX_80;
				    		last_band = 1;
				    	}
				    	if (bndbuf[0] == '6' ) {
				    		band = BANDINDEX_160;
				    		last_band = 0;
				    	}


				found = 0;

				for (ii = 0; ii <= multarray_nr; ii++) {

					multbuffer[0]= '\0';

					strncpy(multbuffer, inputbuffer+54, 3);
					multbuffer[3] = '\0';


					if (multbuffer[3] == ' ')
						multbuffer[3] = '\0';
					if (multbuffer[2] == ' ')
						multbuffer[2] = '\0';
					if (multbuffer[1] == ' ')
						multbuffer[1] = '\0';


					if (strcmp(mults[ii], multbuffer) == 0) {
				    	found = 1;

				    	break;
				    }

				 }

				 if (found == 0) {
				    	strcpy(mults[multarray_nr], multbuffer);
				    	mult_bands[multarray_nr] = ( mult_bands[multarray_nr] | inx[band]);
				    	multarray_nr++;
				    	switch (band) {

            				case BANDINDEX_160:{
            					multscore[0]++;
            					break;
            				}
            				case BANDINDEX_80:{
            					multscore[1]++;
            					break;
            				}
            				case BANDINDEX_40:{
            					multscore[2]++;
            					break;
            				}
            				case BANDINDEX_20:{
            					multscore[3]++;
            					break;
            				}
            				case BANDINDEX_15:{
            					multscore[4]++;
            					break;
            				}
            				case BANDINDEX_10:{
            					multscore[5]++;
            					break;
            				}

            			}

				}

				else  {
						if (( mult_bands[ii] & inx[band]) == 0) {
							mult_bands[ii] = ( mult_bands[ii] | inx[band]);

						  switch (band) {

            				case BANDINDEX_160:{
            					multscore[0]++;
            					break;
            				}
            				case BANDINDEX_80:{
            					multscore[1]++;
            					break;
            				}
            				case BANDINDEX_40:{
            					multscore[2]++;
            					break;
            				}
            				case BANDINDEX_20:{
            					multscore[3]++;
            					break;
            				}
            				case BANDINDEX_15:{
            					multscore[4]++;
            					break;
            				}
            				case BANDINDEX_10:{
            					multscore[5]++;
            					break;
            				}
           			  	  }
           			  	}

					}


			}


		 }
		/*  once  per call !  */
		for  (k=0;  k < i; k++){	// changed k=< i
		 	 m = strcmp(callarray[k], inp3buf);

		 	 if (m == 0){
		 	 		l  =  k;
		 	 		break;
		 	 }
		 	 else
		 	 		l  =  i;

		}

		strncpy(callarray[l] , inputbuffer + 29 , 10);
		x  = strcspn(callarray[l], " ");
		strncpy(inp2buf, callarray[l], x);
		inp2buf[x] = '\0';
		j = getctydata(inp2buf);	/* country number  */
        		call_country[l] = j;
		countrynr = j;
		band = call_band[l];
		strncpy(bndbuf, inputbuffer + 1 , 2);
		bndbuf[2] = '\0';

		add_ok = 1;              /* look if calls are excluded */

		if ((arrldx_usa ==1) && ((countrynr == w_cty) || (countrynr == ve_cty)))
			add_ok = 0;


		if (pacc_pa_flg == 1) {


		strncpy(hiscall, inputbuffer + 29, 10);

		add_ok = pacc_pa();

 		if (add_ok == 0) {
 			band_score[bandinx]++;
 			increase++;
 		}

 		hiscall[0] = '\0';
		}

	  	if (add_ok == 1){

		if (bndbuf[0] == '1' && bndbuf[1] == '0'){
			band = band | BAND10;                     /* mark band as worked */
			band_score[BANDINDEX_10]++;               /*  qso counter  per band */
			keep_band = BANDINDEX_10;
			if (cqww ==1)
				zones[z] = zones[z] | BAND10;

			}
		if (bndbuf[0] == '1' && bndbuf[1] == '5'){
			band = band | BAND15;
			band_score[BANDINDEX_15]++;
			keep_band =BANDINDEX_15;
			if (cqww ==1)
				zones[z] = zones[z] | BAND15;

			}
		if (bndbuf[0] == '2'){
			band = band | BAND20;
			band_score[BANDINDEX_20]++;
			keep_band = BANDINDEX_20;
			if (cqww ==1)
				zones[z] = zones[z] | BAND20;

			}
		if (bndbuf[0] == '4'){
			band  = band | BAND40;
			band_score[BANDINDEX_40]++;
			keep_band = BANDINDEX_40;
			if (cqww ==1)
				zones[z] = zones[z] | BAND40;

			}
		if (bndbuf[0] == '8'){
			band = band | BAND80;
			band_score[BANDINDEX_80]++;
			keep_band = BANDINDEX_80;
			if (cqww ==1)
				zones[z] = zones[z] | BAND80;

			}
		if (bndbuf[0] == '6'){
			band = band | BAND160;
			band_score[BANDINDEX_160]++;
			keep_band = BANDINDEX_160;
			if (cqww ==1)
				zones[z] = zones[z] | BAND160;

			}


			call_band[l] = band;

			countries[j] = band |  countries[j];

	  	} /* end add_ok */
		strncpy(call_exchange[l], inputbuffer + 54, 11);
		call_exchange[l][11] = '\0';
		if  (  l ==  i)
			i++;
        }

        fclose(fp);

      if (wpx == 1){

        for (n = 0 ; n <= i ; n++){
        	checkcall[0] = '\0';
        	strcat(checkcall, callarray[n]);
        	getpx(checkcall);

        	prefixes_worked[p][0] = '\0';

        	for (q = 0 ; q <= p ; q++){
        	 	if (strcmp(pxstr, prefixes_worked[q]) == 0){
        	 	    found = 1;
        	 		break;

        	 	}
        	}
        	if (found != 1){
        		strcat(prefixes_worked[p], pxstr);
        		 p++;
        	}
        	found = 0;


	nr_of_px = p ;


         }
      }  /* end wpx */

      if (cqww == 1){
      		for (n = 1 ; n <= 40 ; n++){
      		 	if ((zones[n] & BAND160)!= 0)
      		 		zonescore[0]++;
      		 	if ((zones[n] & BAND80) != 0)
      		 		zonescore[1]++;
      		 	if ((zones[n] & BAND40) != 0)
      		 		zonescore[2]++;
      		 	if ((zones[n] & BAND20) != 0)
      		 		zonescore[3]++;
      		 	if ((zones[n] & BAND15) != 0)
      		 		zonescore[4]++;
      		 	if ((zones[n] & BAND10) != 0)
      		 		zonescore[5]++;
      		}

             for (n = 1 ; n <=  MAX_DATALINES-1 ; n++)
             {
            	if ((countries[n] & BAND160) !=  0)
            		countryscore[0]++;
            	if ((countries[n] & BAND80) !=  0)
            		countryscore[1]++;
            	if ((countries[n] & BAND40) !=  0)
            		countryscore[2]++;
            	if ((countries[n] & BAND20) !=  0)
            		countryscore[3]++;
            	if ((countries[n] & BAND15) !=  0)
            		countryscore[4]++;
            	if ((countries[n] & BAND10) !=  0)
            		countryscore[5]++;
			  }
		}   /* end cqww */

			if (dx_arrlsections == 1) {

				int cntr;

				for (cntr = 1 ; cntr <  MAX_DATALINES ; cntr++){

					if (cntr != w_cty && cntr != ve_cty)		// W and VE don't count here...
					{
						if ((countries[cntr] & BAND160) !=  0)
							countryscore[0]++;
						if ((countries[cntr] & BAND80) !=  0)
							countryscore[1]++;
						if ((countries[cntr] & BAND40) !=  0)
							countryscore[2]++;
						if ((countries[cntr] & BAND20) !=  0)
							countryscore[3]++;
						if ((countries[cntr] & BAND15) !=  0)
							countryscore[4]++;
						if ((countries[cntr] & BAND10) !=  0)
							countryscore[5]++;
					}
				}
			} // end dx_arrlsections

			if ((arrldx_usa == 1) && (countrynr != w_cty) && (countrynr != ve_cty)){

			 int cntr;
			 for (cntr = 1 ; cntr <  MAX_DATALINES ; cntr++)
             {
            	if ((countries[cntr] & BAND160) !=  0)
            		countryscore[0]++;
            	if ((countries[cntr] & BAND80) !=  0)
            		countryscore[1]++;
            	if ((countries[cntr] & BAND40) !=  0)
            		countryscore[2]++;
            	if ((countries[cntr] & BAND20) !=  0)
            		countryscore[3]++;
            	if ((countries[cntr] & BAND15) !=  0)
            		countryscore[4]++;
            	if ((countries[cntr] & BAND10) !=  0)
            		countryscore[5]++;
			  }

		}   /* end arrldx_usa */


		if (pacc_pa_flg == 1){

	 		for (n = 1 ; n <  MAX_DATALINES ; n++)
             {
            	if ((countries[n] & BAND160) !=  0)
            		countryscore[0]++;
            	if ((countries[n] & BAND80) !=  0)
            		countryscore[1]++;
            	if ((countries[n] & BAND40) !=  0)
            		countryscore[2]++;
            	if ((countries[n] & BAND20) !=  0)
            		countryscore[3]++;
            	if ((countries[n] & BAND15) !=  0)
            		countryscore[4]++;
            	if ((countries[n] & BAND10) !=  0)
            		countryscore[5]++;
			  }
         }
		if (country_mult == 1){

	 		for (n = 1 ; n <=  MAX_DATALINES-1 ; n++)
             {
            	if ((countries[n] & BAND160) !=  0)
            		countryscore[0]++;
            	if ((countries[n] & BAND80) !=  0)
            		countryscore[1]++;
            	if ((countries[n] & BAND40) !=  0)
            		countryscore[2]++;
            	if ((countries[n] & BAND20) !=  0)
            		countryscore[3]++;
            	if ((countries[n] & BAND15) !=  0)
            		countryscore[4]++;
            	if ((countries[n] & BAND10) !=  0)
            		countryscore[5]++;
			  }
         }


        total = total - keep;

        	band_score[keep_band]--;

        if (qsonum == 1){
         nr_of_px = 0;
         total = 0;
         for (i = 0; i <= BAND10 ; i++)
         	band_score[i] = 0;

          for (i = 0; i <= 5 ; i++)
         	countryscore[i] = 0;

          for (i = 0; i <= 5 ; i++)
         	multscore[i] = 0;

          wysiwygmults = 0;

        }
        callarray_nr = i;

	if ((arrlss == 1) &&(total == 0) )  multcount=0;


if (((serial_section_mult == 1)|| (sectn_mult == 1)) && multarray_nr == 1){               // correction ......
	 mults[1][0] = '\0';
	 mult_bands[1] = 0;
}  else if  (serial_section_mult == 1 && multarray_nr > 1)
	multarray_nr++;

	 return(s);                 // nr of qso's
 	}



