/*
 * Decompiled with CFR 0.152.
 */
package sun.jvmstat.perfdata.monitor;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import sun.jvmstat.monitor.Monitor;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.perfdata.monitor.AliasFileParser;
import sun.jvmstat.perfdata.monitor.MonitorStatus;
import sun.jvmstat.perfdata.monitor.SyntaxException;

public abstract class PerfDataBufferImpl {
    protected ByteBuffer buffer;
    protected Map monitors;
    protected int lvmid;
    protected Map aliasMap;
    protected Map aliasCache;

    protected PerfDataBufferImpl(ByteBuffer byteBuffer, int n) {
        this.buffer = byteBuffer;
        this.lvmid = n;
        this.monitors = new TreeMap();
        this.aliasMap = new HashMap();
        this.aliasCache = new HashMap();
    }

    public int getLocalVmId() {
        return this.lvmid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes() {
        ByteBuffer byteBuffer = null;
        Object object = this;
        synchronized (object) {
            try {
                if (this.monitors.isEmpty()) {
                    this.buildMonitorMap(this.monitors);
                }
            }
            catch (MonitorException monitorException) {
                // empty catch block
            }
            byteBuffer = this.buffer.duplicate();
        }
        byteBuffer.rewind();
        object = new byte[byteBuffer.limit()];
        byteBuffer.get((byte[])object);
        return object;
    }

    public int getCapacity() {
        return this.buffer.capacity();
    }

    ByteBuffer getByteBuffer() {
        return this.buffer;
    }

    private void buildAliasMap() {
        Object object;
        assert (Thread.holdsLock(this));
        URL uRL = null;
        String string = System.getProperty("sun.jvmstat.perfdata.aliasmap");
        if (string != null) {
            object = new File(string);
            try {
                uRL = ((File)object).toURL();
            }
            catch (MalformedURLException malformedURLException) {
                throw new IllegalArgumentException(malformedURLException);
            }
        } else {
            uRL = this.getClass().getResource("/sun/jvmstat/perfdata/resources/aliasmap");
        }
        assert (uRL != null);
        object = new AliasFileParser(uRL);
        try {
            ((AliasFileParser)object).parse(this.aliasMap);
        }
        catch (IOException iOException) {
            System.err.println("Error processing " + string + ": " + iOException.getMessage());
        }
        catch (SyntaxException syntaxException) {
            System.err.println("Syntax error parsing " + string + ": " + syntaxException.getMessage());
        }
    }

    protected Monitor findByAlias(String string) {
        ArrayList arrayList;
        assert (Thread.holdsLock(this));
        Monitor monitor = (Monitor)this.aliasCache.get(string);
        if (monitor == null && (arrayList = (ArrayList)this.aliasMap.get(string)) != null) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext() && monitor == null) {
                String string2 = (String)iterator.next();
                monitor = (Monitor)this.monitors.get(string2);
            }
        }
        return monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Monitor findByName(String string) throws MonitorException {
        Monitor monitor = null;
        PerfDataBufferImpl perfDataBufferImpl = this;
        synchronized (perfDataBufferImpl) {
            if (this.monitors.isEmpty()) {
                this.buildMonitorMap(this.monitors);
                this.buildAliasMap();
            }
            if ((monitor = (Monitor)this.monitors.get(string)) == null) {
                this.getNewMonitors(this.monitors);
                monitor = (Monitor)this.monitors.get(string);
            }
            if (monitor == null) {
                monitor = this.findByAlias(string);
            }
        }
        return monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findByPattern(String string) throws MonitorException, PatternSyntaxException {
        Object object = this;
        synchronized (object) {
            if (this.monitors.isEmpty()) {
                this.buildMonitorMap(this.monitors);
            } else {
                this.getNewMonitors(this.monitors);
            }
        }
        object = Pattern.compile(string);
        Matcher matcher = ((Pattern)object).matcher("");
        ArrayList<Monitor> arrayList = new ArrayList<Monitor>();
        Set set = this.monitors.entrySet();
        for (Map.Entry entry : set) {
            String string2 = (String)entry.getKey();
            Monitor monitor = (Monitor)entry.getValue();
            matcher.reset(string2);
            if (!matcher.lookingAt()) continue;
            arrayList.add((Monitor)entry.getValue());
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MonitorStatus getMonitorStatus() throws MonitorException {
        PerfDataBufferImpl perfDataBufferImpl = this;
        synchronized (perfDataBufferImpl) {
            if (this.monitors.isEmpty()) {
                this.buildMonitorMap(this.monitors);
            }
            return this.getMonitorStatus(this.monitors);
        }
    }

    protected abstract MonitorStatus getMonitorStatus(Map var1) throws MonitorException;

    protected abstract void buildMonitorMap(Map var1) throws MonitorException;

    protected abstract void getNewMonitors(Map var1) throws MonitorException;
}

