/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jstat;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import sun.tools.jstat.ColumnFormat;
import sun.tools.jstat.OptionFormat;
import sun.tools.jstat.Parser;
import sun.tools.jstat.ParserException;

public class OptionFinder {
    private static final boolean debug = false;
    URL[] optionsSources;

    public OptionFinder(URL[] uRLArray) {
        this.optionsSources = uRLArray;
    }

    public OptionFormat getOptionFormat(String string, boolean bl) {
        OptionFormat optionFormat = this.getOptionFormat(string, this.optionsSources);
        OptionFormat optionFormat2 = null;
        if (optionFormat != null && bl && (optionFormat2 = this.getOptionFormat("timestamp", this.optionsSources)) != null) {
            ColumnFormat columnFormat = (ColumnFormat)optionFormat2.getSubFormat(0);
            optionFormat.insertSubFormat(0, columnFormat);
        }
        return optionFormat;
    }

    protected OptionFormat getOptionFormat(String string, URL[] uRLArray) {
        OptionFormat optionFormat = null;
        for (int i = 0; i < uRLArray.length && optionFormat == null; ++i) {
            try {
                URL uRL = uRLArray[i];
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
                optionFormat = new Parser(bufferedReader).parse(string);
                continue;
            }
            catch (IOException iOException) {
                continue;
            }
            catch (ParserException parserException) {
                System.err.println(uRLArray[i] + ": " + parserException.getMessage());
                System.err.println("Parsing of " + uRLArray[i] + " aborted");
            }
        }
        return optionFormat;
    }
}

