/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger;

import sun.jvm.hotspot.debugger.LongHashMap;
import sun.jvm.hotspot.debugger.Page;
import sun.jvm.hotspot.debugger.PageFetcher;
import sun.jvm.hotspot.debugger.UnmappedAddressException;
import sun.jvm.hotspot.utilities.Assert;

public class PageCache {
    private boolean enabled;
    private long pageSize;
    private long maxNumPages;
    private long pageMask;
    private long numPages;
    private PageFetcher fetcher;
    private LongHashMap addressToPageMap;
    private Page lruList;

    public PageCache(long pageSize, long maxNumPages, PageFetcher fetcher) {
        this.checkPageInfo(pageSize, maxNumPages);
        this.pageSize = pageSize;
        this.maxNumPages = maxNumPages;
        this.fetcher = fetcher;
        this.addressToPageMap = new LongHashMap();
        this.enabled = true;
    }

    public synchronized byte[] getData(long startAddress, long numBytes) throws UnmappedAddressException {
        byte[] data = new byte[(int)numBytes];
        long numRead = 0L;
        while (numBytes > 0L) {
            long pageBaseAddress = startAddress & this.pageMask;
            Page page = this.checkPage(this.getPage(pageBaseAddress), startAddress);
            long pageOffset = startAddress - pageBaseAddress;
            long numBytesFromPage = Math.min(this.pageSize - pageOffset, numBytes);
            page.getDataAsBytes(startAddress, numBytesFromPage, data, numRead);
            numRead += numBytesFromPage;
            numBytes -= numBytesFromPage;
            startAddress += numBytesFromPage;
        }
        return data;
    }

    public synchronized boolean getBoolean(long address) {
        return this.getByte(address) != 0;
    }

    public synchronized byte getByte(long address) {
        return this.checkPage(this.getPage(address & this.pageMask), address).getByte(address);
    }

    public synchronized short getShort(long address, boolean bigEndian) {
        return this.checkPage(this.getPage(address & this.pageMask), address).getShort(address, bigEndian);
    }

    public synchronized char getChar(long address, boolean bigEndian) {
        return this.checkPage(this.getPage(address & this.pageMask), address).getChar(address, bigEndian);
    }

    public synchronized int getInt(long address, boolean bigEndian) {
        return this.checkPage(this.getPage(address & this.pageMask), address).getInt(address, bigEndian);
    }

    public synchronized long getLong(long address, boolean bigEndian) {
        return this.checkPage(this.getPage(address & this.pageMask), address).getLong(address, bigEndian);
    }

    public synchronized float getFloat(long address, boolean bigEndian) {
        return this.checkPage(this.getPage(address & this.pageMask), address).getFloat(address, bigEndian);
    }

    public synchronized double getDouble(long address, boolean bigEndian) {
        return this.checkPage(this.getPage(address & this.pageMask), address).getDouble(address, bigEndian);
    }

    public synchronized void clear(long startAddress, long numBytes) {
        long endAddress = startAddress + numBytes;
        for (long pageBaseAddress = startAddress & this.pageMask; pageBaseAddress < endAddress; pageBaseAddress += this.pageSize) {
            this.flushPage(pageBaseAddress);
        }
    }

    public synchronized void clear() {
        this.addressToPageMap.clear();
        this.lruList = null;
        this.numPages = 0L;
    }

    public synchronized void disable() {
        this.enabled = false;
        this.clear();
    }

    public synchronized void enable() {
        this.enabled = true;
    }

    private Page getPage(long pageBaseAddress) {
        if (this.lruList != null && this.lruList.getBaseAddress() == pageBaseAddress) {
            return this.lruList;
        }
        long key = pageBaseAddress;
        Page page = (Page)this.addressToPageMap.get(key);
        if (page == null) {
            page = this.fetcher.fetchPage(pageBaseAddress, this.pageSize);
            if (this.enabled) {
                this.addressToPageMap.put(key, page);
                Assert.that(page == (Page)this.addressToPageMap.get(pageBaseAddress), "must have found page in cache!");
                this.addPageToList(page);
                if (this.numPages == this.maxNumPages) {
                    Page evictedPage = this.lruList.getPrev();
                    this.removePageFromList(evictedPage);
                    this.addressToPageMap.remove(evictedPage.getBaseAddress());
                } else {
                    ++this.numPages;
                }
            }
        } else {
            this.removePageFromList(page);
            this.addPageToList(page);
        }
        return page;
    }

    private Page checkPage(Page page, long startAddress) {
        if (!page.isMapped()) {
            throw new UnmappedAddressException(startAddress);
        }
        return page;
    }

    private int countPages() {
        Page page = this.lruList;
        int num = 0;
        if (page == null) {
            return num;
        }
        do {
            ++num;
        } while ((page = page.getNext()) != this.lruList);
        return num;
    }

    private void flushPage(long pageBaseAddress) {
        long key = pageBaseAddress;
        Page page = (Page)this.addressToPageMap.remove(key);
        if (page != null) {
            this.removePageFromList(page);
        }
    }

    private void addPageToList(Page page) {
        if (this.lruList == null) {
            this.lruList = page;
            page.setNext(page);
            page.setPrev(page);
        } else {
            page.setNext(this.lruList);
            page.setPrev(this.lruList.getPrev());
            this.lruList.getPrev().setNext(page);
            this.lruList.setPrev(page);
            this.lruList = page;
        }
    }

    private void removePageFromList(Page page) {
        if (page.getNext() == page) {
            this.lruList = null;
        } else {
            if (this.lruList == page) {
                this.lruList = page.getNext();
            }
            page.getPrev().setNext(page.getNext());
            page.getNext().setPrev(page.getPrev());
        }
        page.setPrev(null);
        page.setNext(null);
    }

    private void checkPageInfo(long pageSize, long maxNumPages) {
        if (pageSize <= 0L || maxNumPages <= 0L) {
            throw new IllegalArgumentException("pageSize and maxNumPages must both be greater than zero");
        }
        long tmpPageSize = pageSize >>> 32;
        if (tmpPageSize != 0L) {
            throw new IllegalArgumentException("pageSize " + pageSize + " too big (must fit within 32 bits)");
        }
        int numNonZeroBits = 0;
        for (int i = 0; i < 32; ++i) {
            if ((pageSize & 1L) != 0L && (++numNonZeroBits > 1 || i == 0)) {
                throw new IllegalArgumentException("pageSize " + pageSize + " must be a power of two");
            }
            pageSize >>>= 1;
            if (numNonZeroBits != 0) continue;
            this.pageMask = this.pageMask << 1 | 1L;
        }
        this.pageMask ^= 0xFFFFFFFFFFFFFFFFL;
    }
}

