/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.amd64;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.ThreadContext;

public abstract class AMD64ThreadContext
implements ThreadContext {
    public static final int R15 = 0;
    public static final int R14 = 1;
    public static final int R13 = 2;
    public static final int R12 = 3;
    public static final int RBP = 4;
    public static final int RBX = 5;
    public static final int R11 = 6;
    public static final int R10 = 7;
    public static final int R9 = 8;
    public static final int R8 = 9;
    public static final int RAX = 10;
    public static final int RCX = 11;
    public static final int RDX = 12;
    public static final int RSI = 13;
    public static final int RDI = 14;
    public static final int ORIG_RAX = 15;
    public static final int RIP = 16;
    public static final int CS = 17;
    public static final int EFLAGS = 18;
    public static final int RSP = 19;
    public static final int SS = 20;
    public static final int FS_BASE = 21;
    public static final int GS_BASE = 22;
    public static final int DS = 23;
    public static final int ES = 24;
    public static final int FS = 25;
    public static final int GS = 26;
    public static final int NPRGREG = 27;
    private static final String[] regNames = new String[]{"r15", "r14", "r13", "r12", "rbp", "rbx", "r11", "r10", "r9", "r8", "rax", "rcx", "rdx", "rsi", "rdi", "orig_rax", "rip", "cs", "eflags", "rsp", "ss", "fs_base", "gs_base", "ds", "es", "fs", "gs"};
    private long[] data = new long[27];

    public int getNumRegisters() {
        return 27;
    }

    public String getRegisterName(int index) {
        return regNames[index];
    }

    public void setRegister(int index, long value) {
        this.data[index] = value;
    }

    public long getRegister(int index) {
        return this.data[index];
    }

    public abstract void setRegisterAsAddress(int var1, Address var2);

    public abstract Address getRegisterAsAddress(int var1);
}

