/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.posix.elf;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import sun.jvm.hotspot.debugger.DataSource;
import sun.jvm.hotspot.debugger.RandomAccessFileDataSource;
import sun.jvm.hotspot.debugger.posix.elf.ELFException;
import sun.jvm.hotspot.debugger.posix.elf.ELFFile;
import sun.jvm.hotspot.debugger.posix.elf.ELFHashTable;
import sun.jvm.hotspot.debugger.posix.elf.ELFHeader;
import sun.jvm.hotspot.debugger.posix.elf.ELFSectionHeader;
import sun.jvm.hotspot.debugger.posix.elf.ELFStringTable;
import sun.jvm.hotspot.debugger.posix.elf.ELFSymbol;
import sun.jvm.hotspot.utilities.memo.MemoizedObject;

public class ELFFileParser {
    private static ELFFileParser elfParser;
    private static final String US_ASCII = "US-ASCII";

    public static ELFFileParser getParser() {
        if (elfParser == null) {
            elfParser = new ELFFileParser();
        }
        return elfParser;
    }

    public ELFFile parse(String filename) throws ELFException {
        try {
            RandomAccessFile file = new RandomAccessFile(filename, "r");
            return this.parse(new RandomAccessFileDataSource(file));
        }
        catch (FileNotFoundException e) {
            throw new ELFException(e);
        }
    }

    public ELFFile parse(DataSource source) throws ELFException {
        return new ELFFileImpl(source);
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage: java ELFFileParser <elf file>");
            System.exit(0);
        }
        ELFFile elfFile = ELFFileParser.getParser().parse(args[0]);
        ELFHeader elfHeader = elfFile.getHeader();
        System.out.println("ELF File: " + args[0]);
        System.out.println("ELF object size: " + (elfFile.getObjectSize() == 0 ? "Invalid Object Size" : (elfFile.getObjectSize() == 1 ? "32-bit" : "64-bit")));
        System.out.println("ELF data encoding: " + (elfFile.getEncoding() == 0 ? "Invalid Data Encoding" : (elfFile.getEncoding() == 1 ? "LSB" : "MSB")));
        short h = elfHeader.getNumberOfSectionHeaders();
        System.out.println("--> Start: reading " + h + " section headers.");
        for (int i = 0; i < elfHeader.getNumberOfSectionHeaders(); ++i) {
            ELFSectionHeader sh = elfHeader.getSectionHeader(i);
            String str = sh.getName();
            System.out.println("----> Start: Section (" + i + ") " + str);
            int num = 0;
            num = sh.getNumberOfSymbols();
            if (num != 0) {
                System.out.println("------> Start: reading " + num + " symbols.");
                for (int j = 0; j < num; ++j) {
                    ELFSymbol sym = sh.getELFSymbol(j);
                }
                System.out.println("<------ End: reading " + num + " symbols.");
            }
            if (sh.getType() == 3) {
                System.out.println("------> Start: reading string table.");
                ELFStringTable st = sh.getStringTable();
                System.out.println("<------ End: reading string table.");
            }
            if (sh.getType() == 5) {
                System.out.println("------> Start: reading hash table.");
                sh.getHashTable();
                System.out.println("<------ End: reading hash table.");
            }
            System.out.println("<---- End: Section (" + i + ") " + str);
        }
        System.out.println("<-- End: reading " + h + " section headers.");
        elfFile.close();
    }

    class ELFFileImpl
    implements ELFFile {
        private DataSource file;
        private ELFHeader header;
        private byte[] ident = new byte[16];

        ELFFileImpl(DataSource file) throws ELFException {
            this.file = file;
            int bytesRead = this.readBytes(this.ident);
            if (bytesRead != this.ident.length) {
                throw new ELFException("Error reading elf header (read " + bytesRead + "bytes, expected to " + "read " + this.ident.length + "bytes).");
            }
            if (!Arrays.equals(this.getMagicNumber(), ELF_MAGIC_NUMBER)) {
                throw new ELFException("Bad magic number for file.");
            }
            this.header = new ELFHeaderImpl();
        }

        public ELFHeader getHeader() {
            return this.header;
        }

        public byte[] getMagicNumber() {
            byte[] magicNumber = new byte[]{this.ident[0], this.ident[1], this.ident[2], this.ident[3]};
            return magicNumber;
        }

        public byte getObjectSize() {
            return this.ident[4];
        }

        public byte getEncoding() {
            return this.ident[5];
        }

        public byte getVersion() {
            return this.ident[6];
        }

        public void close() throws ELFException {
            try {
                this.file.close();
            }
            catch (IOException e) {
                throw new ELFException(e);
            }
        }

        void seek(long offset) throws ELFException {
            try {
                this.file.seek(offset);
            }
            catch (IOException e) {
                throw new ELFException(e);
            }
        }

        long getFilePointer() throws ELFException {
            try {
                return this.file.getFilePointer();
            }
            catch (IOException e) {
                throw new ELFException(e);
            }
        }

        byte readByte() throws ELFException {
            try {
                return this.file.readByte();
            }
            catch (IOException e) {
                throw new ELFException(e);
            }
        }

        int readBytes(byte[] b) throws ELFException {
            try {
                return this.file.read(b);
            }
            catch (IOException e) {
                throw new ELFException(e);
            }
        }

        short readShort() throws ELFException {
            try {
                short val;
                switch (this.ident[5]) {
                    case 1: {
                        val = this.byteSwap(this.file.readShort());
                        break;
                    }
                    case 2: {
                        val = this.file.readShort();
                        break;
                    }
                    default: {
                        throw new ELFException("Invalid encoding.");
                    }
                }
                return val;
            }
            catch (IOException e) {
                throw new ELFException(e);
            }
        }

        int readInt() throws ELFException {
            try {
                int val;
                switch (this.ident[5]) {
                    case 1: {
                        val = this.byteSwap(this.file.readInt());
                        break;
                    }
                    case 2: {
                        val = this.file.readInt();
                        break;
                    }
                    default: {
                        throw new ELFException("Invalid encoding.");
                    }
                }
                return val;
            }
            catch (IOException e) {
                throw new ELFException(e);
            }
        }

        long readLong() throws ELFException {
            try {
                long val;
                switch (this.ident[5]) {
                    case 1: {
                        val = this.byteSwap(this.file.readLong());
                        break;
                    }
                    case 2: {
                        val = this.file.readLong();
                        break;
                    }
                    default: {
                        throw new ELFException("Invalid encoding.");
                    }
                }
                return val;
            }
            catch (IOException e) {
                throw new ELFException(e);
            }
        }

        short byteSwap(short arg) {
            return (short)(arg << 8 | arg >>> 8 & 0xFF);
        }

        int byteSwap(int arg) {
            return this.byteSwap((short)arg) << 16 | this.byteSwap((short)(arg >>> 16)) & 0xFFFF;
        }

        long byteSwap(long arg) {
            return (long)this.byteSwap((int)arg) << 32 | (long)this.byteSwap((int)(arg >>> 32)) & 0xFFFFFFFFFFFFFFFFL;
        }

        short readUnsignedByte() throws ELFException {
            try {
                return this.unsignedByte(this.file.readByte());
            }
            catch (IOException e) {
                throw new ELFException(e);
            }
        }

        int readUnsignedShort() throws ELFException {
            try {
                int val;
                switch (this.ident[5]) {
                    case 1: {
                        val = this.unsignedByteSwap(this.file.readShort());
                        break;
                    }
                    case 2: {
                        val = this.unsignedByte(this.file.readShort());
                        break;
                    }
                    default: {
                        throw new ELFException("Invalid encoding.");
                    }
                }
                return val;
            }
            catch (IOException e) {
                throw new ELFException(e);
            }
        }

        long readUnsignedInt() throws ELFException {
            try {
                long val;
                switch (this.ident[5]) {
                    case 1: {
                        val = this.unsignedByteSwap(this.file.readInt());
                        break;
                    }
                    case 2: {
                        val = this.unsignedByte(this.file.readInt());
                        break;
                    }
                    default: {
                        throw new ELFException("Invalid encoding.");
                    }
                }
                return val;
            }
            catch (IOException e) {
                throw new ELFException(e);
            }
        }

        short unsignedByte(byte arg) {
            return (short)(arg & 0xFF);
        }

        int unsignedByte(short arg) {
            int val = arg >= 0 ? arg : this.unsignedByte((byte)(arg >>> 8)) << 8 | (byte)arg;
            return val;
        }

        long unsignedByte(int arg) {
            long val = arg >= 0 ? (long)arg : (long)this.unsignedByte((short)(arg >>> 16)) << 16 | (long)((short)arg);
            return val;
        }

        int unsignedByteSwap(short arg) {
            return this.unsignedByte((byte)arg) << 8 | this.unsignedByte((byte)(arg >>> 8));
        }

        long unsignedByteSwap(int arg) {
            return (long)this.unsignedByteSwap((short)arg) << 16 | (long)this.unsignedByteSwap((short)(arg >>> 16));
        }

        class ELFHashTableImpl
        implements ELFHashTable {
            private int num_buckets;
            private int num_chains;
            private int[] buckets;
            private int[] chains;

            ELFHashTableImpl(long offset, int length) throws ELFException {
                int i;
                ELFFileImpl.this.seek(offset);
                this.num_buckets = ELFFileImpl.this.readInt();
                this.num_chains = ELFFileImpl.this.readInt();
                this.buckets = new int[this.num_buckets];
                this.chains = new int[this.num_chains];
                for (i = 0; i < this.num_buckets; ++i) {
                    this.buckets[i] = ELFFileImpl.this.readInt();
                }
                for (i = 0; i < this.num_chains; ++i) {
                    this.chains[i] = ELFFileImpl.this.readInt();
                }
                int actual = this.num_buckets * 4 + this.num_chains * 4 + 8;
                if (length != actual) {
                    throw new ELFException("Error reading string table (read " + actual + "bytes, expected to " + "read " + length + "bytes).");
                }
            }

            public ELFSymbol getSymbol(String symbolName) {
                return null;
            }
        }

        class ELFStringTableImpl
        implements ELFStringTable {
            private byte[] data;
            private int numStrings;

            ELFStringTableImpl(long offset, int length) throws ELFException {
                ELFFileImpl.this.seek(offset);
                this.data = new byte[length];
                int bytesRead = ELFFileImpl.this.readBytes(this.data);
                if (bytesRead != length) {
                    throw new ELFException("Error reading string table (read " + bytesRead + "bytes, expected to " + "read " + this.data.length + "bytes).");
                }
                this.numStrings = 0;
                for (int ptr = 0; ptr < this.data.length; ++ptr) {
                    if (this.data[ptr] != 0) continue;
                    ++this.numStrings;
                }
            }

            public String get(int index) {
                int startPtr = index;
                int endPtr = index;
                while (this.data[endPtr] != 0) {
                    ++endPtr;
                }
                return new String(this.data, startPtr, endPtr - startPtr);
            }

            public int getNumStrings() {
                return this.numStrings;
            }
        }

        class ELFSymbolImpl
        implements ELFSymbol {
            private int name_ndx;
            private int value;
            private int size;
            private byte info;
            private byte other;
            private short section_header_ndx;
            private int section_type;
            private long offset;

            ELFSymbolImpl(long offset, int section_type) throws ELFException {
                ELFFileImpl.this.seek(offset);
                this.offset = offset;
                this.name_ndx = ELFFileImpl.this.readInt();
                this.value = ELFFileImpl.this.readInt();
                this.size = ELFFileImpl.this.readInt();
                this.info = ELFFileImpl.this.readByte();
                this.other = ELFFileImpl.this.readByte();
                this.section_header_ndx = ELFFileImpl.this.readShort();
                this.section_type = section_type;
                switch (this.getType()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 13: {
                        break;
                    }
                    case 15: {
                        break;
                    }
                }
            }

            public int getBinding() {
                return this.info >> 4;
            }

            public int getType() {
                return this.info & 0xF;
            }

            public long getOffset() {
                return this.offset;
            }

            public String getName() {
                if (this.name_ndx == 0) {
                    return null;
                }
                String symbol_name = null;
                if (this.section_type == 2) {
                    symbol_name = ELFFileImpl.this.getHeader().getStringTable().get(this.name_ndx);
                } else if (this.section_type == 11) {
                    symbol_name = ELFFileImpl.this.getHeader().getDynamicStringTable().get(this.name_ndx);
                }
                return symbol_name;
            }

            public long getValue() {
                return this.value;
            }

            public int getSize() {
                return this.size;
            }
        }

        class ELFSectionHeaderImpl
        implements ELFSectionHeader {
            private int name_ndx;
            private int type;
            private int flags;
            private int address;
            private int section_offset;
            private int size;
            private int link;
            private int info;
            private int address_alignment;
            private int entry_size;
            private MemoizedObject[] symbols;
            private MemoizedObject stringTable;
            private MemoizedObject hashTable;

            ELFSectionHeaderImpl(long offset) throws ELFException {
                ELFFileImpl.this.seek(offset);
                this.name_ndx = ELFFileImpl.this.readInt();
                this.type = ELFFileImpl.this.readInt();
                this.flags = ELFFileImpl.this.readInt();
                this.address = ELFFileImpl.this.readInt();
                this.section_offset = ELFFileImpl.this.readInt();
                this.size = ELFFileImpl.this.readInt();
                this.link = ELFFileImpl.this.readInt();
                this.info = ELFFileImpl.this.readInt();
                this.address_alignment = ELFFileImpl.this.readInt();
                this.entry_size = ELFFileImpl.this.readInt();
                switch (this.type) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: 
                    case 11: {
                        int num_entries = this.size / this.entry_size;
                        this.symbols = new MemoizedObject[num_entries];
                        for (int i = 0; i < num_entries; ++i) {
                            int symbolOffset = this.section_offset + i * this.entry_size;
                            this.symbols[i] = new MemoizedObject(this, ELFFileImpl.this, symbolOffset){
                                private final /* synthetic */ ELFFileImpl val$this$1;
                                private final /* synthetic */ int val$symbolOffset;
                                private final /* synthetic */ ELFSectionHeaderImpl this$2;
                                {
                                    this.this$2 = this$2;
                                    this.val$this$1 = val$this$1;
                                    this.val$symbolOffset = val$symbolOffset;
                                }

                                public Object computeValue() {
                                    return ELFSectionHeaderImpl.access$200(this.this$2).new ELFSymbolImpl(this.val$symbolOffset, ELFSectionHeaderImpl.access$100(this.this$2));
                                }
                            };
                        }
                        break;
                    }
                    case 3: {
                        int strTableOffset = this.section_offset;
                        int strTableSize = this.size;
                        this.stringTable = new MemoizedObject(this, ELFFileImpl.this, strTableOffset, strTableSize){
                            private final /* synthetic */ ELFFileImpl val$this$1;
                            private final /* synthetic */ int val$strTableOffset;
                            private final /* synthetic */ int val$strTableSize;
                            private final /* synthetic */ ELFSectionHeaderImpl this$2;
                            {
                                this.this$2 = this$2;
                                this.val$this$1 = val$this$1;
                                this.val$strTableOffset = val$strTableOffset;
                                this.val$strTableSize = val$strTableSize;
                            }

                            public Object computeValue() {
                                return ELFSectionHeaderImpl.access$200(this.this$2).new ELFStringTableImpl(this.val$strTableOffset, this.val$strTableSize);
                            }
                        };
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 5: {
                        int hashTableOffset = this.section_offset;
                        int hashTableSize = this.size;
                        this.hashTable = new MemoizedObject(this, ELFFileImpl.this, hashTableOffset, hashTableSize){
                            private final /* synthetic */ ELFFileImpl val$this$1;
                            private final /* synthetic */ int val$hashTableOffset;
                            private final /* synthetic */ int val$hashTableSize;
                            private final /* synthetic */ ELFSectionHeaderImpl this$2;
                            {
                                this.this$2 = this$2;
                                this.val$this$1 = val$this$1;
                                this.val$hashTableOffset = val$hashTableOffset;
                                this.val$hashTableSize = val$hashTableSize;
                            }

                            public Object computeValue() {
                                return ELFSectionHeaderImpl.access$200(this.this$2).new ELFHashTableImpl(this.val$hashTableOffset, this.val$hashTableSize);
                            }
                        };
                        break;
                    }
                    case 6: {
                        break;
                    }
                    case 7: {
                        break;
                    }
                    case 8: {
                        break;
                    }
                    case 9: {
                        break;
                    }
                    case 10: {
                        break;
                    }
                }
            }

            public int getType() {
                return this.type;
            }

            public int getNumberOfSymbols() {
                if (this.symbols != null) {
                    return this.symbols.length;
                }
                return 0;
            }

            public ELFSymbol getELFSymbol(int index) {
                return (ELFSymbol)this.symbols[index].getValue();
            }

            public ELFStringTable getStringTable() {
                if (this.stringTable != null) {
                    return (ELFStringTable)this.stringTable.getValue();
                }
                return null;
            }

            public ELFHashTable getHashTable() {
                if (this.hashTable != null) {
                    return (ELFHashTable)this.hashTable.getValue();
                }
                return null;
            }

            public String getName() {
                if (this.name_ndx == 0) {
                    return null;
                }
                ELFStringTable tbl = ELFFileImpl.this.getHeader().getSectionHeaderStringTable();
                return tbl.get(this.name_ndx);
            }

            public int getLink() {
                return this.link;
            }

            public int getOffset() {
                return this.section_offset;
            }

            static /* synthetic */ int access$100(ELFSectionHeaderImpl x0) {
                return x0.type;
            }

            static /* synthetic */ ELFFileImpl access$200(ELFSectionHeaderImpl x0) {
                return x0.ELFFileImpl.this;
            }
        }

        class ELFHeaderImpl
        implements ELFHeader {
            private byte[] ident = new byte[16];
            private short file_type;
            private short arch;
            private int version;
            private int entry_point;
            private int ph_offset;
            private int sh_offset;
            private int flags;
            private short eh_size;
            private short ph_entry_size;
            private short num_ph;
            private short sh_entry_size;
            private short num_sh;
            private short sh_string_ndx;
            private MemoizedObject[] sectionHeaders;
            private MemoizedObject[] programHeaders;
            private ELFSectionHeader symbolTableSection;
            private ELFSectionHeader dynamicSymbolTableSection;
            private ELFHashTable hashTable;

            ELFHeaderImpl() throws ELFException {
                this.file_type = ELFFileImpl.this.readShort();
                this.arch = ELFFileImpl.this.readShort();
                this.version = ELFFileImpl.this.readInt();
                this.entry_point = ELFFileImpl.this.readInt();
                this.ph_offset = ELFFileImpl.this.readInt();
                this.sh_offset = ELFFileImpl.this.readInt();
                this.flags = ELFFileImpl.this.readInt();
                this.eh_size = ELFFileImpl.this.readShort();
                this.ph_entry_size = ELFFileImpl.this.readShort();
                this.num_ph = ELFFileImpl.this.readShort();
                this.sh_entry_size = ELFFileImpl.this.readShort();
                this.num_sh = ELFFileImpl.this.readShort();
                this.sh_string_ndx = ELFFileImpl.this.readShort();
                this.sectionHeaders = new MemoizedObject[this.num_sh];
                for (int i = 0; i < this.num_sh; ++i) {
                    long sectionHeaderOffset = this.sh_offset + i * this.sh_entry_size;
                    this.sectionHeaders[i] = new MemoizedObject(this, ELFFileImpl.this, sectionHeaderOffset){
                        private final /* synthetic */ ELFFileImpl val$this$1;
                        private final /* synthetic */ long val$sectionHeaderOffset;
                        private final /* synthetic */ ELFHeaderImpl this$2;
                        {
                            this.this$2 = this$2;
                            this.val$this$1 = val$this$1;
                            this.val$sectionHeaderOffset = val$sectionHeaderOffset;
                        }

                        public Object computeValue() {
                            return ELFHeaderImpl.access$000(this.this$2).new ELFSectionHeaderImpl(this.val$sectionHeaderOffset);
                        }
                    };
                }
            }

            public short getFileType() {
                return this.file_type;
            }

            public short getArch() {
                return this.arch;
            }

            public short getSectionHeaderSize() {
                return this.sh_entry_size;
            }

            public short getNumberOfSectionHeaders() {
                return this.num_sh;
            }

            public ELFSectionHeader getSectionHeader(int index) {
                return (ELFSectionHeader)this.sectionHeaders[index].getValue();
            }

            public ELFStringTable getSectionHeaderStringTable() {
                return this.getSectionHeader(this.sh_string_ndx).getStringTable();
            }

            public ELFStringTable getStringTable() {
                return this.findStringTableWithName(".strtab");
            }

            public ELFStringTable getDynamicStringTable() {
                return this.findStringTableWithName(".dynstr");
            }

            private ELFStringTable findStringTableWithName(String tableName) {
                ELFSectionHeader sh = null;
                for (int i = 1; i < this.getNumberOfSectionHeaders(); ++i) {
                    sh = this.getSectionHeader(i);
                    if (!tableName.equals(sh.getName())) continue;
                    return sh.getStringTable();
                }
                return null;
            }

            public ELFHashTable getHashTable() {
                return null;
            }

            public ELFSectionHeader getSymbolTableSection() {
                if (this.symbolTableSection != null) {
                    return this.symbolTableSection;
                }
                this.symbolTableSection = this.getSymbolTableSection(2);
                return this.symbolTableSection;
            }

            public ELFSectionHeader getDynamicSymbolTableSection() {
                if (this.dynamicSymbolTableSection != null) {
                    return this.dynamicSymbolTableSection;
                }
                this.dynamicSymbolTableSection = this.getSymbolTableSection(11);
                return this.dynamicSymbolTableSection;
            }

            private ELFSectionHeader getSymbolTableSection(int type) {
                ELFSectionHeader sh = null;
                for (int i = 1; i < this.getNumberOfSectionHeaders(); ++i) {
                    sh = this.getSectionHeader(i);
                    if (sh.getType() != type) continue;
                    this.dynamicSymbolTableSection = sh;
                    return sh;
                }
                return null;
            }

            public ELFSymbol getELFSymbol(String symbolName) {
                int i;
                if (symbolName == null) {
                    return null;
                }
                ELFSymbol symbol = null;
                int numSymbols = 0;
                ELFSectionHeader sh = this.getDynamicSymbolTableSection();
                if (sh != null) {
                    numSymbols = sh.getNumberOfSymbols();
                    i = 0;
                    while ((double)i < Math.ceil(numSymbols / 2)) {
                        symbol = sh.getELFSymbol(i);
                        if (symbolName.equals(symbol.getName())) {
                            return symbol;
                        }
                        symbol = sh.getELFSymbol(numSymbols - 1 - i);
                        if (symbolName.equals(symbol.getName())) {
                            return symbol;
                        }
                        ++i;
                    }
                }
                if ((sh = this.getSymbolTableSection()) != null) {
                    numSymbols = sh.getNumberOfSymbols();
                    i = 0;
                    while ((double)i < Math.ceil(numSymbols / 2)) {
                        symbol = sh.getELFSymbol(i);
                        if (symbolName.equals(symbol.getName())) {
                            return symbol;
                        }
                        symbol = sh.getELFSymbol(numSymbols - 1 - i);
                        if (symbolName.equals(symbol.getName())) {
                            return symbol;
                        }
                        ++i;
                    }
                }
                return null;
            }

            public ELFSymbol getELFSymbol(long address) {
                int i;
                ELFSymbol symbol = null;
                int numSymbols = 0;
                long value = 0L;
                ELFSectionHeader sh = this.getDynamicSymbolTableSection();
                if (sh != null) {
                    numSymbols = sh.getNumberOfSymbols();
                    for (i = 0; i < numSymbols; ++i) {
                        symbol = sh.getELFSymbol(i);
                        value = symbol.getValue();
                        if (address < value || address >= value + (long)symbol.getSize()) continue;
                        return symbol;
                    }
                }
                if ((sh = this.getSymbolTableSection()) != null) {
                    numSymbols = sh.getNumberOfSymbols();
                    for (i = 0; i < numSymbols; ++i) {
                        symbol = sh.getELFSymbol(i);
                        value = symbol.getValue();
                        if (address < value || address >= value + (long)symbol.getSize()) continue;
                        return symbol;
                    }
                }
                return null;
            }

            static /* synthetic */ ELFFileImpl access$000(ELFHeaderImpl x0) {
                return x0.ELFFileImpl.this;
            }
        }
    }
}

