/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.win32;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.DebuggerBase;
import sun.jvm.hotspot.debugger.DebuggerException;
import sun.jvm.hotspot.debugger.DebuggerUtilities;
import sun.jvm.hotspot.debugger.InputLexer;
import sun.jvm.hotspot.debugger.MachineDescription;
import sun.jvm.hotspot.debugger.NotInHeapException;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.debugger.PageCache;
import sun.jvm.hotspot.debugger.ProcessInfo;
import sun.jvm.hotspot.debugger.ReadResult;
import sun.jvm.hotspot.debugger.ThreadProxy;
import sun.jvm.hotspot.debugger.UnalignedAddressException;
import sun.jvm.hotspot.debugger.UnmappedAddressException;
import sun.jvm.hotspot.debugger.cdbg.CDebugger;
import sun.jvm.hotspot.debugger.cdbg.DebugEvent;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicDebugEvent;
import sun.jvm.hotspot.debugger.win32.DLL;
import sun.jvm.hotspot.debugger.win32.Win32Address;
import sun.jvm.hotspot.debugger.win32.Win32CDebugger;
import sun.jvm.hotspot.debugger.win32.Win32Debugger;
import sun.jvm.hotspot.debugger.win32.Win32LDTEntry;
import sun.jvm.hotspot.debugger.win32.Win32OopHandle;
import sun.jvm.hotspot.debugger.win32.Win32Thread;
import sun.jvm.hotspot.debugger.x86.X86ThreadContext;
import sun.jvm.hotspot.utilities.AddressOps;
import sun.jvm.hotspot.utilities.Assert;
import sun.jvm.hotspot.utilities.PlatformInfo;

public class Win32DebuggerLocal
extends DebuggerBase
implements Win32Debugger {
    private Socket debuggerSocket;
    private boolean attached;
    private long pid;
    private PrintWriter out;
    private DataOutputStream rawOut;
    private InputLexer in;
    private static final int PORT = 27000;
    private PageCache cache;
    private static final long SHORT_TIMEOUT = 2000L;
    private static final long LONG_TIMEOUT = 20000L;
    private Map nameToDllMap;
    private List loadObjects;
    private CDebugger cdbg;
    private boolean suspended;
    private Map breakpoints;
    private DebugEvent curDebugEvent;
    private static final int EXCEPTION_DEBUG_EVENT = 1;
    private static final int LOAD_DLL_DEBUG_EVENT = 6;
    private static final int UNLOAD_DLL_DEBUG_EVENT = 7;
    private static final int EXCEPTION_ACCESS_VIOLATION = -1073741819;
    private static final int EXCEPTION_BREAKPOINT = -2147483645;
    private static final int EXCEPTION_SINGLE_STEP = -2147483644;

    public Win32DebuggerLocal(MachineDescription machDesc, boolean useCache) throws DebuggerException {
        this.machDesc = machDesc;
        this.utils = new DebuggerUtilities(machDesc.getAddressSize(), machDesc.isBigEndian());
        if (useCache) {
            this.initCache(4096L, this.parseCacheNumPagesProperty(4096));
        }
        try {
            this.connectToDebugServer();
        }
        catch (IOException e) {
            throw new DebuggerException(e);
        }
    }

    public boolean hasProcessList() throws DebuggerException {
        return true;
    }

    public List getProcessList() throws DebuggerException {
        ArrayList<ProcessInfo> processes = new ArrayList<ProcessInfo>();
        try {
            this.printlnToOutput("proclist");
            int num = this.in.parseInt();
            for (int i = 0; i < num; ++i) {
                int pid = this.in.parseInt();
                String name = this.parseString();
                if (name.equals("")) {
                    name = "System Idle Process";
                }
                processes.add(new ProcessInfo(name, pid));
            }
            return processes;
        }
        catch (IOException e) {
            throw new DebuggerException(e);
        }
    }

    public synchronized void attach(int processID) throws DebuggerException {
        if (this.attached) {
            throw new DebuggerException("Already attached to process " + this.pid);
        }
        try {
            this.printlnToOutput("attach " + processID);
            if (!this.in.parseBoolean()) {
                throw new DebuggerException("Error attaching to process, or no such process");
            }
            this.attached = true;
            this.pid = processID;
            this.suspended = true;
            this.breakpoints = new HashMap();
            this.curDebugEvent = null;
            this.nameToDllMap = null;
            this.loadObjects = null;
        }
        catch (IOException e) {
            throw new DebuggerException(e);
        }
    }

    public synchronized void attach(String executableName, String coreFileName) throws DebuggerException {
        throw new DebuggerException("Core files not yet supported on Win32");
    }

    public synchronized boolean detach() {
        if (!this.attached) {
            return false;
        }
        this.attached = false;
        this.suspended = false;
        this.breakpoints = null;
        if (this.nameToDllMap != null) {
            Iterator iter = this.nameToDllMap.values().iterator();
            while (iter.hasNext()) {
                DLL dll = (DLL)iter.next();
                dll.close();
            }
            this.nameToDllMap = null;
            this.loadObjects = null;
        }
        this.cdbg = null;
        this.clearCache();
        try {
            this.printlnToOutput("detach");
            return this.in.parseBoolean();
        }
        catch (IOException e) {
            throw new DebuggerException(e);
        }
    }

    public Address parseAddress(String addressString) throws NumberFormatException {
        return this.newAddress(this.utils.scanAddress(addressString));
    }

    public String getOS() {
        return PlatformInfo.getOS();
    }

    public String getCPU() {
        return PlatformInfo.getCPU();
    }

    public boolean hasConsole() throws DebuggerException {
        return false;
    }

    public String consoleExecuteCommand(String cmd) throws DebuggerException {
        throw new DebuggerException("No debugger console available on Win32");
    }

    public String getConsolePrompt() throws DebuggerException {
        return null;
    }

    public CDebugger getCDebugger() throws DebuggerException {
        if (this.cdbg == null) {
            this.cdbg = new Win32CDebugger(this);
        }
        return this.cdbg;
    }

    public synchronized Address lookup(String objectName, String symbol) {
        if (!this.attached) {
            return null;
        }
        return this.newAddress(this.lookupInProcess(objectName, symbol));
    }

    public synchronized OopHandle lookupOop(String objectName, String symbol) {
        Address addr = this.lookup(objectName, symbol);
        if (addr == null) {
            return null;
        }
        return addr.addOffsetToAsOopHandle(0L);
    }

    public MachineDescription getMachineDescription() {
        return this.machDesc;
    }

    public ThreadProxy getThreadForIdentifierAddress(Address addr) {
        return new Win32Thread((Win32Debugger)this, addr);
    }

    public ThreadProxy getThreadForThreadId(long handle) {
        return new Win32Thread((Win32Debugger)this, handle);
    }

    public long readJLong(long address) throws UnmappedAddressException, UnalignedAddressException {
        this.checkJavaConfigured();
        this.utils.checkAlignment(address, this.jintSize);
        byte[] data = this.readBytes(address, this.jlongSize);
        return this.utils.dataToJLong(data, this.jlongSize);
    }

    public String addressValueToString(long address) {
        return this.utils.addressValueToString(address);
    }

    public Win32Address readAddress(long address) throws UnmappedAddressException, UnalignedAddressException {
        return (Win32Address)this.newAddress(this.readAddressValue(address));
    }

    public Win32OopHandle readOopHandle(long address) throws UnmappedAddressException, UnalignedAddressException, NotInHeapException {
        long value = this.readAddressValue(address);
        return value == 0L ? null : new Win32OopHandle(this, value);
    }

    public void writeAddress(long address, Win32Address value) {
        this.writeAddressValue(address, this.getAddressValue(value));
    }

    public void writeOopHandle(long address, Win32OopHandle value) {
        this.writeAddressValue(address, this.getAddressValue(value));
    }

    public synchronized long[] getThreadIntegerRegisterSet(int threadHandleValue, boolean mustDuplicateHandle) throws DebuggerException {
        if (!this.suspended) {
            throw new DebuggerException("Process not suspended");
        }
        try {
            int handle = threadHandleValue;
            if (mustDuplicateHandle) {
                this.printlnToOutput("duphandle 0x" + Integer.toHexString(threadHandleValue));
                if (!this.in.parseBoolean()) {
                    throw new DebuggerException("Error duplicating thread handle 0x" + threadHandleValue);
                }
                handle = (int)this.in.parseAddress();
            }
            this.printlnToOutput("getcontext 0x" + Integer.toHexString(handle));
            if (!this.in.parseBoolean()) {
                if (mustDuplicateHandle) {
                    this.printlnToOutput("closehandle 0x" + Integer.toHexString(handle));
                }
                String failMessage = "GetThreadContext failed for thread handle 0x" + Integer.toHexString(handle);
                if (mustDuplicateHandle) {
                    failMessage = failMessage + ", duplicated from thread handle " + Integer.toHexString(threadHandleValue);
                }
                throw new DebuggerException(failMessage);
            }
            int numRegs = 22;
            long[] winRegs = new long[numRegs];
            for (int i = 0; i < numRegs; ++i) {
                winRegs[i] = this.in.parseAddress();
            }
            if (mustDuplicateHandle) {
                this.printlnToOutput("closehandle 0x" + Integer.toHexString(handle));
            }
            long[] retval = new long[25];
            retval[11] = winRegs[0];
            retval[8] = winRegs[1];
            retval[10] = winRegs[2];
            retval[9] = winRegs[3];
            retval[5] = winRegs[4];
            retval[4] = winRegs[5];
            retval[6] = winRegs[6];
            retval[7] = winRegs[7];
            retval[14] = winRegs[8];
            retval[3] = winRegs[9];
            retval[2] = winRegs[10];
            retval[1] = winRegs[11];
            retval[0] = winRegs[12];
            retval[15] = winRegs[13];
            retval[18] = winRegs[14];
            retval[16] = winRegs[15];
            retval[19] = winRegs[16];
            retval[20] = winRegs[17];
            retval[21] = winRegs[18];
            retval[22] = winRegs[19];
            retval[23] = winRegs[20];
            retval[24] = winRegs[21];
            return retval;
        }
        catch (IOException e) {
            throw new DebuggerException(e);
        }
    }

    public synchronized void setThreadIntegerRegisterSet(int threadHandleValue, boolean mustDuplicateHandle, long[] context) throws DebuggerException {
        if (!this.suspended) {
            throw new DebuggerException("Process not suspended");
        }
        try {
            int handle = threadHandleValue;
            if (mustDuplicateHandle) {
                this.printlnToOutput("duphandle 0x" + Integer.toHexString(threadHandleValue));
                if (!this.in.parseBoolean()) {
                    throw new DebuggerException("Error duplicating thread handle 0x" + threadHandleValue);
                }
                handle = (int)this.in.parseAddress();
            }
            long[] winRegs = new long[context.length];
            winRegs[0] = context[11];
            winRegs[1] = context[8];
            winRegs[2] = context[10];
            winRegs[3] = context[9];
            winRegs[4] = context[5];
            winRegs[5] = context[4];
            winRegs[6] = context[6];
            winRegs[7] = context[7];
            winRegs[8] = context[14];
            winRegs[9] = context[3];
            winRegs[10] = context[2];
            winRegs[11] = context[1];
            winRegs[12] = context[0];
            winRegs[13] = context[15];
            winRegs[14] = context[18];
            winRegs[15] = context[16];
            winRegs[16] = context[19];
            winRegs[17] = context[20];
            winRegs[18] = context[21];
            winRegs[19] = context[22];
            winRegs[20] = context[23];
            winRegs[21] = context[24];
            StringBuffer cmd = new StringBuffer();
            cmd.append("setcontext 0x");
            cmd.append(Integer.toHexString(threadHandleValue));
            for (int i = 0; i < context.length; ++i) {
                cmd.append(" 0x");
                cmd.append(Long.toHexString(winRegs[i]));
            }
            this.printlnToOutput(cmd.toString());
            boolean res = this.in.parseBoolean();
            if (mustDuplicateHandle) {
                this.printlnToOutput("closehandle 0x" + Integer.toHexString(handle));
            }
            if (!res) {
                String failMessage = "SetThreadContext failed for thread handle 0x" + Integer.toHexString(handle);
                if (mustDuplicateHandle) {
                    failMessage = failMessage + ", duplicated from thread handle " + Integer.toHexString(threadHandleValue);
                }
                throw new DebuggerException(failMessage);
            }
        }
        catch (IOException e) {
            throw new DebuggerException(e);
        }
    }

    public synchronized Win32LDTEntry getThreadSelectorEntry(int threadHandleValue, boolean mustDuplicateHandle, int selector) throws DebuggerException {
        try {
            int handle = threadHandleValue;
            if (mustDuplicateHandle) {
                this.printlnToOutput("duphandle 0x" + Integer.toHexString(threadHandleValue));
                if (!this.in.parseBoolean()) {
                    throw new DebuggerException("Error duplicating thread handle 0x" + threadHandleValue);
                }
                handle = (int)this.in.parseAddress();
            }
            this.printlnToOutput("selectorentry 0x" + Integer.toHexString(handle) + " " + selector);
            if (!this.in.parseBoolean()) {
                if (mustDuplicateHandle) {
                    this.printlnToOutput("closehandle 0x" + Integer.toHexString(handle));
                }
                throw new DebuggerException("GetThreadContext failed for thread handle 0x" + handle + ", duplicated from thread handle " + threadHandleValue);
            }
            short limitLow = (short)this.in.parseAddress();
            short baseLow = (short)this.in.parseAddress();
            byte baseMid = (byte)this.in.parseAddress();
            byte flags1 = (byte)this.in.parseAddress();
            byte flags2 = (byte)this.in.parseAddress();
            byte baseHi = (byte)this.in.parseAddress();
            return new Win32LDTEntry(limitLow, baseLow, baseMid, flags1, flags2, baseHi);
        }
        catch (IOException e) {
            throw new DebuggerException(e);
        }
    }

    public synchronized List getThreadList() throws DebuggerException {
        if (!this.suspended) {
            throw new DebuggerException("Process not suspended");
        }
        try {
            this.printlnToOutput("threadlist");
            ArrayList<Win32Thread> ret = new ArrayList<Win32Thread>();
            int numThreads = this.in.parseInt();
            for (int i = 0; i < numThreads; ++i) {
                int handle = (int)this.in.parseAddress();
                ret.add(new Win32Thread((Win32Debugger)this, handle));
            }
            return ret;
        }
        catch (IOException e) {
            throw new DebuggerException(e);
        }
    }

    public synchronized List getLoadObjectList() throws DebuggerException {
        if (!this.suspended) {
            throw new DebuggerException("Process not suspended");
        }
        try {
            if (this.loadObjects == null) {
                this.loadObjects = new ArrayList();
                this.nameToDllMap = new HashMap();
                this.printlnToOutput("libinfo");
                int numInfo = this.in.parseInt();
                for (int i = 0; i < numInfo; ++i) {
                    String fullPathName = this.parseString().toLowerCase();
                    Address base = this.newAddress(this.in.parseAddress());
                    File file = new File(fullPathName);
                    long size = file.length();
                    DLL dll = new DLL(this, fullPathName, size, base);
                    String name = file.getName();
                    this.nameToDllMap.put(name, dll);
                    this.loadObjects.add(dll);
                }
            }
        }
        catch (IOException e) {
            throw new DebuggerException(e);
        }
        return this.loadObjects;
    }

    public synchronized void writeBytesToProcess(long startAddress, long numBytes, byte[] data) throws UnmappedAddressException, DebuggerException {
        try {
            this.printToOutput("poke 0x" + Long.toHexString(startAddress) + " |");
            this.writeIntToOutput((int)numBytes);
            this.writeToOutput(data, 0, (int)numBytes);
            this.printlnToOutput("");
            if (!this.in.parseBoolean()) {
                throw new UnmappedAddressException(startAddress);
            }
        }
        catch (IOException e) {
            throw new DebuggerException(e);
        }
    }

    public synchronized void suspend() throws DebuggerException {
        try {
            if (this.suspended) {
                throw new DebuggerException("Process already suspended");
            }
            this.printlnToOutput("suspend");
            this.suspended = true;
            this.enableCache();
            this.reresolveLoadObjects();
        }
        catch (IOException e) {
            throw new DebuggerException(e);
        }
    }

    public synchronized void resume() throws DebuggerException {
        try {
            if (!this.suspended) {
                throw new DebuggerException("Process not suspended");
            }
            this.disableCache();
            this.printlnToOutput("resume");
            this.suspended = false;
        }
        catch (IOException e) {
            throw new DebuggerException(e);
        }
    }

    public synchronized boolean isSuspended() throws DebuggerException {
        return this.suspended;
    }

    public synchronized void setBreakpoint(Address addr) throws DebuggerException {
        if (!this.suspended) {
            throw new DebuggerException("Process not suspended");
        }
        long addrVal = this.getAddressValue(addr);
        Long where = new Long(addrVal);
        if (this.breakpoints.get(where) != null) {
            throw new DebuggerException("Breakpoint already set at " + addr);
        }
        Byte what = new Byte(this.readBytes(addrVal, 1L)[0]);
        this.writeBytesToProcess(addrVal, 1L, new byte[]{-52});
        this.breakpoints.put(where, what);
    }

    public synchronized void clearBreakpoint(Address addr) throws DebuggerException {
        if (!this.suspended) {
            throw new DebuggerException("Process not suspended");
        }
        long addrVal = this.getAddressValue(addr);
        Long where = new Long(addrVal);
        Byte what = (Byte)this.breakpoints.get(where);
        if (what == null) {
            throw new DebuggerException("Breakpoint not set at " + addr);
        }
        this.writeBytesToProcess(addrVal, 1L, new byte[]{what});
        this.breakpoints.remove(where);
    }

    public synchronized boolean isBreakpointSet(Address addr) throws DebuggerException {
        return this.breakpoints.get(new Long(this.getAddressValue(addr))) != null;
    }

    public synchronized DebugEvent debugEventPoll() throws DebuggerException {
        if (this.curDebugEvent != null) {
            return this.curDebugEvent;
        }
        try {
            this.printlnToOutput("pollevent");
            if (!this.in.parseBoolean()) {
                return null;
            }
            int handle = (int)this.in.parseAddress();
            Win32Thread thread = new Win32Thread((Win32Debugger)this, handle);
            int code = this.in.parseInt();
            BasicDebugEvent ev = null;
            block1 : switch (code) {
                case 6: {
                    Address addr = this.newAddress(this.in.parseAddress());
                    ev = BasicDebugEvent.newLoadObjectLoadEvent(thread, addr);
                    break;
                }
                case 7: {
                    Address addr = this.newAddress(this.in.parseAddress());
                    ev = BasicDebugEvent.newLoadObjectUnloadEvent(thread, addr);
                    break;
                }
                case 1: {
                    int exceptionCode = this.in.parseInt();
                    Address pc = this.newAddress(this.in.parseAddress());
                    switch (exceptionCode) {
                        case -1073741819: {
                            boolean wasWrite = this.in.parseBoolean();
                            Address addr = this.newAddress(this.in.parseAddress());
                            ev = BasicDebugEvent.newAccessViolationEvent(thread, pc, wasWrite, addr);
                            break block1;
                        }
                        case -2147483645: {
                            ev = BasicDebugEvent.newBreakpointEvent(thread, pc);
                            break block1;
                        }
                        case -2147483644: {
                            ev = BasicDebugEvent.newSingleStepEvent(thread, pc);
                            break block1;
                        }
                    }
                    ev = BasicDebugEvent.newUnknownEvent(thread, "Exception 0x" + Integer.toHexString(exceptionCode) + " at PC " + pc);
                    break;
                }
                default: {
                    ev = BasicDebugEvent.newUnknownEvent(thread, "Debug event " + code + " occurred");
                }
            }
            Assert.that(ev != null, "Must have created event");
            this.curDebugEvent = ev;
        }
        catch (IOException e) {
            throw new DebuggerException(e);
        }
        return this.curDebugEvent;
    }

    public synchronized void debugEventContinue() throws DebuggerException {
        if (this.curDebugEvent == null) {
            throw new DebuggerException("No debug event pending");
        }
        try {
            DebugEvent.Type t = this.curDebugEvent.getType();
            boolean shouldPassOn = true;
            if (t == DebugEvent.Type.BREAKPOINT) {
                if (this.breakpoints.get(new Long(this.getAddressValue(this.curDebugEvent.getPC()))) != null) {
                    System.err.println("Backing up PC due to breakpoint");
                    X86ThreadContext ctx = (X86ThreadContext)this.curDebugEvent.getThread().getContext();
                    ctx.setRegister(14, ctx.getRegister(14) - 1L);
                    this.curDebugEvent.getThread().setContext(ctx);
                } else {
                    System.err.println("Skipping back up of PC since I didn't know about this breakpoint");
                    System.err.println("Known breakpoints:");
                    Iterator iter = this.breakpoints.keySet().iterator();
                    while (iter.hasNext()) {
                        System.err.println("  0x" + Long.toHexString((Long)iter.next()));
                    }
                }
                shouldPassOn = false;
            } else if (t == DebugEvent.Type.SINGLE_STEP) {
                shouldPassOn = false;
            }
            int val = shouldPassOn ? 1 : 0;
            this.printlnToOutput("continueevent " + val);
            if (!this.in.parseBoolean()) {
                throw new DebuggerException("Unknown error while attempting to continue past debug event");
            }
            this.curDebugEvent = null;
        }
        catch (IOException e) {
            throw new DebuggerException(e);
        }
    }

    public long getAddressValue(Address addr) {
        if (addr == null) {
            return 0L;
        }
        return ((Win32Address)addr).getValue();
    }

    public Address newAddress(long value) {
        if (value == 0L) {
            return null;
        }
        return new Win32Address(this, value);
    }

    private String parseString() throws IOException {
        int charSize = this.in.parseInt();
        int numChars = this.in.parseInt();
        this.in.skipByte();
        String str = charSize == 1 ? this.in.readByteString(numChars) : this.in.readCharString(numChars);
        return str;
    }

    synchronized long lookupInProcess(String objectName, String symbol) {
        Win32Address addr;
        DLL dll;
        if (this.nameToDllMap == null) {
            this.getLoadObjectList();
        }
        if ((dll = (DLL)this.nameToDllMap.get(objectName)) != null && (addr = (Win32Address)dll.lookupSymbol(symbol)) != null) {
            return addr.getValue();
        }
        return 0L;
    }

    public synchronized ReadResult readBytesFromProcess(long address, long numBytes) throws UnmappedAddressException, DebuggerException {
        try {
            String cmd = "peek " + this.utils.addressValueToString(address) + " " + numBytes;
            this.printlnToOutput(cmd);
            while (this.in.readByte() != 66) {
            }
            byte res = this.in.readByte();
            if (res == 0) {
                System.err.println("Failing command: " + cmd);
                throw new DebuggerException("Read of remote process address space failed");
            }
            byte[] buf = new byte[(int)numBytes];
            boolean bailOut = false;
            long failureAddress = 0L;
            while (numBytes > 0L) {
                boolean isMapped;
                long len = this.in.readUnsignedInt();
                boolean bl = isMapped = this.in.readByte() != 0;
                if (!isMapped) {
                    if (!bailOut) {
                        bailOut = true;
                        failureAddress = address;
                    }
                } else {
                    this.in.readBytes(buf, 0, (int)len);
                }
                numBytes -= len;
                address += len;
            }
            Assert.that(numBytes == 0L, "Bug in debug server's implementation of peek");
            if (bailOut) {
                return new ReadResult(failureAddress);
            }
            return new ReadResult(buf);
        }
        catch (IOException e) {
            throw new DebuggerException(e);
        }
    }

    private void printlnToOutput(String s) throws IOException {
        this.out.println(s);
        if (this.out.checkError()) {
            throw new IOException("Error occurred while writing to debug server");
        }
    }

    private void printToOutput(String s) throws IOException {
        this.out.print(s);
        if (this.out.checkError()) {
            throw new IOException("Error occurred while writing to debug server");
        }
    }

    private void writeIntToOutput(int val) throws IOException {
        this.rawOut.writeInt(val);
        this.rawOut.flush();
    }

    private void writeToOutput(byte[] buf, int off, int len) throws IOException {
        this.rawOut.write(buf, off, len);
        this.rawOut.flush();
    }

    private void connectToDebugServer() throws IOException {
        this.debuggerSocket = null;
        long endTime = System.currentTimeMillis() + 2000L;
        while (this.debuggerSocket == null && System.currentTimeMillis() < endTime) {
            try {
                this.debuggerSocket = new Socket(InetAddress.getByName("127.0.0.1"), 27000);
                this.debuggerSocket.setTcpNoDelay(true);
            }
            catch (IOException e) {
                this.debuggerSocket = null;
                try {
                    Thread.sleep(750L);
                }
                catch (InterruptedException ex) {}
            }
        }
        if (this.debuggerSocket == null) {
            throw new DebuggerException("Timed out while attempting to connect to debug server (please start SwDbgSrv.exe)");
        }
        this.out = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(this.debuggerSocket.getOutputStream(), "US-ASCII")), true);
        this.rawOut = new DataOutputStream(new BufferedOutputStream(this.debuggerSocket.getOutputStream()));
        this.in = new InputLexer(new BufferedInputStream(this.debuggerSocket.getInputStream()));
    }

    private DLL findDLLByName(String fullPathName) {
        Iterator iter = this.loadObjects.iterator();
        while (iter.hasNext()) {
            DLL dll = (DLL)iter.next();
            if (!dll.getName().equals(fullPathName)) continue;
            return dll;
        }
        return null;
    }

    private void reresolveLoadObjects() throws DebuggerException {
        try {
            if (this.loadObjects == null) {
                return;
            }
            ArrayList<DLL> newLoadObjects = new ArrayList<DLL>();
            this.printlnToOutput("libinfo");
            int numInfo = this.in.parseInt();
            for (int i = 0; i < numInfo; ++i) {
                String fullPathName = this.parseString().toLowerCase();
                Address base = this.newAddress(this.in.parseAddress());
                DLL dll = this.findDLLByName(fullPathName);
                boolean mustLoad = true;
                if (dll != null) {
                    this.loadObjects.remove(dll);
                    if (AddressOps.equal(base, dll.getBase())) {
                        mustLoad = false;
                    }
                }
                if (mustLoad) {
                    File file = new File(fullPathName);
                    long size = file.length();
                    String name = file.getName();
                    dll = new DLL(this, fullPathName, size, base);
                    this.nameToDllMap.put(name, dll);
                }
                newLoadObjects.add(dll);
            }
            Iterator dllIter = this.loadObjects.iterator();
            block3: while (dllIter.hasNext()) {
                DLL dll = (DLL)dllIter.next();
                Iterator iter = this.nameToDllMap.keySet().iterator();
                while (iter.hasNext()) {
                    String name = (String)iter.next();
                    if (this.nameToDllMap.get(name) != dll) continue;
                    this.nameToDllMap.remove(name);
                    continue block3;
                }
            }
            this.loadObjects = newLoadObjects;
        }
        catch (IOException e) {
            this.loadObjects = null;
            this.nameToDllMap = null;
            throw new DebuggerException(e);
        }
    }
}

