/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.memory;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.memory.CarSpace;
import sun.jvm.hotspot.memory.Space;
import sun.jvm.hotspot.memory.Train;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class CarTableDesc
extends VMObject {
    private static CIntegerField trainNumberField;
    private static CIntegerField carNumberField;
    private static AddressField trainField;
    private static AddressField spaceField;
    private static long invalid_train_number;
    private static long newgen_train_number;
    private static long special_nonoop_train_number;
    private static long initial_train_number;
    private static long invalid_car_number;
    private static long initial_car_number;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("CarTableDesc");
        trainNumberField = type.getCIntegerField("_train_number");
        carNumberField = type.getCIntegerField("_car_number");
        trainField = type.getAddressField("_train");
        spaceField = type.getAddressField("_space");
        invalid_train_number = db.lookupIntConstant("invalid_train_number").longValue();
        newgen_train_number = db.lookupIntConstant("newgen_train_number").longValue();
        special_nonoop_train_number = db.lookupIntConstant("special_nonoop_train_number").longValue();
        initial_train_number = db.lookupIntConstant("initial_train_number").longValue();
        invalid_car_number = db.lookupIntConstant("invalid_car_number").longValue();
        initial_car_number = db.lookupIntConstant("initial_car_number").longValue();
    }

    public CarTableDesc(Address addr) {
        super(addr);
    }

    public long trainNumber() {
        return trainNumberField.getValue(this.addr);
    }

    public long carNumber() {
        return carNumberField.getValue(this.addr);
    }

    public Train train() {
        return (Train)VMObjectFactory.newObject(Train.class, trainField.getValue(this.addr));
    }

    public CarSpace space() {
        return (CarSpace)VMObjectFactory.newObject(CarSpace.class, spaceField.getValue(this.addr));
    }

    public boolean isNew() {
        return this.trainNumber() == newgen_train_number;
    }

    public boolean isSpecialNonOop() {
        return this.trainNumber() == special_nonoop_train_number;
    }

    public boolean isTrain() {
        return this.trainNumber() != invalid_train_number;
    }

    public boolean isInitialTrain() {
        return this.trainNumber() == initial_train_number;
    }

    public boolean isCar() {
        return this.carNumber() != invalid_car_number;
    }

    public boolean isInitialCar() {
        return this.carNumber() == initial_car_number;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CarTableDesc)) {
            return false;
        }
        CarTableDesc other = (CarTableDesc)obj;
        return this.trainNumber() == other.trainNumber() && this.carNumber() == other.carNumber();
    }

    public boolean lessThan(CarTableDesc arg) {
        return this.trainNumber() < arg.trainNumber() || this.trainNumber() == arg.trainNumber() && this.carNumber() < arg.carNumber();
    }

    public boolean initialize(long trainNumber, long carNumber, Train train, Space sp, boolean shouldScavenge) {
        throw new RuntimeException("not yet implemented");
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                CarTableDesc.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

