/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import sun.jvm.hotspot.oops.HeapVisitor;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.ObjectHistogramElement;
import sun.jvm.hotspot.oops.Oop;

public class ObjectHistogram
implements HeapVisitor {
    private HashMap map = new HashMap();

    public void prologue(long size) {
    }

    public void doObj(Oop obj) {
        Klass klass = obj.getKlass();
        if (!this.map.containsKey(klass)) {
            this.map.put(klass, new ObjectHistogramElement(klass));
        }
        ((ObjectHistogramElement)this.map.get(klass)).updateWith(obj);
    }

    public void epilogue() {
    }

    public List getElements() {
        ArrayList list = new ArrayList();
        list.addAll(this.map.values());
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((ObjectHistogramElement)o1).compare((ObjectHistogramElement)o2);
            }
        });
        return list;
    }

    public void print() {
        this.printOn(System.out);
    }

    public void printOn(PrintStream tty) {
        List list = this.getElements();
        ObjectHistogramElement.titleOn(tty);
        ListIterator iterator = list.listIterator();
        while (iterator.hasNext()) {
            ((ObjectHistogramElement)iterator.next()).printOn(tty);
        }
    }
}

