/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime;

import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.oops.Mark;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.runtime.ObjectMonitor;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;
import sun.jvm.hotspot.utilities.Assert;

public class ObjectSynchronizer {
    private static Address gBlockListAddr;
    private static int blockSize;
    private static long objectMonitorTypeSize;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type;
        try {
            type = db.lookupType("ObjectSynchronizer");
            AddressField blockListField = type.getAddressField("gBlockList");
            gBlockListAddr = blockListField.getValue();
            blockSize = db.lookupIntConstant("ObjectSynchronizer::BLOCK_SIZE");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        type = db.lookupType("ObjectMonitor");
        objectMonitorTypeSize = type.getSize();
    }

    public long identityHashValueFor(Oop obj) {
        Mark mark = obj.getMark();
        if (mark.isUnlocked()) {
            return mark.hash();
        }
        if (mark.hasMonitor()) {
            ObjectMonitor monitor = mark.monitor();
            Mark temp = monitor.header();
            return temp.hash();
        }
        Assert.that(VM.getVM().isDebugging(), "Can not access displaced header otherwise");
        if (mark.hasDisplacedMarkHelper()) {
            Mark temp = mark.displacedMarkHelper();
            return temp.hash();
        }
        return 0L;
    }

    public static Iterator objectMonitorIterator() {
        if (gBlockListAddr != null) {
            return new ObjectMonitorIterator();
        }
        return null;
    }

    static /* synthetic */ Address access$100() {
        return gBlockListAddr;
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                ObjectSynchronizer.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }

    private static class ObjectMonitorIterator
    implements Iterator {
        private ObjectMonitor block;
        private int index;
        private Address blockAddr = ObjectSynchronizer.access$100();

        ObjectMonitorIterator() {
            this.index = blockSize - 1;
            this.block = new ObjectMonitor(this.blockAddr);
        }

        public boolean hasNext() {
            return this.index > 0 || this.block.queue() != null;
        }

        public Object next() {
            Address addr;
            if (this.index > 0) {
                addr = this.blockAddr.addOffsetTo((long)this.index * objectMonitorTypeSize);
            } else {
                this.blockAddr = this.block.queue();
                this.index = blockSize - 1;
                addr = this.blockAddr.addOffsetTo((long)this.index * objectMonitorTypeSize);
            }
            --this.index;
            return new ObjectMonitor(addr);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

